/*
 * Decompiled with CFR 0.152.
 */
package com.github.chromaticforge.freelook.config;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.annotations.DualOption;
import cc.polyfrost.oneconfig.config.annotations.Info;
import cc.polyfrost.oneconfig.config.annotations.KeyBind;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.core.OneKeyBind;
import cc.polyfrost.oneconfig.config.data.InfoType;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.ModType;
import cc.polyfrost.oneconfig.libs.universal.UKeyboard;
import cc.polyfrost.oneconfig.utils.hypixel.HypixelUtils;
import com.github.chromaticforge.freelook.hook.FreelookHook;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0006\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\nR\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0006\u001a\u0004\b\u001d\u0010\b\"\u0004\b\u001e\u0010\nR\"\u0010\u001f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0006\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\nR\"\u0010\"\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u0006\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR\"\u0010%\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u0006\u001a\u0004\b&\u0010\b\"\u0004\b'\u0010\nR\"\u0010(\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\u0006\u001a\u0004\b)\u0010\b\"\u0004\b*\u0010\n\u00a8\u0006+"}, d2={"Lcom/github/chromaticforge/freelook/config/FreelookConfig;", "Lcc/polyfrost/oneconfig/config/Config;", "<init>", "()V", "", "hypixelWarning", "Z", "getHypixelWarning", "()Z", "setHypixelWarning", "(Z)V", "Lcc/polyfrost/oneconfig/config/core/OneKeyBind;", "keyBind", "Lcc/polyfrost/oneconfig/config/core/OneKeyBind;", "getKeyBind", "()Lcc/polyfrost/oneconfig/config/core/OneKeyBind;", "setKeyBind", "(Lcc/polyfrost/oneconfig/config/core/OneKeyBind;)V", "mode", "getMode", "setMode", "", "perspective", "I", "getPerspective", "()I", "setPerspective", "(I)V", "freelook", "getFreelook", "setFreelook", "invertPitch", "getInvertPitch", "setInvertPitch", "lockPitch", "getLockPitch", "setLockPitch", "invertYaw", "getInvertYaw", "setInvertYaw", "smoothCamera", "getSmoothCamera", "setSmoothCamera", "Freelook"})
public final class FreelookConfig
extends Config {
    @NotNull
    public static final FreelookConfig INSTANCE = new FreelookConfig();
    @Info(text="Freelook functionality is disabled on Hypixel!", type=InfoType.INFO, size=2)
    private static boolean hypixelWarning;
    @KeyBind(name="Freelook", subcategory="Controls")
    @NotNull
    private static OneKeyBind keyBind;
    @DualOption(name="Control Mode", left="Toggle", right="Hold", subcategory="Controls")
    private static boolean mode;
    @Dropdown(name="Perspective", options={"First", "Third", "Reverse"}, subcategory="General")
    private static int perspective;
    @DualOption(name="Freelook Mode", left="Freelook", right="Snaplook", subcategory="General")
    private static boolean freelook;
    @Switch(name="Invert Pitch (Up and Down)", subcategory="General")
    private static boolean invertPitch;
    @Switch(name="Pitch Lock", subcategory="General")
    private static boolean lockPitch;
    @Switch(name="Invert Yaw (Left and Right)", subcategory="General")
    private static boolean invertYaw;
    @Switch(name="Smooth Change", subcategory="Camera")
    private static boolean smoothCamera;

    private FreelookConfig() {
        super(new Mod("Freelook", ModType.UTIL_QOL, "/assets/freelook/icon.svg"), "freelook.json");
    }

    public final boolean getHypixelWarning() {
        return hypixelWarning;
    }

    public final void setHypixelWarning(boolean bl) {
        hypixelWarning = bl;
    }

    @NotNull
    public final OneKeyBind getKeyBind() {
        return keyBind;
    }

    public final void setKeyBind(@NotNull OneKeyBind oneKeyBind) {
        Intrinsics.checkNotNullParameter((Object)oneKeyBind, (String)"<set-?>");
        keyBind = oneKeyBind;
    }

    public final boolean getMode() {
        return mode;
    }

    public final void setMode(boolean bl) {
        mode = bl;
    }

    public final int getPerspective() {
        return perspective;
    }

    public final void setPerspective(int n) {
        perspective = n;
    }

    public final boolean getFreelook() {
        return freelook;
    }

    public final void setFreelook(boolean bl) {
        freelook = bl;
    }

    public final boolean getInvertPitch() {
        return invertPitch;
    }

    public final void setInvertPitch(boolean bl) {
        invertPitch = bl;
    }

    public final boolean getLockPitch() {
        return lockPitch;
    }

    public final void setLockPitch(boolean bl) {
        lockPitch = bl;
    }

    public final boolean getInvertYaw() {
        return invertYaw;
    }

    public final void setInvertYaw(boolean bl) {
        invertYaw = bl;
    }

    public final boolean getSmoothCamera() {
        return smoothCamera;
    }

    public final void setSmoothCamera(boolean bl) {
        smoothCamera = bl;
    }

    private static final void _init_$lambda$0() {
        if (!mode) {
            FreelookHook.togglePerspective();
        }
    }

    private static final Boolean _init_$lambda$1() {
        return !HypixelUtils.INSTANCE.isHypixel();
    }

    private static final Boolean _init_$lambda$2() {
        return freelook || HypixelUtils.INSTANCE.isHypixel();
    }

    private static final Boolean _init_$lambda$3() {
        return freelook || HypixelUtils.INSTANCE.isHypixel();
    }

    private static final Boolean _init_$lambda$4() {
        return freelook || HypixelUtils.INSTANCE.isHypixel();
    }

    static {
        int[] nArray = new int[]{UKeyboard.KEY_LMENU};
        keyBind = new OneKeyBind(nArray);
        mode = true;
        perspective = 1;
        lockPitch = true;
        smoothCamera = true;
        INSTANCE.initialize();
        INSTANCE.registerKeyBind(keyBind, FreelookConfig::_init_$lambda$0);
        INSTANCE.hideIf("hypixelWarning", FreelookConfig::_init_$lambda$1);
        INSTANCE.hideIf("invertPitch", FreelookConfig::_init_$lambda$2);
        INSTANCE.hideIf("lockPitch", FreelookConfig::_init_$lambda$3);
        INSTANCE.hideIf("invertYaw", FreelookConfig::_init_$lambda$4);
        INSTANCE.addDependency("invertPitch", "pitch");
        INSTANCE.addDependency("lockPitch", "pitch");
        INSTANCE.addDependency("invertYaw", "yaw");
    }
}

