/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.doaflip;

import com.mrbysco.doaflip.Constants;
import com.mrbysco.doaflip.client.ConfigCache;
import com.mrbysco.doaflip.config.FabricFlipConfig;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1269;

public class DoAFlipFabric
implements ClientModInitializer {
    public static FabricFlipConfig config;

    public void onInitializeClient() {
        ConfigHolder configHolder = AutoConfig.register(FabricFlipConfig.class, Toml4jConfigSerializer::new);
        configHolder.registerLoadListener((holder, config) -> {
            ConfigCache.setFlipChance((float)config.client.flipChance);
            ConfigCache.setInvertMobs(config.client.invertMobs);
            ConfigCache.generateEntityList(config.client.flippingMobs);
            ConfigCache.setMinimumFallDistance(config.client.minimumFallDistance);
            return class_1269.field_5811;
        });
        configHolder.registerSaveListener((holder, config) -> {
            ConfigCache.setFlipChance((float)config.client.flipChance);
            ConfigCache.setInvertMobs(config.client.invertMobs);
            ConfigCache.generateEntityList(config.client.flippingMobs);
            ConfigCache.setMinimumFallDistance(config.client.minimumFallDistance);
            return class_1269.field_5811;
        });
        DoAFlipFabric.config = (FabricFlipConfig)configHolder.getConfig();
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Paths.get("config", new String[0]).register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Thread watchThread = new Thread(() -> {
                try {
                    WatchKey key;
                    while ((key = watchService.take()) != null) {
                        if (Thread.currentThread().isInterrupted()) {
                            watchService.close();
                            break;
                        }
                        for (WatchEvent<?> event : key.pollEvents()) {
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW || !((Path)event.context()).endsWith("doaflip.toml")) continue;
                            Constants.LOGGER.info("Reloading DoAFlip's Client config");
                            if (!configHolder.load()) continue;
                            config = (FabricFlipConfig)configHolder.getConfig();
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Failed to close filesystem watcher", (Throwable)e);
                }
            }, "DoAFlip's Client Config Watcher");
            watchThread.start();
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to create filesystem watcher for configs", (Throwable)e);
        }
    }
}

