/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.doaflip.client;

import com.mrbysco.doaflip.FlipState;
import com.mrbysco.doaflip.client.ConfigCache;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class FlipHandler {
    private static final class_5819 random = class_5819.method_43047();
    private static final String PREVENT_FLIP = "prevent_flip";
    private static final String FLIP_START_TICK_KEY = "flip_start_tick";
    private static final String FLIP_PROGRESS_KEY = "flip_progress";
    private static final String FLIP_DURATION = "flip_duration";
    private static final String FRONT_FLIP = "front_flip";

    public static void doFlipping(class_10042 renderState, class_4587 poseStack, float partialTicks) {
        float totalDuration;
        if (!(renderState instanceof FlipState)) {
            return;
        }
        FlipState flipState = (FlipState)renderState;
        if (!flipState.doAFlip$canFlip() || flipState.doAFlip$isFlying()) {
            return;
        }
        class_2487 persistentData = flipState.doAFlip$persistentData();
        if (flipState.doAFlip$shouldResetData()) {
            persistentData.method_10551(PREVENT_FLIP);
            persistentData.method_10551(FLIP_START_TICK_KEY);
            persistentData.method_10551(FLIP_PROGRESS_KEY);
            persistentData.method_10551(FLIP_DURATION);
            persistentData.method_10551(FRONT_FLIP);
            return;
        }
        if (persistentData.method_10545(PREVENT_FLIP)) {
            return;
        }
        double distanceFromGround = flipState.doAFlip$distanceFromGround();
        if (distanceFromGround <= (double)ConfigCache.minimumFallDistance) {
            return;
        }
        if (flipState.doAFlip$isFalling() && !persistentData.method_10545(FLIP_START_TICK_KEY)) {
            float flipProbability = ConfigCache.flipChance;
            float randomFloat = random.method_43057();
            if (randomFloat < flipProbability) {
                totalDuration = (float)class_3532.method_15350((double)(distanceFromGround * 1.0), (double)5.0, (double)30.0);
                persistentData.method_10548(FLIP_START_TICK_KEY, renderState.field_53328);
                persistentData.method_10548(FLIP_PROGRESS_KEY, 0.0f);
                persistentData.method_10548(FLIP_DURATION, totalDuration);
                persistentData.method_10556(FRONT_FLIP, random.method_43056());
            } else {
                persistentData.method_10556(PREVENT_FLIP, true);
            }
        }
        if (persistentData.method_10545(FLIP_START_TICK_KEY)) {
            float startAge = persistentData.method_66563(FLIP_START_TICK_KEY, 0.0f);
            float progress = persistentData.method_66563(FLIP_PROGRESS_KEY, 0.0f);
            float f = totalDuration = persistentData.method_10545(FLIP_DURATION) ? persistentData.method_66563(FLIP_DURATION, 0.0f) : 10.0f;
            if (progress < 1.0f) {
                boolean doesFrontFlip = persistentData.method_68566(FRONT_FLIP, false);
                float rotationAngle = 360.0f * progress + 180.0f * partialTicks / totalDuration;
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(doesFrontFlip ? -rotationAngle : rotationAngle));
                poseStack.method_22904(0.0, (double)(-renderState.field_53330 / 2.0f), 0.0);
                float currentAge = renderState.field_53328;
                progress = (currentAge - startAge) / totalDuration;
                persistentData.method_10548(FLIP_PROGRESS_KEY, progress);
            } else {
                persistentData.method_10551(FLIP_START_TICK_KEY);
                persistentData.method_10551(FLIP_PROGRESS_KEY);
                persistentData.method_10551(FLIP_DURATION);
                persistentData.method_10551(FRONT_FLIP);
                persistentData.method_10556(PREVENT_FLIP, true);
            }
        }
    }

    public static double getDistanceFromGround(class_1309 livingEntity) {
        class_2338 checkPos;
        class_2680 belowState;
        int distance;
        class_2338 pos = livingEntity.method_24515();
        class_1937 level = livingEntity.method_73183();
        for (distance = 1; distance < 32 && !(belowState = level.method_8320(checkPos = pos.method_10087(distance))).method_26168((class_1922)level, checkPos, (class_1297)livingEntity); ++distance) {
        }
        return distance - 1;
    }

    public static boolean canFlip(class_1309 livingEntity) {
        return ConfigCache.invertMobs != ConfigCache.mobs.contains(livingEntity.method_5864());
    }
}

