/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.doaflip.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.doaflip.FlipState;
import com.mrbysco.doaflip.client.ConfigCache;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class FlipHandler {
    private static final RandomSource random = RandomSource.create();
    private static final String PREVENT_FLIP = "prevent_flip";
    private static final String FLIP_START_TICK_KEY = "flip_start_tick";
    private static final String FLIP_PROGRESS_KEY = "flip_progress";
    private static final String FLIP_DURATION = "flip_duration";
    private static final String FRONT_FLIP = "front_flip";

    public static void doFlipping(LivingEntityRenderState renderState, PoseStack poseStack, float partialTicks) {
        float totalDuration;
        if (!(renderState instanceof FlipState)) {
            return;
        }
        FlipState flipState = (FlipState)renderState;
        if (!flipState.doAFlip$canFlip() || flipState.doAFlip$isFlying()) {
            return;
        }
        CompoundTag persistentData = flipState.doAFlip$persistentData();
        if (flipState.doAFlip$shouldResetData()) {
            persistentData.remove(PREVENT_FLIP);
            persistentData.remove(FLIP_START_TICK_KEY);
            persistentData.remove(FLIP_PROGRESS_KEY);
            persistentData.remove(FLIP_DURATION);
            persistentData.remove(FRONT_FLIP);
            return;
        }
        if (persistentData.contains(PREVENT_FLIP)) {
            return;
        }
        double distanceFromGround = flipState.doAFlip$distanceFromGround();
        if (distanceFromGround <= (double)ConfigCache.minimumFallDistance) {
            return;
        }
        if (flipState.doAFlip$isFalling() && !persistentData.contains(FLIP_START_TICK_KEY)) {
            float flipProbability = ConfigCache.flipChance;
            float randomFloat = random.nextFloat();
            if (randomFloat < flipProbability) {
                totalDuration = (float)Mth.clamp((double)(distanceFromGround * 1.0), (double)5.0, (double)30.0);
                persistentData.putFloat(FLIP_START_TICK_KEY, renderState.ageInTicks);
                persistentData.putFloat(FLIP_PROGRESS_KEY, 0.0f);
                persistentData.putFloat(FLIP_DURATION, totalDuration);
                persistentData.putBoolean(FRONT_FLIP, random.nextBoolean());
            } else {
                persistentData.putBoolean(PREVENT_FLIP, true);
            }
        }
        if (persistentData.contains(FLIP_START_TICK_KEY)) {
            float startAge = persistentData.getFloatOr(FLIP_START_TICK_KEY, 0.0f);
            float progress = persistentData.getFloatOr(FLIP_PROGRESS_KEY, 0.0f);
            float f = totalDuration = persistentData.contains(FLIP_DURATION) ? persistentData.getFloatOr(FLIP_DURATION, 0.0f) : 10.0f;
            if (progress < 1.0f) {
                boolean doesFrontFlip = persistentData.getBooleanOr(FRONT_FLIP, false);
                float rotationAngle = 360.0f * progress + 180.0f * partialTicks / totalDuration;
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(doesFrontFlip ? -rotationAngle : rotationAngle));
                poseStack.translate(0.0, (double)(-renderState.boundingBoxHeight / 2.0f), 0.0);
                float currentAge = renderState.ageInTicks;
                progress = (currentAge - startAge) / totalDuration;
                persistentData.putFloat(FLIP_PROGRESS_KEY, progress);
            } else {
                persistentData.remove(FLIP_START_TICK_KEY);
                persistentData.remove(FLIP_PROGRESS_KEY);
                persistentData.remove(FLIP_DURATION);
                persistentData.remove(FRONT_FLIP);
                persistentData.putBoolean(PREVENT_FLIP, true);
            }
        }
    }

    public static double getDistanceFromGround(LivingEntity livingEntity) {
        BlockPos checkPos;
        BlockState belowState;
        int distance;
        BlockPos pos = livingEntity.blockPosition();
        Level level = livingEntity.level();
        for (distance = 1; distance < 32 && !(belowState = level.getBlockState(checkPos = pos.below(distance))).entityCanStandOn((BlockGetter)level, checkPos, (Entity)livingEntity); ++distance) {
        }
        return distance - 1;
    }

    public static boolean canFlip(LivingEntity livingEntity) {
        return ConfigCache.invertMobs != ConfigCache.mobs.contains(livingEntity.getType());
    }
}

