/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.doaflip.config;

import com.mrbysco.doaflip.Constants;
import com.mrbysco.doaflip.client.ConfigCache;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeFlipConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded Do A Flip's config file {}", (Object)configEvent.getConfig().getFileName());
        NeoForgeFlipConfig.refreshCache();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.warn("Do A Flip's config just got changed on the file system!");
        NeoForgeFlipConfig.refreshCache();
    }

    private static void refreshCache() {
        ConfigCache.setFlipChance(((Double)NeoForgeFlipConfig.CLIENT.flipChance.get()).floatValue());
        ConfigCache.setInvertMobs((Boolean)NeoForgeFlipConfig.CLIENT.invertMobs.get());
        ConfigCache.generateEntityList((List)NeoForgeFlipConfig.CLIENT.flippingMobs.get());
        ConfigCache.setMinimumFallDistance((Integer)NeoForgeFlipConfig.CLIENT.minimumFallDistance.get());
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.DoubleValue flipChance;
        public final ModConfigSpec.IntValue minimumFallDistance;
        public final ModConfigSpec.BooleanValue invertMobs;
        public final ModConfigSpec.ConfigValue<List<? extends String>> flippingMobs;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Flip settings").push("flip");
            this.flipChance = builder.comment("The chance of a flip happening when a mob falls from a high enough distance [0.0 = 0%, 0.1 = 10%, 1.0 = 100%] (Default: 0.35)").defineInRange("flipChance", 0.35, 0.0, 1.0);
            this.minimumFallDistance = builder.comment("The minimum fall distance required for a mob to flip (Between 1 and 32) [default: 3]").defineInRange("minimumFallDistance", 3, 1, 32);
            this.invertMobs = builder.comment("When enabled turns the flippingMobs option into a blacklist [default: true]").define("invertMobs", true);
            this.flippingMobs = builder.comment("Defines a list of mobs that can flip when falling from a high enough distance [Format: modid:entity]").defineListAllowEmpty("flippingMobs", () -> List.of("minecraft:bat", "minecraft:armor_stand", "minecraft:ender_dragon", "minecraft:wither"), String::new, o -> {
                String string;
                return o instanceof String && ResourceLocation.tryParse((String)(string = (String)o)) != null;
            });
            builder.pop();
        }
    }
}

