/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.animation.FBPPlacingAnimationManager;
import hantonik.fbp.particle.FBPRainParticle;
import hantonik.fbp.particle.FBPSnowParticle;
import hantonik.fbp.util.FBPConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class MixinLevelRenderer
implements ResourceManagerReloadListener,
AutoCloseable {
    @Final
    @Shadow
    private Minecraft f_109461_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;

    @Inject(at={@At(value="HEAD")}, method={"tickRain"})
    private void tickRain(Camera camera, CallbackInfo callback) {
        if (FancyBlockParticles.CONFIG.global.isEnabled() && !FancyBlockParticles.CONFIG.global.isFreezeEffect() && (FancyBlockParticles.CONFIG.rain.isEnabled() || FancyBlockParticles.CONFIG.snow.isEnabled())) {
            float f = this.f_109465_.m_46722_(1.0f);
            float f2 = Minecraft.m_91405_() ? 1.0f : 2.0f;
            if (f / f2 <= 0.0f) {
                return;
            }
            float rainDensity = FancyBlockParticles.CONFIG.rain.getParticleDensity() * 4.0f * (float)FancyBlockParticles.CONFIG.rain.getSimulationDistance() / 2.0f;
            float snowDensity = FancyBlockParticles.CONFIG.snow.getParticleDensity() * 4.0f * (float)FancyBlockParticles.CONFIG.snow.getSimulationDistance() / 2.0f;
            float density = Math.max(rainDensity, snowDensity);
            int i = 0;
            while ((float)i < density) {
                double angle = FBPConstants.RANDOM.nextDouble() * Math.PI * 2.0;
                float radius = Mth.m_14116_((float)FBPConstants.RANDOM.nextFloat()) * (float)Math.max(FancyBlockParticles.CONFIG.rain.getSimulationDistance(), FancyBlockParticles.CONFIG.snow.getSimulationDistance()) / 2.0f * 16.0f;
                double x = this.f_109461_.f_91075_.m_20185_() + (double)radius * Math.cos(angle);
                double y = this.f_109461_.f_91075_.m_20186_();
                double z = this.f_109461_.f_91075_.m_20189_() + (double)radius * Math.sin(angle);
                BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                int surfaceHeight = this.f_109465_.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_();
                Biome.Precipitation precipitation = ((Biome)this.f_109465_.m_204166_(pos).m_203334_()).m_264600_(pos);
                if (!(this.f_109461_.f_91075_.m_20182_().m_82554_(new Vec3(x, y, z)) > (double)((float)(precipitation == Biome.Precipitation.RAIN ? FancyBlockParticles.CONFIG.rain.getSimulationDistance() : FancyBlockParticles.CONFIG.snow.getSimulationDistance()) * 16.0f))) {
                    if ((y = (double)((int)(y + 25.0 + FBPConstants.RANDOM.nextDouble() * 10.0))) <= (double)(surfaceHeight + 2)) {
                        y = surfaceHeight + 10;
                    }
                    if (precipitation == Biome.Precipitation.RAIN) {
                        if (FancyBlockParticles.CONFIG.rain.isEnabled() && (float)i < rainDensity) {
                            this.f_109461_.f_91061_.m_107344_(new FBPRainParticle.Provider().createParticle(ParticleTypes.f_123761_.m_6012_(), this.f_109465_, x, y, z, 0.0, 0.0, 0.0));
                        }
                    } else if (precipitation == Biome.Precipitation.SNOW && FancyBlockParticles.CONFIG.snow.isEnabled() && (float)i < snowDensity) {
                        this.f_109461_.f_91061_.m_107344_(new FBPSnowParticle.Provider().createParticle(ParticleTypes.f_123761_.m_6012_(), this.f_109465_, x, y, z, 0.0, 0.0, 0.0));
                    }
                }
                ++i;
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), method={"tickRain"})
    private void addParticle(ClientLevel instance, ParticleOptions particleOptions, double x, double y, double z, double xd, double yd, double zd) {
        if (FancyBlockParticles.CONFIG.global.isEnabled()) {
            if (particleOptions.m_6012_() == ParticleTypes.f_123762_ && FancyBlockParticles.CONFIG.smoke.isEnabled()) {
                return;
            }
            if (particleOptions.m_6012_() == ParticleTypes.f_123761_ && FancyBlockParticles.CONFIG.rain.isEnabled()) {
                return;
            }
        }
        instance.m_7106_(particleOptions, x, y, z, xd, yd, zd);
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;")}, method={"renderSnowAndRain"})
    private Biome.Precipitation getPrecipitationAt(Biome instance, BlockPos pos, Operation<Biome.Precipitation> original) {
        if (FancyBlockParticles.CONFIG.global.isEnabled()) {
            if (original.call(new Object[]{instance, pos}) == Biome.Precipitation.RAIN && FancyBlockParticles.CONFIG.rain.isEnabled()) {
                return Biome.Precipitation.NONE;
            }
            if (original.call(new Object[]{instance, pos}) == Biome.Precipitation.SNOW && FancyBlockParticles.CONFIG.snow.isEnabled()) {
                return Biome.Precipitation.NONE;
            }
        }
        return (Biome.Precipitation)original.call(new Object[]{instance, pos});
    }

    @Inject(at={@At(value="HEAD")}, method={"renderHitOutline"}, cancellable=true)
    private void renderHitOutline(PoseStack stack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, CallbackInfo callback) {
        if (!FancyBlockParticles.CONFIG.animations.isRenderOutline() && FBPPlacingAnimationManager.isHidden(pos)) {
            callback.cancel();
        }
    }
}

