/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import lombok.Generated;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrailParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class FBPTrailParticle
extends TrailParticle
implements IKillableParticle {
    private final Vector3d rotation;
    private final float multiplier;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean killToggle;

    protected FBPTrailParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, Vec3 target, int color) {
        super(level, x, y, z, xd, yd, zd, target, color);
        this.quadSize = FancyBlockParticles.CONFIG.trail.getSizeMultiplier() * (FancyBlockParticles.CONFIG.trail.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.6f, 1.0f) : 1.0f) * 3.0f;
        this.scaleAlpha = this.quadSize * 0.82f;
        this.rotation = new Vector3d(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0);
        this.sprite = FBPConstants.FBP_PARTICLE_SPRITE.get();
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()) + 0.5f);
        this.multiplier = FancyBlockParticles.CONFIG.trail.isRandomFadingSpeed() ? Mth.clamp((float)FBPConstants.RANDOM.nextFloat(0.5f, 0.9f), (float)0.6f, (float)0.8f) : 0.75f;
        this.scale(1.0f);
    }

    public Particle scale(float scale) {
        super.scale(scale);
        float size = this.quadSize / 10.0f;
        this.setBoundingBox(new AABB(this.x - (double)size, this.y - (double)size, this.z - (double)size, this.x + (double)size, this.y + (double)size, this.z + (double)size));
        return this;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastSize = this.quadSize;
        this.lastAlpha = this.alpha;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.trail.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.trail.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.age;
                }
                if (this.age < this.lifetime) {
                    double progress = (double)this.age / (double)this.lifetime;
                    this.x = Mth.lerp((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.x, (double)this.target.x);
                    this.y = Mth.lerp((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.y, (double)this.target.y);
                    this.z = Mth.lerp((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.z, (double)this.target.z);
                }
                if (this.age + 10 >= this.lifetime) {
                    this.quadSize *= 0.9f * this.multiplier;
                    if ((double)this.alpha >= 0.01 && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= 0.7f * this.multiplier;
                    }
                    if ((double)this.alpha < 0.01) {
                        this.remove();
                    }
                }
            }
        }
    }

    private static double easeInOutCubic(double input) {
        return input < 0.5 ? 4.0 * input * input * input : 1.0 - Math.pow(-2.0 * input + 2.0, 3.0) / 2.0;
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    public int getLightColor(float partialTick) {
        float factor = Mth.clamp((float)(((float)this.age + partialTick) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        j = Math.min((int)(factor * 15.0f * 16.0f) + j, 240);
        i = j | k << 16;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void render(VertexConsumer buffer, Camera info, float partialTick) {
        float u = this.sprite.getU(0.275f);
        float v = this.sprite.getV(0.275f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize) / 70.0f;
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        this.putCube(buffer, u, v, posX, posY, posZ, scale, this.rotation, light, this.rCol, this.gCol, this.bCol, alpha);
    }

    private void putCube(VertexConsumer buffer, float u, float v, double xPos, double yPos, double zPos, double scale, Vector3d rotation, int light, float rCol, float gCol, float bCol, float alpha) {
        float radX = (float)Math.toRadians(rotation.x);
        float radY = (float)Math.toRadians(rotation.y);
        float radZ = (float)Math.toRadians(rotation.z);
        float brightness = 1.0f;
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3d v1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.95f;
            this.addVertex(buffer, v1, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, v2, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, v3, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, v4, u, v, light, red, green, blue, alpha);
        }
    }

    private void addVertex(VertexConsumer buffer, Vector3d pos, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        buffer.addVertex((float)pos.x, (float)pos.y, (float)pos.z).setUv(u, v).setColor(rCol, gCol, bCol, alpha).setLight(light);
    }

    public static class Provider
    implements ParticleProvider<TrailParticleOption> {
        @Nullable
        public Particle createParticle(TrailParticleOption type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.trail.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPTrailParticle(level, x, y, z, xd, yd, zd, type.target(), type.color());
        }

        @Generated
        public Provider() {
        }
    }
}

