/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.animation.FBPPlacingAnimationManager;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.platform.Services;
import hantonik.fbp.util.FBPConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.compress.utils.Lists;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPPlacingAnimationParticle
extends Particle
implements IKillableParticle {
    private final BlockState state;
    private final BlockPos pos;
    private final BakedModel model;
    private final Vec3 rotation;
    private final Vec2 slide;
    private final float angleY;
    private boolean killToggle;

    public FBPPlacingAnimationParticle(ClientLevel level, BlockState state, BlockPos pos, LivingEntity placer, InteractionHand hand) {
        super(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        this.state = state;
        this.pos = pos;
        this.model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.animations.getMinLifetime(), FancyBlockParticles.CONFIG.animations.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.animations.getMinLifetime(), FancyBlockParticles.CONFIG.animations.getMaxLifetime()) + 0.5f);
        Vector3f horizontalLook = placer.getLookAngle().toVector3f().mul(-1.0f, 0.0f, -1.0f).normalize();
        float handMultiplier = placer.getMainArm() == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        Matrix3f changeOfBasis = new Matrix3f((Vector3fc)new Vector3f(horizontalLook.z, 0.0f, -horizontalLook.x).mul(hand == InteractionHand.MAIN_HAND ? handMultiplier : -handMultiplier), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)horizontalLook);
        this.rotation = FBPConstants.ANIMATION_ROTATION;
        Vector3f translation = FBPConstants.ANIMATION_TRANSLATION.toVector3f();
        float slidePow = translation.length();
        if (placer.getXRot() <= 0.0f) {
            translation.mul(1.0f, -1.0f, 1.0f);
        }
        Vector3f slideDir = this.adjustDirection(level, placer, translation.mul((Matrix3fc)changeOfBasis));
        Vec3 animationDir = new Vec3(slideDir.normalize());
        this.angleY = (float)Math.atan2(slideDir.x, slideDir.z);
        Vec3 yRot = animationDir.yRot(-this.angleY);
        this.slide = new Vec2((float)yRot.z, (float)yRot.y).scale(slidePow);
        this.hasPhysics = false;
    }

    public boolean canUpdate(FBPPlacingAnimationParticle another) {
        return this.state.is(another.state.getBlock()) && this.pos.equals((Object)another.pos) && this.rotation.equals((Object)another.rotation) && this.slide.equals(another.slide) && this.angleY == another.angleY;
    }

    public FBPPlacingAnimationParticle setAge(int age) {
        this.age = age;
        return this;
    }

    public int getAge() {
        return this.age;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!FancyBlockParticles.CONFIG.animations.isEnabled() || !FancyBlockParticles.CONFIG.isBlockAnimationsEnabled(this.state.getBlock())) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused() && !this.removed) {
            if (this.killToggle) {
                this.remove();
            }
            ++this.age;
            if (this.age == this.lifetime + 1) {
                FBPPlacingAnimationManager.showBlock(this.pos, false);
            }
            if (this.age >= this.lifetime + 2) {
                this.remove();
            }
        }
        if (this.level.getBlockState(this.pos) != this.state) {
            this.remove();
        }
    }

    public void remove() {
        FBPPlacingAnimationManager.showBlock(this.pos, true);
        super.remove();
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public int getLightColor(float partialTick) {
        return this.level.hasChunkAt(this.pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockState)this.state, (BlockPos)this.pos) : 0;
    }

    public void render(VertexConsumer buffer, Camera info, float partialTick) {
        PoseStack stack = new PoseStack();
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x + 0.5;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y + 0.5;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z + 0.5;
        stack.translate(posX, posY, posZ);
        float progress = Math.min(1.0f, ((float)this.age + partialTick) / ((float)this.lifetime + 1.0f));
        Vec3 offset = this.state.getOffset((BlockGetter)this.level, this.pos);
        stack.translate(offset.x, offset.y, offset.z);
        stack.mulPose(Axis.YP.rotation(this.angleY));
        this.slideIn(stack, progress);
        this.rotate(stack, progress);
        this.scale(stack, progress);
        stack.mulPose(Axis.YP.rotation(-this.angleY));
        stack.translate(-offset.x, -offset.y, -offset.z);
        stack.translate(-0.5f, -0.5f, -0.5f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Services.CLIENT.renderBlock(this.level, this.model, this.state, this.pos, stack, bufferSource);
        bufferSource.endBatch();
    }

    private void slideIn(PoseStack stack, float progress) {
        Vec2 translate = this.slide.scale(1.0f - this.exponent(0.9f, progress));
        stack.translate(0.0f, translate.y, translate.x);
    }

    private void rotate(PoseStack stack, float progress) {
        Vector3f rotation = this.rotation.scale((double)(1.0f - this.exponent(-0.08f, progress))).toVector3f();
        Vector3f pivot = FBPConstants.ANIMATION_PIVOT.toVector3f();
        if ((double)this.slide.y < 0.0) {
            pivot.mul(1.0f, -1.0f, 1.0f);
            rotation.mul(-1.0f, 1.0f, -1.0f);
        }
        stack.translate(pivot.x, pivot.y, pivot.z);
        stack.mulPose(Axis.XP.rotation(rotation.x));
        stack.mulPose(Axis.YP.rotation(rotation.y));
        stack.mulPose(Axis.ZP.rotation(rotation.z));
        stack.translate(-pivot.x, -pivot.y, -pivot.z);
    }

    private void scale(PoseStack stack, float progress) {
        float startScale = FancyBlockParticles.CONFIG.animations.getSizeMultiplier();
        float scale = startScale + (1.0f - startScale) * this.exponent(-0.7f, progress);
        stack.scale(scale, scale, scale);
    }

    private Vector3f adjustDirection(ClientLevel level, LivingEntity placer, Vector3f slideDir) {
        ArrayList emptyDirections = Lists.newArrayList();
        for (Direction side : Direction.values()) {
            BlockPos sidePos = this.pos.relative(side);
            VoxelShape sideCollision = level.getBlockState(sidePos).getCollisionShape((BlockGetter)level, sidePos);
            if (sideCollision.isEmpty()) {
                emptyDirections.add(side);
                continue;
            }
            if (side.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                if (!(sideCollision.min(side.getAxis()) > 0.25)) continue;
                emptyDirections.add(side);
                continue;
            }
            if (!(sideCollision.min(side.getAxis()) < 0.75)) continue;
            emptyDirections.add(side);
        }
        for (Direction side : FBPPlacingAnimationParticle.getAffectedDirections(slideDir.x, slideDir.y, slideDir.z)) {
            if (emptyDirections.contains(side)) continue;
            slideDir.sub((Vector3fc)side.step().absolute().mul((Vector3fc)slideDir));
        }
        if (!emptyDirections.isEmpty() && slideDir.length() == 0.0f) {
            emptyDirections.sort(Comparator.comparingInt(List.of(Direction.orderedByNearest((Entity)placer))::indexOf));
            slideDir.set((Vector3fc)((Direction)emptyDirections.get(0)).step());
        }
        return slideDir;
    }

    private static List<Direction> getAffectedDirections(float x, float y, float z) {
        return (List)Util.make((Object)Lists.newArrayList(), list -> {
            if (x > 0.0f) {
                list.add(Direction.EAST);
            }
            if (x < 0.0f) {
                list.add(Direction.WEST);
            }
            if (y > 0.0f) {
                list.add(Direction.UP);
            }
            if (y < 0.0f) {
                list.add(Direction.DOWN);
            }
            if (z > 0.0f) {
                list.add(Direction.SOUTH);
            }
            if (z < 0.0f) {
                list.add(Direction.NORTH);
            }
        });
    }

    private float exponent(float curve, float time) {
        double base = curve > 0.0f ? -Math.log(curve) : Math.log(-curve) - 1.0;
        return (float)(base * Math.pow(1.0 / base + 1.0, time) - base);
    }
}

