/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen.component;

import com.google.common.collect.ImmutableList;
import hantonik.fbp.screen.FBPAbstractOptionsScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import org.jetbrains.annotations.Nullable;

public class FBPOptionsList
extends ContainerObjectSelectionList<Entry> {
    private final FBPAbstractOptionsScreen screen;

    public FBPOptionsList(Minecraft minecraft, int width, int height, FBPAbstractOptionsScreen screen) {
        super(minecraft, width, height - screen.layout.getFooterHeight(), screen.layout.getHeaderHeight(), 25);
        this.centerListVertically = false;
        this.screen = screen;
    }

    public void addBig(AbstractWidget widget) {
        this.addEntry((AbstractSelectionList.Entry)Entry.create(widget, this.screen));
    }

    public void addBig(AbstractWidget ... widgets) {
        for (AbstractWidget widget : widgets) {
            this.addBig(widget);
        }
    }

    public void addSmall(AbstractWidget leftWidget, @Nullable AbstractWidget rightWidget) {
        this.addEntry((AbstractSelectionList.Entry)Entry.create(leftWidget, rightWidget, this.screen));
    }

    public void addSmall(AbstractWidget ... widgets) {
        for (int i = 0; i < widgets.length; i += 2) {
            AbstractWidget widget = i < widgets.length - 1 ? widgets[i + 1] : null;
            this.addSmall(widgets[i], widget);
        }
    }

    public int getRowWidth() {
        return 400;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    protected static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final List<AbstractWidget> widgets;
        private final FBPAbstractOptionsScreen screen;

        private Entry(List<AbstractWidget> widgets, FBPAbstractOptionsScreen screen) {
            this.widgets = ImmutableList.copyOf(widgets);
            this.screen = screen;
        }

        private static Entry create(AbstractWidget widget, FBPAbstractOptionsScreen screen) {
            return new Entry(List.of(widget), screen);
        }

        private static Entry create(AbstractWidget leftWidget, @Nullable AbstractWidget rightWidget, FBPAbstractOptionsScreen screen) {
            return rightWidget == null ? new Entry(List.of(leftWidget), screen) : new Entry(List.of(leftWidget, rightWidget), screen);
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = 0;
            int j = this.screen.width / 2 - 155;
            for (AbstractWidget widget : this.widgets) {
                widget.setPosition(i + j, top);
                widget.render(graphics, mouseX, mouseY, partialTick);
                i += 160;
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.widgets;
        }
    }
}

