/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp;

import com.mojang.logging.LogUtils;
import hantonik.fbp.animation.FBPPlacingAnimationManager;
import hantonik.fbp.config.FBPConfig;
import hantonik.fbp.init.FBPKeyMappings;
import hantonik.fbp.platform.Services;
import hantonik.fbp.screen.FBPAbstractOptionsScreen;
import hantonik.fbp.screen.FBPFastBlacklistScreen;
import hantonik.fbp.screen.FBPOculusWarningScreen;
import hantonik.fbp.screen.FBPOptionsScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class FancyBlockParticles {
    public static final String MOD_ID = "fbp";
    public static final String MOD_NAME = "FancyBlockParticles";
    public static final String MOD_VERSION = Services.PLATFORM.getModVersion("fbp");
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker SETUP_MARKER = MarkerFactory.getMarker((String)"SETUP");
    public static final FBPConfig CONFIG = FBPConfig.create();
    private static boolean OCULUS_WARNING_SCREEN_SHOWN = false;

    public static void postClientTick(Minecraft client) {
        if (FBPKeyMappings.TOGGLE_MOD.consumeClick()) {
            FancyBlockParticles.CONFIG.global.setEnabled(!FancyBlockParticles.CONFIG.global.isEnabled());
            CONFIG.save();
        }
        if (FBPKeyMappings.TOGGLE_ANIMATIONS.consumeClick() && !Services.PLATFORM.isModLoaded("a_good_place")) {
            FancyBlockParticles.CONFIG.animations.setEnabled(!FancyBlockParticles.CONFIG.animations.isEnabled());
            CONFIG.save();
        }
        if (FBPKeyMappings.OPEN_SETTINGS.consumeClick()) {
            client.setScreen((Screen)new FBPOptionsScreen(null));
        }
        if (FBPKeyMappings.ADD_TO_BLACKLIST.isDown()) {
            if (Screen.hasShiftDown()) {
                ItemStack heldItem = client.player.getMainHandItem();
                if (heldItem.getItem() instanceof BlockItem) {
                    client.setScreen((Screen)new FBPFastBlacklistScreen(heldItem));
                }
            } else {
                HitResult hit = client.hitResult;
                if (hit != null && hit.getType() == HitResult.Type.BLOCK) {
                    client.setScreen((Screen)new FBPFastBlacklistScreen(((BlockHitResult)hit).getBlockPos()));
                }
            }
            CONFIG.save();
        }
        if (FBPKeyMappings.FREEZE_PARTICLES.consumeClick() && FancyBlockParticles.CONFIG.global.isEnabled()) {
            FancyBlockParticles.CONFIG.global.setFreezeEffect(!FancyBlockParticles.CONFIG.global.isFreezeEffect());
            CONFIG.save();
        }
        if (FBPKeyMappings.RELOAD_CONFIG.consumeClick()) {
            CONFIG.load();
            CONFIG.save();
        }
    }

    public static void onRenderHud(GuiGraphics graphics) {
        if (FancyBlockParticles.CONFIG.global.isEnabled() && FancyBlockParticles.CONFIG.overlay.isFreezeEffectOverlay() && FancyBlockParticles.CONFIG.global.isFreezeEffect() && !Minecraft.getInstance().options.hideGui) {
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.fbp.freeze_effect").withStyle(ChatFormatting.BOLD), graphics.guiWidth() / 2, 5, FancyBlockParticles.CONFIG.overlay.getFreezeEffectColor() | 0xFF000000);
        }
    }

    public static void onClientPause(Screen screen) {
        if (!(screen instanceof FBPAbstractOptionsScreen)) {
            CONFIG.save();
        }
    }

    public static void postScreenInit(Screen screen) {
        if (!OCULUS_WARNING_SCREEN_SHOWN && !FancyBlockParticles.CONFIG.global.isDisableOculusWarning() && screen instanceof TitleScreen && Services.PLATFORM.isModLoaded("oculus")) {
            Minecraft.getInstance().setScreen((Screen)new FBPOculusWarningScreen(screen));
            OCULUS_WARNING_SCREEN_SHOWN = true;
        }
    }

    public static void onLevelLoad() {
        FBPPlacingAnimationManager.clear();
    }
}

