/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.config.FBPConfig;
import hantonik.fbp.init.FBPKeyMappings;
import hantonik.fbp.screen.FBPOptionsScreen;
import hantonik.fbp.screen.component.FBPOptionsList;
import hantonik.fbp.screen.component.widget.button.FBPSliderButton;
import hantonik.fbp.screen.component.widget.button.FBPToggleButton;
import java.net.URI;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public abstract class FBPAbstractOptionsScreen
extends Screen {
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 62, 74);
    private final FBPConfig activeConfig;
    protected final FBPConfig config;
    protected final Screen lastScreen;
    protected FBPOptionsList list;

    public FBPAbstractOptionsScreen(Component title, Screen lastScreen, FBPConfig config) {
        super((Component)Component.translatable((String)"key.fbp.category").append(" - ").append(title));
        this.activeConfig = config;
        this.config = config.copy();
        this.lastScreen = lastScreen;
    }

    protected void init() {
        ((ImageButton)this.layout.addToHeader((LayoutElement)new ImageButton(25, 25, FBPOptionsScreen.LOGO_SPRITES, button -> this.handleComponentClicked(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://www.curseforge.com/minecraft/mc-mods/fbp-renewed")))), CommonComponents.EMPTY), settings -> settings.alignHorizontallyLeft().alignVerticallyTop().padding(10))).setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.fbp.common.homepage")));
        ((ImageButton)this.layout.addToHeader((LayoutElement)new ImageButton(25, 25, FBPOptionsScreen.REPORT_SPRITES, button -> this.handleComponentClicked(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://github.com/Hantonik/FancyBlockParticles/issues")))), CommonComponents.EMPTY), settings -> settings.alignHorizontallyRight().alignVerticallyTop().padding(10))).setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.fbp.common.report")));
        this.layout.addToHeader((LayoutElement)new StringWidget(this.title, this.font), LayoutSettings::alignHorizontallyCenter);
        this.list = (FBPOptionsList)this.addRenderableWidget((GuiEventListener)new FBPOptionsList(this.minecraft, this.width, this));
        this.initOptions();
        GridLayout footer = new GridLayout();
        footer.defaultCellSetting().paddingHorizontal(5).paddingBottom(4).alignHorizontallyCenter();
        GridLayout.RowHelper footerHelper = footer.createRowHelper(2);
        footerHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"button.fbp.common.reload"), button -> {
            FancyBlockParticles.CONFIG.load();
            this.config.setConfig(FancyBlockParticles.CONFIG.copy());
            this.activeConfig.setConfig(FancyBlockParticles.CONFIG.copy());
            this.minecraft.setScreen((Screen)new AlertScreen(() -> this.minecraft.setScreen((Screen)this), (Component)Component.translatable((String)"button.fbp.common.reload"), (Component)Component.translatable((String)"screen.fbp.reload_alert")));
            this.rebuildWidgets();
        }).width(310).build(), 2);
        footerHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"button.fbp.common.reset"), button -> this.minecraft.setScreen((Screen)new ConfirmScreen(confirm -> {
            if (confirm) {
                this.resetConfig();
                this.rebuildWidgets();
            }
            this.minecraft.setScreen((Screen)this);
        }, (Component)Component.translatable((String)"button.fbp.common.reset"), (Component)Component.translatable((String)"screen.fbp.reset_confirm")))).width(150).build());
        footerHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"button.fbp.common.done"), button -> this.onDone()).width(150).build());
        this.layout.addToFooter((LayoutElement)footer);
        MutableComponent version = Component.translatable((String)"text.fbp.version", (Object[])new Object[]{SharedConstants.getCurrentVersion().name() + "-" + FancyBlockParticles.MOD_VERSION});
        this.layout.addToFooter((LayoutElement)new StringWidget(this.font.width((FormattedText)version), 9, (Component)version, this.font), settings -> settings.alignHorizontallyLeft().alignVerticallyBottom().paddingLeft(5).paddingBottom(3));
        this.layout.visitWidgets(widget -> {
            if (widget instanceof FBPToggleButton || widget instanceof FBPSliderButton) {
                widget.active = !this.activeConfig.global.isLocked();
            }
        });
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected abstract void initOptions();

    protected abstract void resetConfig();

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.list.updateSize(this.width, this.layout);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && modifiers == 0) {
            this.onDone();
            return true;
        }
        if (FBPKeyMappings.OPEN_SETTINGS.matches(keyCode, scanCode)) {
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        Screen screen = this.lastScreen;
        if (screen instanceof FBPAbstractOptionsScreen) {
            FBPAbstractOptionsScreen screen2 = (FBPAbstractOptionsScreen)screen;
            double scrollAmount = screen2.list.scrollAmount();
            screen2.rebuildWidgets();
            screen2.list.setScrollAmount(scrollAmount);
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void onDone() {
        this.activeConfig.setConfig(this.config);
        FancyBlockParticles.CONFIG.setConfig(this.activeConfig);
        FancyBlockParticles.CONFIG.save();
        this.onClose();
    }

    protected Button openScreenButton(Component title, Supplier<Screen> screen) {
        return this.openScreenButton(title, screen, 150, 20);
    }

    protected Button openScreenButton(Component title, Supplier<Screen> screen, int width, int height) {
        return Button.builder((Component)title, onPress -> this.minecraft.setScreen((Screen)screen.get())).size(width, height).build();
    }
}

