/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.init.FBPKeyMappings;
import hantonik.fbp.screen.component.widget.button.FBPBlacklistButton;
import hantonik.fbp.util.BlacklistMode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.lwjgl.glfw.GLFW;

public class FBPFastBlacklistScreen
extends Screen {
    private static final WidgetSprites INDICATOR_SPRITES = new WidgetSprites(ResourceLocation.tryBuild((String)"fbp", (String)"blacklist/indicator"), ResourceLocation.tryBuild((String)"fbp", (String)"blacklist/indicator_inactive"));
    private static final ResourceLocation INDICATOR_BACKGROUND_SPRITE = ResourceLocation.tryBuild((String)"fbp", (String)"blacklist/indicator_background");
    private final BlockState state;
    private final ItemStack displayStack;
    private FBPBlacklistButton animationButton;
    private FBPBlacklistButton particleButton;

    public FBPFastBlacklistScreen(BlockPos lookingAtPos) {
        super((Component)Component.translatable((String)"screen.fbp.fast_blacklist"));
        this.state = Minecraft.getInstance().level.getBlockState(lookingAtPos);
        this.displayStack = new ItemStack((ItemLike)this.state.getBlock());
    }

    public FBPFastBlacklistScreen(ItemStack heldItem) {
        super((Component)Component.translatable((String)"screen.fbp.fast_blacklist"));
        this.state = ((BlockItem)heldItem.getItem()).getBlock().defaultBlockState();
        this.displayStack = heldItem;
    }

    protected void init() {
        int x = this.width / 2;
        int y = this.height / 2;
        this.animationButton = (FBPBlacklistButton)this.addRenderableWidget((GuiEventListener)new FBPBlacklistButton(x - 130, y + 5, false, FancyBlockParticles.CONFIG.isBlockAnimationsEnabled(this.state.getBlock()) ? BlacklistMode.FANCY : BlacklistMode.BLACKLISTED, button -> {
            FancyBlockParticles.CONFIG.toggleAnimations(this.state.getBlock());
            this.onClose();
        }));
        this.particleButton = (FBPBlacklistButton)this.addRenderableWidget((GuiEventListener)new FBPBlacklistButton(x + 70, y + 5, true, FancyBlockParticles.CONFIG.getBlockParticlesMode(this.state.getBlock()), button -> {
            FancyBlockParticles.CONFIG.toggleParticles(this.state.getBlock());
            this.onClose();
        }));
        this.grabMouse();
    }

    public void tick() {
        super.tick();
        if (!this.minecraft.mouseHandler.isMouseGrabbed()) {
            this.grabMouse();
        }
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (FBPKeyMappings.ADD_TO_BLACKLIST.matches(keyCode, scanCode)) {
            for (GuiEventListener widget : this.children()) {
                FBPBlacklistButton button;
                if (!(widget instanceof FBPBlacklistButton) || !(button = (FBPBlacklistButton)widget).isHovered()) continue;
                button.onPress();
                return true;
            }
            this.onClose();
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderMenuBackground(graphics);
        int x = this.width / 2;
        int y = this.height / 2;
        mouseX = Mth.clamp((int)mouseX, (int)(this.animationButton.getX() + 30), (int)(this.particleButton.getX() + 30));
        mouseY = y + 35;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, INDICATOR_BACKGROUND_SPRITE, this.animationButton.getX() + 30, this.animationButton.getY() + 30 - 10, 200, 20);
        graphics.drawCenteredString(this.font, (Component)Component.literal((String)"<").withStyle(this.animationButton.active ? ChatFormatting.GREEN : ChatFormatting.RED).append("             ").append((Component)Component.literal((String)">").withStyle(this.particleButton.active ? ChatFormatting.GREEN : ChatFormatting.RED)), this.animationButton.getX() + 30 + 100, this.animationButton.getY() + 30 - 4, -1);
        graphics.drawCenteredString(this.font, (Component)this.title.copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), x, 10, -1);
        ResourceLocation displayId = BuiltInRegistries.ITEM.getKey((Object)this.displayStack.getItem());
        graphics.drawCenteredString(this.font, (Component)Component.literal((String)displayId.getNamespace()).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)":").withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)displayId.getPath()).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.BOLD), x, y - 19, -1);
        if (this.animationButton.isHovered()) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tooltip.fbp.animation").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.AQUA}), this.animationButton.getX() + 30, this.animationButton.getY() + 30 - 42, -1);
            graphics.drawCenteredString(this.font, (Component)(this.animationButton.getBlacklistMode() == BlacklistMode.FANCY ? Component.translatable((String)"tooltip.fbp.fancy").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}) : Component.translatable((String)"tooltip.fbp.disabled").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED})), this.animationButton.getX() + 30, this.animationButton.getY() + 30 + 35, -1);
        }
        if (this.particleButton.isHovered()) {
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tooltip.fbp.particles").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.AQUA}), this.particleButton.getX() + 30, this.particleButton.getY() + 30 - 42, -1);
            switch (this.particleButton.getBlacklistMode()) {
                case FANCY: {
                    graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tooltip.fbp.fancy").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), this.particleButton.getX() + 30, this.particleButton.getY() + 30 + 35, -1);
                    break;
                }
                case VANILLA: {
                    graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tooltip.fbp.vanilla").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), this.particleButton.getX() + 30, this.particleButton.getY() + 30 + 35, -1);
                    break;
                }
                case BLACKLISTED: {
                    graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tooltip.fbp.disabled").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), this.particleButton.getX() + 30, this.particleButton.getY() + 30 + 35, -1);
                }
            }
        }
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)x - 32.0f, (float)y - 32.0f - 57.0f);
        graphics.pose().scale(4.0f, 4.0f);
        graphics.renderFakeItem(this.displayStack, 0, 0);
        graphics.pose().popMatrix();
        this.animationButton.render(graphics, mouseX, mouseY, partialTick);
        this.particleButton.render(graphics, mouseX, mouseY, partialTick);
        FBPBlacklistButton hovered = this.animationButton.isHovered() ? this.animationButton : (this.particleButton.isHovered() ? this.particleButton : null);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, INDICATOR_SPRITES.get(true, hovered != null && !hovered.active), mouseX - 10, mouseY - 10, 20, 20);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        FancyBlockParticles.CONFIG.save();
        super.onClose();
    }

    private void grabMouse() {
        GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().getWindow(), (int)208897, (int)212994);
    }
}

