/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.init.FBPKeyMappings;
import hantonik.fbp.particle.group.FBPParticleGroup;
import hantonik.fbp.screen.FBPOptionsScreen;
import hantonik.fbp.util.FBPConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientPauseChangeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleGroupsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="fbp", dist={Dist.CLIENT})
public final class FBPNeoForge {
    public FBPNeoForge(IEventBus bus, ModContainer container) {
        if (FMLLoader.getCurrent().getDist() == Dist.CLIENT) {
            FancyBlockParticles.LOGGER.info(FancyBlockParticles.SETUP_MARKER, "Initializing...");
            bus.register((Object)this);
            bus.addListener(this::onRegisterKeyMappings);
            bus.addListener(this::onRegisterParticleGroups);
            bus.addListener(this::onRegisterClientReloadListeners);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, modsScreen) -> new FBPOptionsScreen(modsScreen)));
        }
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        FancyBlockParticles.LOGGER.info(FancyBlockParticles.SETUP_MARKER, "Starting client setup...");
        NeoForge.EVENT_BUS.addListener(this::postClientTick);
        NeoForge.EVENT_BUS.addListener(this::postRenderGuiLayer);
        NeoForge.EVENT_BUS.addListener(this::postClientPauseChange);
        NeoForge.EVENT_BUS.addListener(this::postScreenInit);
        NeoForge.EVENT_BUS.addListener(this::onClientLoggingIn);
        FancyBlockParticles.LOGGER.info(FancyBlockParticles.SETUP_MARKER, "Finished client setup!");
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        FBPKeyMappings.MAPPINGS.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private void onRegisterParticleGroups(RegisterParticleGroupsEvent event) {
        event.register(FBPConstants.FBP_PARTICLE_RENDER, engine -> new FBPParticleGroup((ParticleEngine)engine, FBPConstants.FBP_PARTICLE_RENDER));
        event.register(FBPConstants.FBP_TERRAIN_RENDER, engine -> new FBPParticleGroup((ParticleEngine)engine, FBPConstants.FBP_TERRAIN_RENDER));
    }

    private void onRegisterClientReloadListeners(AddClientReloadListenersEvent event) {
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"fbp", (String)"config"), (PreparableReloadListener)((ResourceManagerReloadListener)manager -> FancyBlockParticles.CONFIG.load()));
    }

    private void postClientTick(ClientTickEvent.Post event) {
        FancyBlockParticles.postClientTick(Minecraft.getInstance());
    }

    private void postRenderGuiLayer(RenderGuiLayerEvent.Post event) {
        FancyBlockParticles.onRenderHud(event.getGuiGraphics());
    }

    private void postClientPauseChange(ClientPauseChangeEvent.Post event) {
        if (event.isPaused()) {
            FancyBlockParticles.onClientPause(Minecraft.getInstance().screen);
        }
    }

    private void postScreenInit(ScreenEvent.Init.Post event) {
        FancyBlockParticles.postScreenInit(event.getScreen());
    }

    private void onClientLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        FancyBlockParticles.onLevelLoad();
    }
}

