/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CampfireSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPCampfireSmokeParticle
extends CampfireSmokeParticle
implements IKillableParticle {
    private final Vector3f[] rotatedNormal;
    private final Quaternionf rotation;
    private final float uo;
    private final float vo;
    private final float multiplier;
    private double xdo;
    private double zdo;
    private final float targetAlpha;
    private final float scaleAlpha;
    private float lastAlpha;
    private final float targetSize;
    private float lastSize;
    private boolean blocked;
    private boolean killToggle;

    protected FBPCampfireSmokeParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, boolean isSignal, TextureAtlasSprite sprite) {
        super(level, x, y, z, xd, yd, zd, isSignal, sprite);
        this.rCol = 0.62f;
        this.gCol = 0.59f;
        this.bCol = 0.56f;
        this.targetAlpha = FancyBlockParticles.CONFIG.campfireSmoke.getTransparency();
        this.alpha = 0.0f;
        this.targetSize = FancyBlockParticles.CONFIG.campfireSmoke.getSizeMultiplier() * 6.0f * (FancyBlockParticles.CONFIG.campfireSmoke.isRandomSize() ? this.quadSize : 1.0f);
        this.scaleAlpha = this.targetSize * 0.85f;
        this.quadSize = 0.0f;
        this.hasPhysics = true;
        this.rotatedNormal = new Vector3f[FBPConstants.CUBE_NORMALS.length];
        this.rotation = new Quaternionf().rotateY(this.random.nextFloat());
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            this.rotatedNormal[i] = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)this.rotation, new Vector3f());
        }
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.multiplier = FancyBlockParticles.CONFIG.campfireSmoke.isRandomFadingSpeed() ? Mth.clamp((float)FBPConstants.RANDOM.nextFloat(0.85f, 1.1f), (float)0.95f, (float)1.0f) : 0.95f;
        this.scale(1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastAlpha = this.alpha;
        this.lastSize = this.quadSize;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.campfireSmoke.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                ++this.age;
                if (this.age >= this.lifetime) {
                    this.quadSize *= 0.98f * this.multiplier;
                    if ((double)this.alpha >= 0.001 && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= 0.96f * this.multiplier;
                    }
                    if ((double)this.alpha < 0.001) {
                        this.remove();
                    }
                } else {
                    if (this.quadSize < this.targetSize) {
                        this.quadSize += 0.17f * this.multiplier;
                        if (this.quadSize > this.targetSize) {
                            this.quadSize = this.targetSize;
                        }
                    }
                    if (this.alpha < this.targetAlpha) {
                        this.alpha += 0.1f * this.multiplier;
                        if (this.alpha > this.targetAlpha) {
                            this.alpha = this.targetAlpha;
                        }
                    }
                }
                this.xd += this.random.nextDouble() * (this.random.nextBoolean() ? 1.0 : -1.0) / 5000.0;
                this.yd -= (double)this.gravity;
                this.zd += this.random.nextDouble() * (this.random.nextBoolean() ? 1.0 : -1.0) / 5000.0;
                this.move(this.xd, this.yd, this.zd);
                if (this.y == this.yo) {
                    if (!this.blocked) {
                        this.xdo = this.xd;
                        this.zdo = this.zd;
                    }
                    this.blocked = true;
                    if (Math.abs(this.xd) < Math.abs(this.xdo) + 0.035) {
                        this.xd *= 1.1;
                    }
                    if (Math.abs(this.zd) < Math.abs(this.zdo) + 0.035) {
                        this.zd *= 1.1;
                    }
                } else if (this.blocked) {
                    this.blocked = false;
                    this.xd = Mth.lerp((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.xd, (double)this.xdo);
                    this.zd = Mth.lerp((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.zd, (double)this.zdo);
                }
                if (this.onGround) {
                    this.xd *= 0.9;
                    this.zd *= 0.9;
                }
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (x != xo) {
            this.xd = 0.0;
        }
        if (z != zo) {
            this.zd = 0.0;
        }
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TERRAIN;
    }

    protected int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void extract(QuadParticleRenderState renderState, Camera info, float partialTick) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.sprite.getU(this.uo / 4.0f);
            v0 = this.sprite.getV(this.vo / 4.0f);
        }
        float u1 = this.sprite.getU((this.uo + 1.0f) / 4.0f);
        float v1 = this.sprite.getV((this.vo + 1.0f) / 4.0f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize);
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale / 20.0f, this.rotatedNormal, this.rotation, u0, u1, v0, v1, light, this.rCol, this.gCol, this.bCol, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    private void putCube(QuadParticleRenderState renderState, float x, float y, float z, float scale, Vector3f[] rotatedNormal, Quaternionf rotation, float u0, float u1, float v0, float v1, int light, float rCol, float gCol, float bCol, float alpha, boolean isCartoon) {
        float brightness = 1.0f;
        for (int i = 0; i < rotatedNormal.length; ++i) {
            Vector3f normal = rotatedNormal[i];
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotation.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.875f;
            if (isCartoon) {
                renderState.add(this.getLayer(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u1, u1, v1, v1, ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue), light);
                continue;
            }
            renderState.add(this.getLayer(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u0, u1, v0, v1, ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    public record Provider(boolean isSignal) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd, RandomSource random) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.campfireSmoke.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPCampfireSmokeParticle(level, x, y, z, xd, yd, zd, this.isSignal, Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.QUARTZ_BLOCK.defaultBlockState()));
        }
    }
}

