/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPFlameParticle
extends FlameParticle
implements IKillableParticle {
    private final Vector3d startPos;
    private final Vector3f[] rotatedNormal;
    private final Quaternionf rotation;
    private final boolean isSoulFire;
    private final float multiplier;
    private boolean hasChild;
    private float startSize;
    private float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean killToggle;

    public FBPFlameParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, boolean isSoulFire, boolean hasChild) {
        super(level, x, y, z, xd, yd, zd, FBPConstants.FBP_PARTICLE_SPRITE.get());
        this.yd = -8.5E-4;
        this.gravity = -0.05f;
        this.isSoulFire = isSoulFire;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 0.0f;
        if (this.isSoulFire) {
            this.rCol = 0.2f;
            this.bCol = 0.9f;
        }
        this.alpha = 1.0f;
        this.quadSize = FancyBlockParticles.CONFIG.flame.getSizeMultiplier() * (FancyBlockParticles.CONFIG.flame.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.6f, 1.0f) : 1.0f) * 2.5f;
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.flame.getMinLifetime(), FancyBlockParticles.CONFIG.flame.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.flame.getMinLifetime(), FancyBlockParticles.CONFIG.flame.getMaxLifetime()) + 0.5f);
        this.startPos = new Vector3d(x, y, z);
        this.rotatedNormal = new Vector3f[FBPConstants.CUBE_NORMALS.length];
        this.rotation = new Quaternionf().rotateY(this.random.nextFloat());
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            this.rotatedNormal[i] = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)this.rotation, new Vector3f());
        }
        this.hasChild = hasChild;
        this.multiplier = FancyBlockParticles.CONFIG.flame.isRandomFadingSpeed() ? FBPConstants.RANDOM.nextFloat(0.9875f, 1.0f) : 1.0f;
        this.scale(1.0f);
    }

    public FBPFlameParticle scale(float scale) {
        super.scale(scale);
        this.startSize = this.quadSize;
        this.scaleAlpha = this.quadSize * 0.35f;
        float size = this.quadSize / 80.0f;
        this.setBoundingBox(new AABB(this.x - (double)size, this.y - (double)size, this.z - (double)size, this.x + (double)size, this.y + (double)size, this.z + (double)size));
        return this;
    }

    public float getQuadSize(float scale) {
        float factor = ((float)this.age + scale) / (float)this.lifetime;
        return this.quadSize * (1.0f - factor * factor * 0.5f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastAlpha = this.alpha;
        this.lastSize = this.quadSize;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.flame.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.flame.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.age;
                }
                if (this.age >= this.lifetime) {
                    this.quadSize *= this.multiplier * 0.95f;
                    if ((double)this.alpha >= 0.01 && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= this.multiplier * 0.95f;
                    }
                    BlockState state = this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
                    if ((double)this.alpha < 0.01) {
                        this.remove();
                    } else if ((double)this.alpha <= 0.325 && this.hasChild && (state.getBlock() instanceof TorchBlock || state.getBlock() instanceof CandleBlock)) {
                        this.hasChild = false;
                        Minecraft.getInstance().particleEngine.add((Particle)new FBPFlameParticle(this.level, this.startPos.x, this.startPos.y, this.startPos.z, 0.0, 0.0, 0.0, this.isSoulFire, false));
                    }
                }
                this.yd -= 0.02 * (double)this.gravity;
                this.move(0.0, this.yd, 0.0);
                this.yd *= 0.95;
                if (this.onGround) {
                    this.xd *= 0.9;
                    this.zd *= 0.9;
                }
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (x != xo) {
            this.xd = 0.0;
        }
        if (z != zo) {
            this.zd = 0.0;
        }
    }

    protected void setLocationFromBoundingbox() {
        super.setLocationFromBoundingbox();
        AABB box = this.getBoundingBox();
        this.y = (box.minY + box.maxY) / 2.0;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TERRAIN;
    }

    public int getLightColor(float partialTick) {
        float factor = Mth.clamp((float)(((float)this.age + partialTick) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        j = Math.min((int)(factor * 15.0f * 16.0f) + j, 240);
        i = j | k << 16;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void extract(QuadParticleRenderState renderState, Camera info, float partialTick) {
        float u = this.sprite.getU(0.275f);
        float v = this.sprite.getV(0.275f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize);
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        if (this.age >= this.lifetime) {
            float f = this.gCol = this.isSoulFire ? Math.min(1.0f, scale / this.startSize * 1.2f) : scale / this.startSize;
            if (this.isSoulFire) {
                this.bCol = Math.min(1.0f, scale / this.startSize * 1.2f);
            }
        }
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale / 80.0f, this.rotatedNormal, this.rotation, u, v, light, this.rCol, this.gCol, this.bCol, alpha);
    }

    private void putCube(QuadParticleRenderState renderState, float x, float y, float z, float scale, Vector3f[] rotatedNormal, Quaternionf rotation, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        for (int i = 0; i < rotatedNormal.length; ++i) {
            Vector3f normal = rotatedNormal[i];
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotation.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.95f;
            renderState.add(this.getLayer(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u, u, v, v, ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    @Nullable
    private static FBPFlameParticle create(ClientLevel level, double x, double y, double z, double xd, double zd, float scale, boolean isSoulFire) {
        if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.flame.isSpawnWhileFrozen()) {
            return null;
        }
        BlockState state = level.getBlockState(BlockPos.containing((double)x, (double)y, (double)z));
        if (state.getBlock() instanceof TorchBlock || state.getBlock() instanceof CandleBlock) {
            y += 0.04;
        }
        return new FBPFlameParticle(level, x, y - 0.06, z, xd, FBPConstants.RANDOM.nextDouble() * 0.025, zd, isSoulFire, !(state.getBlock() instanceof TorchBlock) && !(state.getBlock() instanceof CandleBlock)).scale(scale);
    }

    public record SmallFlameProvider() implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd, RandomSource random) {
            return FBPFlameParticle.create(level, x, y, z, xd, zd, 0.5f, false);
        }
    }

    public record Provider(boolean isSoulFire) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd, RandomSource random) {
            return FBPFlameParticle.create(level, x, y, z, xd, zd, 1.0f, this.isSoulFire);
        }
    }
}

