/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.particle.api.IFBPRendererParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class FBPTerrainParticle
extends TerrainParticle
implements IFBPRendererParticle,
IKillableParticle {
    private final Vector3d rotation;
    private final Vector3d rotationStep;
    private final Vector3d lastRotation;
    private final float multiplier;
    private final boolean destroyed;
    private final double startY;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private double lastXSpeed;
    private double lastZSpeed;
    private boolean wasFrozen;
    private boolean wasInWater;
    private boolean killToggle;
    private boolean modeDebounce;

    public FBPTerrainParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float scale, float rCol, float gCol, float bCol, BlockPos pos, BlockState state, @Nullable Direction side, @Nullable TextureAtlasSprite sprite) {
        super(level, x, y, z, xd, yd, zd, state, pos);
        this.pos = pos;
        if (!state.is(Blocks.GRASS_BLOCK) || side == Direction.UP) {
            int i = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)this.level, pos, 0);
            this.rCol = (float)(i >> 16 & 0xFF) / 255.0f;
            this.gCol = (float)(i >> 8 & 0xFF) / 255.0f;
            this.bCol = (float)(i & 0xFF) / 255.0f;
        } else {
            this.rCol = rCol;
            this.gCol = gCol;
            this.bCol = bCol;
        }
        if ((double)scale < -1.0 && side == Direction.UP && FancyBlockParticles.CONFIG.terrain.isSmartBreaking()) {
            this.xd *= 1.5;
            this.yd *= 0.1;
            this.zd *= 1.5;
            double speed = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
            double cameraXRot = Minecraft.getInstance().getCameraEntity().getLookAngle().x;
            double cameraZRot = Minecraft.getInstance().getCameraEntity().getLookAngle().z;
            this.xd = (cameraXRot < 0.0 ? cameraXRot - 0.01 : cameraXRot + 0.01) * speed;
            this.zd = (cameraZRot < 0.0 ? cameraZRot - 0.01 : cameraZRot + 0.01) * speed;
        }
        float size = (double)scale > -1.0 ? scale : this.quadSize;
        this.quadSize = FancyBlockParticles.CONFIG.terrain.getSizeMultiplier() * (FancyBlockParticles.CONFIG.terrain.isRandomSize() ? size : 1.0f) / 10.0f;
        this.gravity *= FancyBlockParticles.CONFIG.terrain.getGravityMultiplier();
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.terrain.getMinLifetime(), FancyBlockParticles.CONFIG.terrain.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.terrain.getMinLifetime(), FancyBlockParticles.CONFIG.terrain.getMaxLifetime()) + 0.5f);
        this.startY = this.y;
        this.scaleAlpha = this.quadSize * 0.82f;
        this.rotation = new Vector3d();
        this.lastRotation = new Vector3d();
        this.rotationStep = new Vector3d(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0);
        this.rotation.set((Vector3dc)this.rotationStep);
        boolean bl = this.modeDebounce = !FancyBlockParticles.CONFIG.terrain.isRandomRotation();
        if (this.modeDebounce) {
            this.rotation.zero();
            this.calculateYAngle();
        }
        boolean bl2 = this.destroyed = side == null;
        if (sprite == null) {
            List quads;
            if (!this.destroyed && !(quads = ((BlockModelPart)Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(state).collectParts(this.random).getFirst()).getQuads(side)).isEmpty()) {
                this.sprite = ((BakedQuad)quads.getFirst()).sprite();
            }
            if (this.sprite.atlasLocation() == MissingTextureAtlasSprite.getLocation()) {
                this.sprite = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(state);
            }
        } else {
            this.sprite = sprite;
        }
        this.multiplier = FancyBlockParticles.CONFIG.terrain.isRandomFadingSpeed() ? Mth.clamp((float)FBPConstants.RANDOM.nextFloat(0.5f, 0.9f), (float)0.6f, (float)0.8f) : 0.75f;
        this.scale(1.0f);
    }

    public Particle scale(float scale) {
        super.scale(scale);
        float size = this.quadSize / 10.0f;
        if (FancyBlockParticles.CONFIG.terrain.isRestOnFloor() && this.destroyed) {
            this.y = this.startY - (double)size;
        }
        this.yo = this.y;
        this.setBoundingBox(new AABB(this.x - (double)size, this.y - (double)size, this.z - (double)size, this.x + (double)size, this.y + (double)size, this.z + (double)size));
        return this;
    }

    public FBPTerrainParticle setPower(float power) {
        super.setPower(power);
        this.yd = (this.yd - 0.1) * (double)(this.multiplier / 2.0f) + (double)0.1f;
        return this;
    }

    public FBPTerrainParticle setYSpeed(double yd) {
        this.yd = yd;
        return this;
    }

    public void tick() {
        if (FancyBlockParticles.CONFIG.terrain.isBounceOffWalls()) {
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!Minecraft.getInstance().isPaused() && this.age > 0) {
                    if (!this.wasFrozen && (Math.abs(this.xd) > 1.0E-5 || Math.abs(this.zd) > 1.0E-5)) {
                        if (this.xo == this.x) {
                            this.xd = -this.lastXSpeed * 0.625;
                        }
                        if (this.zo == this.z) {
                            this.zd = -this.lastZSpeed * 0.625;
                        }
                        if (!(FancyBlockParticles.CONFIG.terrain.isRandomRotation() || this.xo != this.x && this.zo != this.z)) {
                            this.calculateYAngle();
                        }
                    } else {
                        this.wasFrozen = false;
                    }
                }
            } else {
                this.wasFrozen = true;
            }
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastRotation.set((Vector3dc)this.rotation);
        this.lastSize = this.quadSize;
        this.lastAlpha = this.alpha;
        if (!(FancyBlockParticles.CONFIG.global.isEnabled() && ((!this.destroyed || FancyBlockParticles.CONFIG.terrain.isFancyBreakingParticles() || FancyBlockParticles.CONFIG.terrain.isFancyFallingDustParticles()) && (this.destroyed || FancyBlockParticles.CONFIG.terrain.isFancyCrackingParticles()) || FancyBlockParticles.CONFIG.misc.isFancySnowballParticles() || FancyBlockParticles.CONFIG.misc.isFancySlimeParticles() || FancyBlockParticles.CONFIG.misc.isFancyBreakingSplashPotionParticles()))) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                    if (!this.modeDebounce) {
                        this.modeDebounce = true;
                        this.rotation.z = 0.0;
                        this.calculateYAngle();
                    }
                    double x = Math.abs(this.rotationStep.x * this.getMultiplier());
                    if (this.xd > 0.0) {
                        if (this.zd > 0.0) {
                            this.rotation.x -= x;
                        } else if (this.zd < 0.0) {
                            this.rotation.x += x;
                        }
                    } else if (this.xd < 0.0) {
                        if (this.zd < 0.0) {
                            this.rotation.x += x;
                        } else if (this.zd > 0.0) {
                            this.rotation.x -= x;
                        }
                    }
                } else {
                    if (this.modeDebounce) {
                        this.modeDebounce = false;
                        this.rotation.z = FBPConstants.RANDOM.nextDouble(30.0, 400.0);
                    }
                    this.rotation.add((Vector3dc)this.rotationStep.mul(this.getMultiplier(), new Vector3d()));
                }
                if (!FancyBlockParticles.CONFIG.terrain.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.age;
                }
                if (this.age >= this.lifetime) {
                    this.quadSize *= 0.9f * this.multiplier;
                    if ((double)this.alpha >= 0.01 && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= 0.7f * this.multiplier;
                    }
                    if ((double)this.alpha < 0.01) {
                        this.remove();
                    }
                }
                this.move(this.xd, this.yd, this.zd);
                if (this.onGround && FancyBlockParticles.CONFIG.terrain.isRestOnFloor()) {
                    this.rotation.x = (double)Math.round(this.rotation.x / 10.0) * 10.0;
                    this.rotation.z = (double)Math.round(this.rotation.z / 10.0) * 10.0;
                }
                if (Math.abs(this.xd) > 1.0E-5) {
                    this.lastXSpeed = this.xd;
                }
                if (Math.abs(this.zd) > 1.0E-5) {
                    this.lastZSpeed = this.zd;
                }
                this.xd *= 0.98;
                this.zd *= 0.98;
                this.yd *= 0.98;
                if (!this.level.noCollision(this.getBoundingBox().deflate(1.0E-7))) {
                    this.moveTowardsClosestSpace(this.x, (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.z);
                }
                if (FancyBlockParticles.CONFIG.terrain.isEntityCollision()) {
                    List entities = this.level.getEntities(null, this.getBoundingBox());
                    for (Entity entity : entities) {
                        if (entity.noPhysics) continue;
                        double x = this.x - entity.position().x;
                        double y = this.y - entity.position().y;
                        double z = this.z - entity.position().z;
                        double distance = Mth.absMax((double)Mth.absMax((double)x, (double)y), (double)z);
                        if (!(distance >= 0.01)) continue;
                        distance = Math.sqrt(distance);
                        double d = Math.min(1.0 / distance, 1.0);
                        this.xd += (x /= distance) * d / 20.0;
                        this.yd += (y /= distance) * d / 20.0 - 0.04 * (double)this.gravity;
                        this.zd += (z /= distance) * d / 20.0;
                        if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                            this.calculateYAngle();
                        }
                        if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) continue;
                        this.onGround = false;
                    }
                }
                if (FancyBlockParticles.CONFIG.terrain.isWaterPhysics() && this.isInWater(this.getBoundingBox())) {
                    this.xd *= 0.95;
                    this.zd *= 0.95;
                    if (this.yd > -0.005 && this.yd < 0.005) {
                        this.yd = 0.005;
                    }
                    this.yd = this.yd < 0.0 ? (this.yd *= 0.79 * FBPConstants.RANDOM.nextDouble(0.8, 1.2)) : (this.yd *= 1.1 * FBPConstants.RANDOM.nextDouble(0.75, 0.9));
                    if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                        this.calculateYAngle();
                    }
                    this.onGround = false;
                    this.wasInWater = true;
                } else {
                    if (!this.onGround) {
                        this.yd -= (this.wasInWater ? 0.02 : 0.04) * (double)this.gravity;
                    }
                    this.wasInWater = false;
                }
                if (this.onGround) {
                    if (FancyBlockParticles.CONFIG.terrain.isLowTraction()) {
                        this.xd *= 0.932;
                        this.zd *= 0.932;
                    } else {
                        this.xd *= 0.665;
                        this.zd *= 0.665;
                    }
                }
            }
        }
    }

    private void moveTowardsClosestSpace(double x, double y, double z) {
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 vec = new Vec3(x - (double)pos.getX(), y - (double)pos.getY(), z - (double)pos.getZ());
        BlockPos.MutableBlockPos relativePos = new BlockPos.MutableBlockPos();
        double minDistance = Double.MAX_VALUE;
        Direction distanceDirection = Direction.UP;
        for (Direction direction : Direction.values()) {
            double distance;
            relativePos.setWithOffset((Vec3i)pos, direction);
            if (this.level.getBlockState((BlockPos)relativePos).isCollisionShapeFullBlock((BlockGetter)this.level, (BlockPos)relativePos)) continue;
            double axisDistance = vec.get(direction.getAxis());
            double d = distance = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - axisDistance : axisDistance;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            distanceDirection = direction;
        }
        int step = distanceDirection.getAxisDirection().getStep();
        float rand = this.random.nextFloat() * 0.1f + 0.1f;
        Vec3 movement = new Vec3(this.xd, this.yd, this.zd).scale(0.75);
        this.xd = movement.x;
        this.yd = movement.y;
        this.zd = movement.z;
        switch (distanceDirection.getAxis()) {
            case X: {
                this.xd = (float)step * rand;
                break;
            }
            case Y: {
                this.yd = (float)step * rand;
                break;
            }
            case Z: {
                this.zd = (float)step * rand;
            }
        }
        this.onGround = false;
    }

    private boolean isInWater(AABB box) {
        if (!this.touchingUnloadedChunk()) {
            box = box.deflate(0.001);
            int minX = Mth.floor((double)box.minX);
            int maxX = Mth.ceil((double)box.maxX);
            int minY = Mth.floor((double)box.minY);
            int maxY = Mth.ceil((double)box.maxY);
            int minZ = Mth.floor((double)box.minZ);
            int maxZ = Mth.ceil((double)box.maxZ);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                        FluidState fluid = this.level.getFluidState(pos);
                        if (!fluid.is(FluidTags.WATER) || !((double)(fluid.getHeight((BlockGetter)this.level, pos) + (float)y) >= box.minY)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        Vec3 center = this.getBoundingBox().inflate(1.0).getCenter();
        return !this.level.isLoaded(BlockPos.containing((double)center.x, (double)center.y, (double)center.z));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (!FancyBlockParticles.CONFIG.terrain.isLowTraction() && !FancyBlockParticles.CONFIG.terrain.isBounceOffWalls()) {
            if (x != xo) {
                this.xd *= 0.7;
            }
            if (z != zo) {
                this.zd *= 0.7;
            }
        }
    }

    protected void setLocationFromBoundingbox() {
        super.setLocationFromBoundingbox();
        AABB box = this.getBoundingBox();
        this.y = (box.minY + box.maxY) / 2.0;
    }

    public ParticleRenderType getGroup() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    public int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = 0;
        AABB box = this.getBoundingBox();
        BlockPos pos = BlockPos.containing((double)this.x, (double)(this.y + (box.maxY - box.minY) * 0.66 + 0.01 - (FancyBlockParticles.CONFIG.terrain.isRestOnFloor() ? (double)this.quadSize / 10.0 : 0.0)), (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    @Override
    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.sprite.getU(this.uo / 4.0f);
            v0 = this.sprite.getV(this.vo / 4.0f);
        }
        float u1 = this.sprite.getU((this.uo + 1.0f) / 4.0f);
        float v1 = this.sprite.getV((this.vo + 1.0f) / 4.0f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - camera.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - camera.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - camera.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize);
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        if (FancyBlockParticles.CONFIG.terrain.isRestOnFloor()) {
            posY += (double)scale;
        }
        Vector3f smoothRotation = new Vector3f();
        if (FancyBlockParticles.CONFIG.terrain.getRotationMultiplier() > 0.0f) {
            smoothRotation.y = (float)Math.toRadians(this.rotation.y);
            smoothRotation.z = (float)Math.toRadians(this.rotation.z);
            if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                smoothRotation.x = (float)Math.toRadians(this.rotation.x);
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                    smoothRotation.y = (float)Math.toRadians(Mth.lerp((double)partialTick, (double)this.lastRotation.y, (double)this.rotation.y));
                    smoothRotation.z = (float)Math.toRadians(Mth.lerp((double)partialTick, (double)this.lastRotation.z, (double)this.rotation.z));
                } else {
                    smoothRotation.x = (float)Math.toRadians(Mth.lerp((double)partialTick, (double)this.lastRotation.x, (double)this.rotation.x));
                }
            }
        }
        FBPRenderHelper.renderCubeShadedLegacy(consumer, (float)posX, (float)posY, (float)posZ, scale, smoothRotation, u0, u1, v0, v1, light, this.rCol, this.gCol, this.bCol, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    private void calculateYAngle() {
        double sin = Math.toDegrees(Math.asin(this.xd / Math.sqrt(this.xd * this.xd + this.zd * this.zd)));
        this.rotation.y = this.zd > 0.0 ? -sin : sin;
    }

    private double getMultiplier() {
        return Math.sqrt(this.xd * this.xd + this.zd * this.zd) * (FancyBlockParticles.CONFIG.terrain.isRandomRotation() ? 200.0 : 500.0) * (double)FancyBlockParticles.CONFIG.terrain.getRotationMultiplier();
    }

    public record Provider(BlockPos pos, float scale, @Nullable Direction side, @Nullable TextureAtlasSprite sprite, float rCol, float gCol, float bCol) implements ParticleProvider<BlockParticleOption>
    {
        @Nullable
        public FBPTerrainParticle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd, RandomSource random) {
            return new FBPTerrainParticle(level, x, y, z, xd, yd, zd, this.scale, this.rCol, this.gCol, this.bCol, this.pos, type.getState(), this.side, this.sprite);
        }
    }
}

