/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.renderer.state;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ParticleFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.state.ParticleGroupRenderState;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureManager;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class FBPParticleRenderState
implements SubmitNodeCollector.ParticleGroupRenderer,
ParticleGroupRenderState {
    private final Map<SingleQuadParticle.Layer, Storage> particles = Maps.newHashMap();
    private int particleCount;

    public void add(SingleQuadParticle.Layer layer, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float rotW, float widthScale, float heightScale, float u0, float u1, float v0, float v1, int color, int light) {
        this.particles.computeIfAbsent(layer, l -> new Storage()).add(posX, posY, posZ, rotX, rotY, rotZ, rotW, widthScale, heightScale, u0, u1, v0, v1, color, light);
        ++this.particleCount;
    }

    public void clear() {
        this.particles.values().forEach(Storage::clear);
        this.particleCount = 0;
    }

    @Nullable
    public QuadParticleRenderState.PreparedBuffers prepare(ParticleFeatureRenderer.ParticleBufferCache cache) {
        int verticesCount = this.particleCount * 4;
        try (ByteBufferBuilder builder = ByteBufferBuilder.exactlySized((int)(verticesCount * DefaultVertexFormat.PARTICLE.getVertexSize()));){
            BufferBuilder buffer = new BufferBuilder(builder, VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            HashMap<SingleQuadParticle.Layer, QuadParticleRenderState.PreparedLayer> prepared = new HashMap<SingleQuadParticle.Layer, QuadParticleRenderState.PreparedLayer>();
            int vertexOffset = 0;
            for (Map.Entry<SingleQuadParticle.Layer, Storage> entry : this.particles.entrySet()) {
                entry.getValue().forEachParticle((posX, posY, posZ, rotX, rotY, rotZ, rotW, widthScale, heightScale, u0, u1, v0, v1, color, light) -> this.renderRotatedQuad((VertexConsumer)buffer, posX, posY, posZ, rotX, rotY, rotZ, rotW, widthScale, heightScale, u0, u1, v0, v1, color, light));
                if (entry.getValue().count() > 0) {
                    prepared.put(entry.getKey(), new QuadParticleRenderState.PreparedLayer(vertexOffset, entry.getValue().count() * 6));
                }
                vertexOffset += entry.getValue().count() * 4;
            }
            MeshData data = buffer.build();
            if (data != null) {
                cache.write(data.vertexBuffer());
                RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS).getBuffer(data.drawState().indexCount());
                QuadParticleRenderState.PreparedBuffers preparedBuffers = new QuadParticleRenderState.PreparedBuffers(data.drawState().indexCount(), RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth()), prepared);
                return preparedBuffers;
            }
        }
        return null;
    }

    public void render(QuadParticleRenderState.PreparedBuffers buffers, ParticleFeatureRenderer.ParticleBufferCache cache, RenderPass pass, TextureManager manager, boolean translucent) {
        RenderSystem.AutoStorageIndexBuffer sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        pass.setVertexBuffer(0, cache.get());
        pass.setIndexBuffer(sequentialBuffer.getBuffer(buffers.indexCount()), sequentialBuffer.type());
        pass.setUniform("DynamicTransforms", buffers.dynamicTransforms());
        for (Map.Entry entry : buffers.layers().entrySet()) {
            if (translucent != ((SingleQuadParticle.Layer)entry.getKey()).translucent()) continue;
            pass.setPipeline(((SingleQuadParticle.Layer)entry.getKey()).pipeline());
            pass.bindSampler("Sampler0", manager.getTexture(((SingleQuadParticle.Layer)entry.getKey()).textureAtlasLocation()).getTextureView());
            pass.drawIndexed(((QuadParticleRenderState.PreparedLayer)entry.getValue()).vertexOffset(), 0, ((QuadParticleRenderState.PreparedLayer)entry.getValue()).indexCount(), 1);
        }
    }

    private void renderRotatedQuad(VertexConsumer consumer, float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float rotW, float widthScale, float heightScale, float u0, float u1, float v0, float v1, int color, int light) {
        Quaternionf rotation = new Quaternionf(rotX, rotY, rotZ, rotW);
        this.renderVertex(consumer, rotation, posX, posY, posZ, 1.0f, -1.0f, widthScale, heightScale, u1, v1, color, light);
        this.renderVertex(consumer, rotation, posX, posY, posZ, 1.0f, 1.0f, widthScale, heightScale, u1, v0, color, light);
        this.renderVertex(consumer, rotation, posX, posY, posZ, -1.0f, 1.0f, widthScale, heightScale, u0, v0, color, light);
        this.renderVertex(consumer, rotation, posX, posY, posZ, -1.0f, -1.0f, widthScale, heightScale, u0, v1, color, light);
    }

    private void renderVertex(VertexConsumer consumer, Quaternionf rotation, float posX, float posY, float posZ, float x, float y, float widthScale, float heightScale, float u, float v, int color, int light) {
        Vector3f vertexPos = new Vector3f(x, y, 0.0f).rotate((Quaternionfc)rotation).mul(widthScale, heightScale, widthScale).add(posX, posY, posZ);
        consumer.addVertex(vertexPos.x(), vertexPos.y(), vertexPos.z()).setUv(u, v).setColor(color).setLight(light);
    }

    public void submit(SubmitNodeCollector nodeCollector, CameraRenderState state) {
        if (this.particleCount > 0) {
            nodeCollector.submitParticleGroup((SubmitNodeCollector.ParticleGroupRenderer)this);
        }
    }

    static class Storage {
        private int capacity = 1024;
        private int currentParticleIndex;
        private float[] floatValues = new float[this.capacity * 13];
        private int[] intValues = new int[this.capacity * 2];

        Storage() {
        }

        public void add(float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float rotW, float widthScale, float heightScale, float u0, float u1, float v0, float v1, int color, int light) {
            if (this.currentParticleIndex >= this.capacity) {
                this.grow();
            }
            int index = this.currentParticleIndex * 13;
            this.floatValues[index++] = posX;
            this.floatValues[index++] = posY;
            this.floatValues[index++] = posZ;
            this.floatValues[index++] = rotX;
            this.floatValues[index++] = rotY;
            this.floatValues[index++] = rotZ;
            this.floatValues[index++] = rotW;
            this.floatValues[index++] = widthScale;
            this.floatValues[index++] = heightScale;
            this.floatValues[index++] = u0;
            this.floatValues[index++] = u1;
            this.floatValues[index++] = v0;
            this.floatValues[index] = v1;
            index = this.currentParticleIndex * 2;
            this.intValues[index++] = color;
            this.intValues[index] = light;
            ++this.currentParticleIndex;
        }

        public void forEachParticle(ParticleConsumer consumer) {
            for (int i = 0; i < this.currentParticleIndex; ++i) {
                int floatIndex = i * 13;
                int intIndex = i * 2;
                consumer.consume(this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex++], this.floatValues[floatIndex], this.intValues[intIndex++], this.intValues[intIndex]);
            }
        }

        public void clear() {
            this.currentParticleIndex = 0;
        }

        private void grow() {
            this.capacity *= 2;
            this.floatValues = Arrays.copyOf(this.floatValues, this.capacity * 13);
            this.intValues = Arrays.copyOf(this.intValues, this.capacity * 2);
        }

        public int count() {
            return this.currentParticleIndex;
        }
    }

    @FunctionalInterface
    public static interface ParticleConsumer {
        public void consume(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, int var14, int var15);
    }
}

