/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.platform.Services;
import hantonik.fbp.renderer.state.FBPParticleRenderState;
import hantonik.fbp.util.FBPConstants;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class FBPRenderHelper {
    public static void renderCubeShaded(FBPParticleRenderState renderState, SingleQuadParticle.Layer layer, float x, float y, float z, float width, float height, Vector3f rotationRad, float u0, float u1, float v0, float v1, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        Quaternionf rotation = new Quaternionf().rotateXYZ(rotationRad.x, rotationRad.y, rotationRad.z);
        Quaternionf rotationX = new Quaternionf().rotateX(rotationRad.x);
        Quaternionf rotationY = new Quaternionf().rotateY(rotationRad.y);
        Quaternionf rotationZ = new Quaternionf().rotateZ(rotationRad.z);
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            Vector3f normal = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)rotation, new Vector3f());
            Vector3f face = new Vector3f((Vector3fc)normal).mul(width, height, width).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotationY.mul((Quaternionfc)faceRotation, faceRotation);
            } else if (i < 4) {
                rotationZ.mul((Quaternionfc)faceRotation, faceRotation);
            } else {
                rotationX.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float shade = Services.CLIENT.getShade(normal.x, normal.y, normal.z, true);
            if (cartoon) {
                renderState.add(layer, face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, width, i < 2 ? width : height, u1, u1, v1, v1, ARGB.colorFromFloat((float)alpha, (float)(red * shade), (float)(green * shade), (float)(blue * shade)), light);
                continue;
            }
            renderState.add(layer, face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, width, i < 2 ? width : height, u0, u1, v0, v1, ARGB.colorFromFloat((float)alpha, (float)(red * shade), (float)(green * shade), (float)(blue * shade)), light);
        }
    }

    public static void renderCubeShadedLegacy(VertexConsumer buffer, float x, float y, float z, float scale, Vector3f rotationRad, float u0, float u1, float v0, float v1, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3f vec1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f vec2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f vec3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f vec4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], rotationRad.x, rotationRad.y, rotationRad.z).mul(scale).add(x, y, z);
            Vector3f normal = FBPRenderHelper.rotate(FBPConstants.CUBE_NORMALS[i / 4], rotationRad.x, rotationRad.y, rotationRad.z);
            float shade = Services.CLIENT.getShade(normal.x, normal.y, normal.z, true);
            if (cartoon) {
                FBPRenderHelper.addVertex(buffer, vec1, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, vec2, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, vec3, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, vec4, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
                continue;
            }
            FBPRenderHelper.addVertex(buffer, vec1, u1, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, vec2, u1, v0, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, vec3, u0, v0, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, vec4, u0, v1, light, red * shade, green * shade, blue * shade, alpha, normal);
        }
    }

    public static Vector3f rotate(Vector3f vector, float angleX, float angleY, float angleZ) {
        Vector3f sin = new Vector3f(Mth.sin((float)angleX), Mth.sin((float)angleY), Mth.sin((float)angleZ));
        Vector3f cos = new Vector3f(Mth.cos((float)angleX), Mth.cos((float)angleY), Mth.cos((float)angleZ));
        vector = new Vector3f(vector.x, vector.y * cos.x - vector.z * sin.x, vector.y * sin.x + vector.z * cos.x);
        vector = new Vector3f(vector.x * cos.z - vector.y * sin.z, vector.x * sin.z + vector.y * cos.z, vector.z);
        vector = new Vector3f(vector.x * cos.y + vector.z * sin.y, vector.y, vector.x * sin.y - vector.z * cos.y);
        return vector;
    }

    public static void addVertex(VertexConsumer buffer, Vector3f pos, float u, float v, int light, float red, float green, float blue, float alpha, Vector3f normal) {
        buffer.addVertex(pos.x, pos.y, pos.z).setColor(red, green, blue, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(normal.x, normal.y, normal.z);
    }

    @Generated
    private FBPRenderHelper() {
    }
}

