/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import lombok.Generated;
import net.minecraft.class_10335;
import net.minecraft.class_10339;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class FBPTrailParticle
extends class_10335
implements IKillableParticle {
    private final Vector3d rotation;
    private final float multiplier;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean killToggle;

    protected FBPTrailParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd, class_243 target, int color) {
        super(level, x, y, z, xd, yd, zd, target, color);
        this.field_17867 = FancyBlockParticles.CONFIG.trail.getSizeMultiplier() * (FancyBlockParticles.CONFIG.trail.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.6f, 1.0f) : 1.0f) * 3.0f;
        this.scaleAlpha = this.field_17867 * 0.82f;
        this.rotation = new Vector3d(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0);
        this.field_17886 = FBPConstants.FBP_PARTICLE_SPRITE.get();
        this.field_3847 = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()) + 0.5f);
        this.multiplier = FancyBlockParticles.CONFIG.trail.isRandomFadingSpeed() ? class_3532.method_15363((float)FBPConstants.RANDOM.nextFloat(0.5f, 0.9f), (float)0.6f, (float)0.8f) : 0.75f;
        this.method_3087(1.0f);
    }

    public class_703 method_3087(float scale) {
        super.method_3087(scale);
        float size = this.field_17867 / 10.0f;
        this.method_3067(new class_238(this.field_3874 - (double)size, this.field_3854 - (double)size, this.field_3871 - (double)size, this.field_3874 + (double)size, this.field_3854 + (double)size, this.field_3871 + (double)size));
        return this;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.lastSize = this.field_17867;
        this.lastAlpha = this.field_3841;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.trail.isEnabled()) {
            this.method_3085();
        }
        if (!class_310.method_1551().method_1493()) {
            if (this.killToggle) {
                this.method_3085();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.trail.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.field_3866;
                }
                if (this.field_3866 < this.field_3847) {
                    double progress = (double)this.field_3866 / (double)this.field_3847;
                    this.field_3874 = class_3532.method_16436((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.field_3874, (double)this.field_54855.field_1352);
                    this.field_3854 = class_3532.method_16436((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.field_3854, (double)this.field_54855.field_1351);
                    this.field_3871 = class_3532.method_16436((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.field_3871, (double)this.field_54855.field_1350);
                }
                if (this.field_3866 + 10 >= this.field_3847) {
                    this.field_17867 *= 0.9f * this.multiplier;
                    if ((double)this.field_3841 >= 0.01 && this.field_17867 <= this.scaleAlpha) {
                        this.field_3841 *= 0.7f * this.multiplier;
                    }
                    if ((double)this.field_3841 < 0.01) {
                        this.method_3085();
                    }
                }
            }
        }
    }

    private static double easeInOutCubic(double input) {
        return input < 0.5 ? 4.0 * input * input * input : 1.0 - Math.pow(-2.0 * input + 2.0, 3.0) / 2.0;
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public class_3999 method_18122() {
        return class_3999.field_17827;
    }

    public int method_3068(float partialTick) {
        float factor = class_3532.method_15363((float)(((float)this.field_3866 + partialTick) / (float)this.field_3847), (float)0.0f, (float)1.0f);
        int i = super.method_3068(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        j = Math.min((int)(factor * 15.0f * 16.0f) + j, 240);
        i = j | k << 16;
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (this.field_3851.method_8477(pos)) {
            j = this.field_3851.method_22336().method_22363(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void method_3074(class_4588 buffer, class_4184 info, float partialTick) {
        float u = this.field_17886.method_4580(0.275f);
        float v = this.field_17886.method_4570(0.275f);
        double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874) - info.method_19326().field_1352;
        double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854) - info.method_19326().field_1351;
        double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871) - info.method_19326().field_1350;
        float scale = class_3532.method_16439((float)partialTick, (float)this.lastSize, (float)this.field_17867) / 70.0f;
        float alpha = class_3532.method_16439((float)partialTick, (float)this.lastAlpha, (float)this.field_3841);
        int light = this.method_3068(partialTick);
        class_310.method_1551().field_1773.method_22974().method_3316();
        this.putCube(buffer, u, v, posX, posY, posZ, scale, this.rotation, light, this.field_3861, this.field_3842, this.field_3859, alpha);
    }

    private void putCube(class_4588 buffer, float u, float v, double xPos, double yPos, double zPos, double scale, Vector3d rotation, int light, float rCol, float gCol, float bCol, float alpha) {
        float radX = (float)Math.toRadians(rotation.x);
        float radY = (float)Math.toRadians(rotation.y);
        float radZ = (float)Math.toRadians(rotation.z);
        float brightness = 1.0f;
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3d v1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.95f;
            this.addVertex(buffer, v1, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, v2, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, v3, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, v4, u, v, light, red, green, blue, alpha);
        }
    }

    private void addVertex(class_4588 buffer, Vector3d pos, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        buffer.method_22912((float)pos.x, (float)pos.y, (float)pos.z).method_22913(u, v).method_22915(rCol, gCol, bCol, alpha).method_60803(light);
    }

    public static class Provider
    implements class_707<class_10339> {
        @Nullable
        public class_703 createParticle(class_10339 type, class_638 level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.trail.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPTrailParticle(level, x, y, z, xd, yd, zd, type.comp_3292(), type.comp_3293());
        }

        @Generated
        public Provider() {
        }
    }
}

