/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPRainParticle;
import hantonik.fbp.particle.FBPSmokeParticle;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FBPSnowParticle
extends WaterDropParticle
implements IKillableParticle {
    private final Vector3d rotation;
    private final Vector3d rotationStep;
    private final Vector3d lastRotation;
    private final float multiplier;
    private final float scaleAlpha;
    private final float targetSize;
    private final float uo;
    private final float vo;
    private float lastAlpha;
    private float lastSize;
    private double lastXSpeed;
    private double lastZSpeed;
    private boolean wasFrozen;
    private boolean wasInWater;
    private boolean killToggle;
    private boolean visible;

    public FBPSnowParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, TextureAtlasSprite sprite) {
        super(level, x, y, z);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.sprite = sprite;
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.snow.getMinLifetime(), FancyBlockParticles.CONFIG.snow.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.snow.getMinLifetime(), FancyBlockParticles.CONFIG.snow.getMaxLifetime()) + 0.5f);
        this.targetSize = this.quadSize = Math.max(FBPConstants.RANDOM.nextFloat(FancyBlockParticles.CONFIG.snow.getSizeMultiplier() - 0.1f, FancyBlockParticles.CONFIG.snow.getSizeMultiplier() + 0.1f), 0.1f) * (FancyBlockParticles.CONFIG.snow.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.7f, 1.0f) : 1.0f);
        this.scale(1.0f);
        this.gravity = FancyBlockParticles.CONFIG.snow.getGravityMultiplier();
        this.hasPhysics = true;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.alpha = 0.0f;
        double rx = FBPConstants.RANDOM.nextDouble();
        double ry = FBPConstants.RANDOM.nextDouble();
        double rz = FBPConstants.RANDOM.nextDouble();
        this.rotationStep = new Vector3d(rx > 0.5 ? 1.0 : -1.0, ry > 0.5 ? 1.0 : -1.0, rz > 0.5 ? 1.0 : -1.0);
        this.lastRotation = new Vector3d();
        this.rotation = new Vector3d((Vector3dc)this.rotationStep);
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.scaleAlpha = this.quadSize * 0.75f;
        this.quadSize = 0.0f;
        this.multiplier = FancyBlockParticles.CONFIG.snow.isRandomFadingSpeed() ? FBPConstants.RANDOM.nextFloat(0.8f, 1.0f) : 1.0f;
    }

    public Particle scale(float scale) {
        super.scale(scale);
        float size = this.quadSize / 10.0f;
        this.setBoundingBox(new AABB(this.x - (double)size, this.y, this.z - (double)size, this.x + (double)size, this.y + (double)(2.0f * size), this.z + (double)size));
        return this;
    }

    public void tick() {
        if (FancyBlockParticles.CONFIG.snow.isBounceOffWalls()) {
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!Minecraft.getInstance().isPaused() && this.age > 0) {
                    if (!this.wasFrozen && (Math.abs(this.xd) > 1.0E-5 || Math.abs(this.zd) > 1.0E-5)) {
                        if (this.xo == this.x) {
                            this.xd = -this.lastXSpeed * 0.625;
                        }
                        if (this.zo == this.z) {
                            this.zd = -this.lastZSpeed * 0.625;
                        }
                    } else {
                        this.wasFrozen = false;
                    }
                }
            } else {
                this.wasFrozen = true;
            }
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastAlpha = this.alpha;
        this.lastSize = this.quadSize;
        this.lastRotation.set((Vector3dc)this.rotation);
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.snow.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (this.y < Minecraft.getInstance().player.getY() - (double)((Integer)Minecraft.getInstance().options.renderDistance().get()).intValue() * 16.0) {
                    this.remove();
                }
                if (!FancyBlockParticles.CONFIG.snow.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.age;
                }
                this.rotation.add((Vector3dc)this.rotationStep.mul((double)(FancyBlockParticles.CONFIG.snow.getRotationMultiplier() * 5.0f), new Vector3d()));
                BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
                Biome.Precipitation precipitation = ((Biome)this.level.getBiome(pos).value()).getPrecipitationAt(pos, this.level.getSeaLevel());
                if (this.age >= this.lifetime || precipitation != Biome.Precipitation.SNOW) {
                    this.quadSize *= 0.75f * this.multiplier;
                    if (this.alpha >= 0.01f && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= 0.65f * this.multiplier;
                    }
                    if (this.alpha < 0.01f) {
                        this.remove();
                        if (precipitation == Biome.Precipitation.RAIN) {
                            Minecraft.getInstance().particleEngine.add(new FBPRainParticle.Provider().createParticle(ParticleTypes.RAIN.getType(), this.level, this.x, this.y, this.z, 0.0, 0.0, 0.0));
                        }
                    }
                } else if (!this.wasInWater) {
                    if (this.quadSize < this.targetSize) {
                        this.quadSize += 0.075f * this.multiplier;
                        if (this.quadSize > this.targetSize) {
                            this.quadSize = this.targetSize;
                        }
                    }
                    if (this.alpha < 1.0f) {
                        this.alpha += 0.045f * this.multiplier;
                        if (this.alpha > 1.0f) {
                            this.alpha = 1.0f;
                        }
                    }
                }
                if (!this.onGround) {
                    this.yd -= (this.wasInWater ? 0.02 : 0.04) * (double)this.gravity;
                }
                this.move(this.xd, this.yd, this.zd);
                if (Math.abs(this.xd) > 1.0E-5) {
                    this.lastXSpeed = this.xd;
                }
                if (Math.abs(this.zd) > 1.0E-5) {
                    this.lastZSpeed = this.zd;
                }
                if (this.onGround && FancyBlockParticles.CONFIG.snow.isRestOnFloor()) {
                    this.rotation.x = (double)Math.round(this.rotation.x / 90.0) * 90.0;
                    this.rotation.z = (double)Math.round(this.rotation.z / 90.0) * 90.0;
                }
                this.xd *= 0.98;
                if (this.yd < -0.2) {
                    this.yd *= 0.75;
                }
                this.zd *= 0.98;
                BlockState state = this.level.getBlockState(pos.relative(Direction.DOWN));
                if (this.isInFluid(this.getBoundingBox(), (TagKey<Fluid>)FluidTags.LAVA) || (state.is(Blocks.MAGMA_BLOCK) || CampfireBlock.isLitCampfire((BlockState)state)) && this.onGround) {
                    this.remove();
                    Minecraft.getInstance().particleEngine.add(new FBPSmokeParticle.Provider(this.quadSize / 5.0f).createParticle(ParticleTypes.SMOKE, this.level, this.x, this.y, this.z, 0.0, 0.05, 0.0));
                }
                if (this.isInFluid(this.getBoundingBox(), (TagKey<Fluid>)FluidTags.WATER)) {
                    if (FancyBlockParticles.CONFIG.snow.isWaterPhysics()) {
                        this.xd *= 0.3;
                        this.yd *= 0.05;
                        this.zd *= 0.3;
                        this.quadSize *= 0.98f * this.multiplier;
                        this.wasInWater = true;
                        if (this.alpha >= 0.01f && this.quadSize <= this.scaleAlpha) {
                            this.alpha *= 0.95f * this.multiplier;
                        }
                        if (this.alpha < 0.01f) {
                            this.remove();
                        }
                    } else {
                        this.remove();
                    }
                } else {
                    this.wasInWater = false;
                }
                if (this.onGround) {
                    if (FancyBlockParticles.CONFIG.snow.isLowTraction()) {
                        this.xd *= 0.932;
                        this.zd *= 0.932;
                    } else {
                        this.xd *= 0.665;
                        this.zd *= 0.665;
                    }
                    this.rotationStep.mul(0.85);
                    if (!FancyBlockParticles.CONFIG.snow.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                        this.age += 2;
                    }
                }
            }
        }
        Vec3 vec3 = new Vec3(this.x, Minecraft.getInstance().cameraEntity.getY(), this.z);
        if (Minecraft.getInstance().cameraEntity.position().distanceTo(vec3) > (double)(Math.min(FancyBlockParticles.CONFIG.snow.getSimulationDistance(), (Integer)Minecraft.getInstance().options.simulationDistance().get()) * 16)) {
            this.remove();
        }
        this.visible = Minecraft.getInstance().cameraEntity.position().distanceTo(new Vec3(this.x, Minecraft.getInstance().cameraEntity.getY(), this.z)) <= (double)(Math.min(FancyBlockParticles.CONFIG.snow.getRenderDistance(), (Integer)Minecraft.getInstance().options.renderDistance().get()) * 16);
    }

    private boolean isInFluid(AABB box, TagKey<Fluid> fluid) {
        if (!this.touchingUnloadedChunk()) {
            box = box.deflate(0.001);
            int minX = Mth.floor((double)box.minX);
            int maxX = Mth.ceil((double)box.maxX);
            int minY = Mth.floor((double)box.minY);
            int maxY = Mth.ceil((double)box.maxY);
            int minZ = Mth.floor((double)box.minZ);
            int maxZ = Mth.ceil((double)box.maxZ);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                        FluidState fluidState = this.level.getFluidState(pos);
                        if (!fluidState.is(fluid) || !((double)(fluidState.getHeight((BlockGetter)this.level, pos) + (float)y) >= box.minY)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        Vec3 center = this.getBoundingBox().inflate(1.0).getCenter();
        return !this.level.isLoaded(BlockPos.containing((double)center.x, (double)center.y, (double)center.z));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (!FancyBlockParticles.CONFIG.snow.isLowTraction() && !FancyBlockParticles.CONFIG.snow.isBounceOffWalls()) {
            if (x != xo) {
                this.xd *= 0.7;
            }
            if (z != zo) {
                this.zd *= 0.7;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    protected int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void render(VertexConsumer buffer, Camera info, float partialTick) {
        if (!this.visible) {
            return;
        }
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.sprite.getU(this.uo / 4.0f);
            v0 = this.sprite.getV(this.vo / 4.0f);
        }
        float u1 = this.sprite.getU((this.uo + 1.0f) / 4.0f);
        float v1 = this.sprite.getV((this.vo + 1.0f) / 4.0f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize) / 10.0f;
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        if (FancyBlockParticles.CONFIG.snow.isRestOnFloor()) {
            posY += (double)scale;
        }
        Vector3d smoothRotation = new Vector3d();
        if (FancyBlockParticles.CONFIG.snow.getRotationMultiplier() > 0.0f) {
            smoothRotation.y = this.rotation.y;
            smoothRotation.z = this.rotation.z;
            if (!FancyBlockParticles.CONFIG.snow.isRandomRotation()) {
                smoothRotation.x = this.rotation.x;
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (FancyBlockParticles.CONFIG.snow.isRandomRotation()) {
                    smoothRotation.y = Mth.lerp((double)partialTick, (double)this.lastRotation.y, (double)this.rotation.y);
                    smoothRotation.z = Mth.lerp((double)partialTick, (double)this.lastRotation.z, (double)this.rotation.z);
                } else {
                    smoothRotation.x = Mth.lerp((double)partialTick, (double)this.lastRotation.x, (double)this.rotation.x);
                }
            }
        }
        FBPRenderHelper.renderCubeShaded(buffer, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, posX, posY, posZ, scale, smoothRotation, light, this.rCol, this.gCol, this.bCol, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    public record Provider() implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                return null;
            }
            return new FBPSnowParticle(level, x, y, z, FBPConstants.RANDOM.nextDouble(-0.5, 0.5), -FBPConstants.RANDOM.nextDouble(0.25, 1.0), FBPConstants.RANDOM.nextDouble(-0.5, 0.5), Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.SNOW_BLOCK.defaultBlockState()));
        }
    }
}

