/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPRainParticle;
import hantonik.fbp.particle.FBPSmokeParticle;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3922;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_740;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FBPSnowParticle
extends class_740
implements IKillableParticle {
    private final Vector3d rotation;
    private final Vector3d rotationStep;
    private final Vector3d lastRotation;
    private final float multiplier;
    private final float scaleAlpha;
    private final float targetSize;
    private final float uo;
    private final float vo;
    private float lastAlpha;
    private float lastSize;
    private double lastXSpeed;
    private double lastZSpeed;
    private boolean wasFrozen;
    private boolean wasInWater;
    private boolean killToggle;
    private boolean visible;

    public FBPSnowParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd, class_1058 sprite) {
        super(level, x, y, z);
        this.field_3852 = xd;
        this.field_3869 = yd;
        this.field_3850 = zd;
        this.field_17886 = sprite;
        this.field_3847 = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.snow.getMinLifetime(), FancyBlockParticles.CONFIG.snow.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.snow.getMinLifetime(), FancyBlockParticles.CONFIG.snow.getMaxLifetime()) + 0.5f);
        this.targetSize = this.field_17867 = Math.max(FBPConstants.RANDOM.nextFloat(FancyBlockParticles.CONFIG.snow.getSizeMultiplier() - 0.1f, FancyBlockParticles.CONFIG.snow.getSizeMultiplier() + 0.1f), 0.1f) * (FancyBlockParticles.CONFIG.snow.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.7f, 1.0f) : 1.0f);
        this.method_3087(1.0f);
        this.field_3844 = FancyBlockParticles.CONFIG.snow.getGravityMultiplier();
        this.field_3862 = true;
        this.field_3861 = 1.0f;
        this.field_3842 = 1.0f;
        this.field_3859 = 1.0f;
        this.field_3841 = 0.0f;
        double rx = FBPConstants.RANDOM.nextDouble();
        double ry = FBPConstants.RANDOM.nextDouble();
        double rz = FBPConstants.RANDOM.nextDouble();
        this.rotationStep = new Vector3d(rx > 0.5 ? 1.0 : -1.0, ry > 0.5 ? 1.0 : -1.0, rz > 0.5 ? 1.0 : -1.0);
        this.lastRotation = new Vector3d();
        this.rotation = new Vector3d((Vector3dc)this.rotationStep);
        this.uo = this.field_3840.method_43057() * 3.0f;
        this.vo = this.field_3840.method_43057() * 3.0f;
        this.scaleAlpha = this.field_17867 * 0.75f;
        this.field_17867 = 0.0f;
        this.multiplier = FancyBlockParticles.CONFIG.snow.isRandomFadingSpeed() ? FBPConstants.RANDOM.nextFloat(0.8f, 1.0f) : 1.0f;
    }

    public class_703 method_3087(float scale) {
        super.method_3087(scale);
        float size = this.field_17867 / 10.0f;
        this.method_3067(new class_238(this.field_3874 - (double)size, this.field_3854, this.field_3871 - (double)size, this.field_3874 + (double)size, this.field_3854 + (double)(2.0f * size), this.field_3871 + (double)size));
        return this;
    }

    public void method_3070() {
        if (FancyBlockParticles.CONFIG.snow.isBounceOffWalls()) {
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!class_310.method_1551().method_1493() && this.field_3866 > 0) {
                    if (!this.wasFrozen && (Math.abs(this.field_3852) > 1.0E-5 || Math.abs(this.field_3850) > 1.0E-5)) {
                        if (this.field_3858 == this.field_3874) {
                            this.field_3852 = -this.lastXSpeed * 0.625;
                        }
                        if (this.field_3856 == this.field_3871) {
                            this.field_3850 = -this.lastZSpeed * 0.625;
                        }
                    } else {
                        this.wasFrozen = false;
                    }
                }
            } else {
                this.wasFrozen = true;
            }
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.lastAlpha = this.field_3841;
        this.lastSize = this.field_17867;
        this.lastRotation.set((Vector3dc)this.rotation);
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.snow.isEnabled()) {
            this.method_3085();
        }
        if (!class_310.method_1551().method_1493()) {
            if (this.killToggle) {
                this.method_3085();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (this.field_3854 < class_310.method_1551().field_1724.method_23318() - (double)((Integer)class_310.method_1551().field_1690.method_42503().method_41753()).intValue() * 16.0) {
                    this.method_3085();
                }
                if (!FancyBlockParticles.CONFIG.snow.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.field_3866;
                }
                this.rotation.add((Vector3dc)this.rotationStep.mul((double)(FancyBlockParticles.CONFIG.snow.getRotationMultiplier() * 5.0f), new Vector3d()));
                class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
                class_1959.class_1963 precipitation = ((class_1959)this.field_3851.method_23753(pos).comp_349()).method_48162(pos);
                if (this.field_3866 >= this.field_3847 || precipitation != class_1959.class_1963.field_9383) {
                    this.field_17867 *= 0.75f * this.multiplier;
                    if (this.field_3841 >= 0.01f && this.field_17867 <= this.scaleAlpha) {
                        this.field_3841 *= 0.65f * this.multiplier;
                    }
                    if (this.field_3841 < 0.01f) {
                        this.method_3085();
                        if (precipitation == class_1959.class_1963.field_9382) {
                            class_310.method_1551().field_1713.method_3058(new FBPRainParticle.Provider().createParticle(class_2398.field_11242.method_29140(), this.field_3851, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0));
                        }
                    }
                } else if (!this.wasInWater) {
                    if (this.field_17867 < this.targetSize) {
                        this.field_17867 += 0.075f * this.multiplier;
                        if (this.field_17867 > this.targetSize) {
                            this.field_17867 = this.targetSize;
                        }
                    }
                    if (this.field_3841 < 1.0f) {
                        this.field_3841 += 0.045f * this.multiplier;
                        if (this.field_3841 > 1.0f) {
                            this.field_3841 = 1.0f;
                        }
                    }
                }
                if (!this.field_3845) {
                    this.field_3869 -= (this.wasInWater ? 0.02 : 0.04) * (double)this.field_3844;
                }
                this.method_3069(this.field_3852, this.field_3869, this.field_3850);
                if (Math.abs(this.field_3852) > 1.0E-5) {
                    this.lastXSpeed = this.field_3852;
                }
                if (Math.abs(this.field_3850) > 1.0E-5) {
                    this.lastZSpeed = this.field_3850;
                }
                if (this.field_3845 && FancyBlockParticles.CONFIG.snow.isRestOnFloor()) {
                    this.rotation.x = (double)Math.round(this.rotation.x / 90.0) * 90.0;
                    this.rotation.z = (double)Math.round(this.rotation.z / 90.0) * 90.0;
                }
                this.field_3852 *= 0.98;
                if (this.field_3869 < -0.2) {
                    this.field_3869 *= 0.75;
                }
                this.field_3850 *= 0.98;
                class_2680 state = this.field_3851.method_8320(pos.method_10093(class_2350.field_11033));
                if (this.isInFluid(this.method_3064(), (class_6862<class_3611>)class_3486.field_15518) || (state.method_27852(class_2246.field_10092) || class_3922.method_23896((class_2680)state)) && this.field_3845) {
                    this.method_3085();
                    class_310.method_1551().field_1713.method_3058(new FBPSmokeParticle.Provider(this.field_17867 / 5.0f).createParticle(class_2398.field_11251, this.field_3851, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.05, 0.0));
                }
                if (this.isInFluid(this.method_3064(), (class_6862<class_3611>)class_3486.field_15517)) {
                    if (FancyBlockParticles.CONFIG.snow.isWaterPhysics()) {
                        this.field_3852 *= 0.3;
                        this.field_3869 *= 0.05;
                        this.field_3850 *= 0.3;
                        this.field_17867 *= 0.98f * this.multiplier;
                        this.wasInWater = true;
                        if (this.field_3841 >= 0.01f && this.field_17867 <= this.scaleAlpha) {
                            this.field_3841 *= 0.95f * this.multiplier;
                        }
                        if (this.field_3841 < 0.01f) {
                            this.method_3085();
                        }
                    } else {
                        this.method_3085();
                    }
                } else {
                    this.wasInWater = false;
                }
                if (this.field_3845) {
                    if (FancyBlockParticles.CONFIG.snow.isLowTraction()) {
                        this.field_3852 *= 0.932;
                        this.field_3850 *= 0.932;
                    } else {
                        this.field_3852 *= 0.665;
                        this.field_3850 *= 0.665;
                    }
                    this.rotationStep.mul(0.85);
                    if (!FancyBlockParticles.CONFIG.snow.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                        this.field_3866 += 2;
                    }
                }
            }
        }
        class_243 class_2432 = new class_243(this.field_3874, class_310.method_1551().field_1719.method_23318(), this.field_3871);
        if (class_310.method_1551().field_1719.method_19538().method_1022(class_2432) > (double)(Math.min(FancyBlockParticles.CONFIG.snow.getSimulationDistance(), (Integer)class_310.method_1551().field_1690.method_42510().method_41753()) * 16)) {
            this.method_3085();
        }
        this.visible = class_310.method_1551().field_1719.method_19538().method_1022(new class_243(this.field_3874, class_310.method_1551().field_1719.method_23318(), this.field_3871)) <= (double)(Math.min(FancyBlockParticles.CONFIG.snow.getRenderDistance(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753()) * 16);
    }

    private boolean isInFluid(class_238 box, class_6862<class_3611> fluid) {
        if (!this.touchingUnloadedChunk()) {
            box = box.method_1011(0.001);
            int minX = class_3532.method_15357((double)box.field_1323);
            int maxX = class_3532.method_15384((double)box.field_1320);
            int minY = class_3532.method_15357((double)box.field_1322);
            int maxY = class_3532.method_15384((double)box.field_1325);
            int minZ = class_3532.method_15357((double)box.field_1321);
            int maxZ = class_3532.method_15384((double)box.field_1324);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                        class_3610 fluidState = this.field_3851.method_8316(pos);
                        if (!fluidState.method_15767(fluid) || !((double)(fluidState.method_15763((class_1922)this.field_3851, pos) + (float)y) >= box.field_1322)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        class_243 center = this.method_3064().method_1014(1.0).method_1005();
        return !this.field_3851.method_8477(class_2338.method_49637((double)center.field_1352, (double)center.field_1351, (double)center.field_1350));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void method_3069(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < class_3532.method_33723((double)100.0)) {
            class_243 vec = class_1297.method_20736(null, (class_243)new class_243(x, y, z), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
            x = vec.field_1352;
            y = vec.field_1351;
            z = vec.field_1350;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.method_3067(this.method_3064().method_989(x, y, z));
            this.method_3072();
        }
        boolean bl = this.field_3845 = y != yo && yo < 0.0;
        if (!FancyBlockParticles.CONFIG.snow.isLowTraction() && !FancyBlockParticles.CONFIG.snow.isBounceOffWalls()) {
            if (x != xo) {
                this.field_3852 *= 0.7;
            }
            if (z != zo) {
                this.field_3850 *= 0.7;
            }
        }
    }

    public class_3999 method_18122() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    protected int method_3068(float partialTick) {
        int i = super.method_3068(partialTick);
        int j = 0;
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (this.field_3851.method_8477(pos)) {
            j = this.field_3851.method_22336().method_22363(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void method_3074(class_4588 buffer, class_4184 info, float partialTick) {
        if (!this.visible) {
            return;
        }
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.field_17886.method_4580((double)(this.uo / 4.0f * 16.0f));
            v0 = this.field_17886.method_4570((double)(this.vo / 4.0f * 16.0f));
        }
        float u1 = this.field_17886.method_4580((double)((this.uo + 1.0f) / 4.0f * 16.0f));
        float v1 = this.field_17886.method_4570((double)((this.vo + 1.0f) / 4.0f * 16.0f));
        double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874) - info.method_19326().field_1352;
        double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854) - info.method_19326().field_1351;
        double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871) - info.method_19326().field_1350;
        float scale = class_3532.method_16439((float)partialTick, (float)this.lastSize, (float)this.field_17867) / 10.0f;
        float alpha = class_3532.method_16439((float)partialTick, (float)this.lastAlpha, (float)this.field_3841);
        int light = this.method_3068(partialTick);
        if (FancyBlockParticles.CONFIG.snow.isRestOnFloor()) {
            posY += (double)scale;
        }
        Vector3d smoothRotation = new Vector3d(0.0, 0.0, 0.0);
        if (FancyBlockParticles.CONFIG.snow.getRotationMultiplier() > 0.0f) {
            smoothRotation.y = this.rotation.y;
            smoothRotation.z = this.rotation.z;
            if (!FancyBlockParticles.CONFIG.snow.isRandomRotation()) {
                smoothRotation.x = this.rotation.x;
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                Vector3d vec = this.rotation.lerp((Vector3dc)this.lastRotation, (double)partialTick, new Vector3d());
                if (FancyBlockParticles.CONFIG.snow.isRandomRotation()) {
                    smoothRotation.y = vec.y;
                    smoothRotation.z = vec.z;
                } else {
                    smoothRotation.x = vec.x;
                }
            }
        }
        FBPRenderHelper.renderCubeShaded(buffer, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, posX, posY, posZ, scale, smoothRotation, light, this.field_3861, this.field_3842, this.field_3859, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    public static class Provider
    implements class_707<class_2400> {
        @Nullable
        public class_703 createParticle(class_2400 type, class_638 level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                return null;
            }
            return new FBPSnowParticle(level, x, y, z, FBPConstants.RANDOM.nextDouble(-0.5, 0.5), -FBPConstants.RANDOM.nextDouble(0.25, 1.0), FBPConstants.RANDOM.nextDouble(-0.5, 0.5), class_310.method_1551().method_1541().method_3351().method_3339(class_2246.field_10491.method_9564()));
        }

        @Generated
        public Provider() {
        }
    }
}

