/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_727;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FBPTerrainParticle
extends class_727
implements IKillableParticle {
    private final Vector3d rotation;
    private final Vector3d rotationStep;
    private final Vector3d lastRotation;
    private final float multiplier;
    private final boolean destroyed;
    private final double startY;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private double lastXSpeed;
    private double lastZSpeed;
    private boolean wasFrozen;
    private boolean wasInWater;
    private boolean killToggle;
    private boolean modeDebounce;

    public FBPTerrainParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd, float scale, float rCol, float gCol, float bCol, class_2338 pos, class_2680 state, @Nullable class_2350 side, @Nullable class_1058 sprite) {
        super(level, x, y, z, xd, yd, zd, state, pos);
        this.field_3891 = pos;
        if (!state.method_27852(class_2246.field_10219) || side == class_2350.field_11036) {
            int i = class_310.method_1551().method_1505().method_1697(state, (class_1920)this.field_3851, pos, 0);
            this.field_3861 = (float)(i >> 16 & 0xFF) / 255.0f;
            this.field_3842 = (float)(i >> 8 & 0xFF) / 255.0f;
            this.field_3859 = (float)(i & 0xFF) / 255.0f;
        } else {
            this.field_3861 = rCol;
            this.field_3842 = gCol;
            this.field_3859 = bCol;
        }
        if ((double)scale < -1.0 && side == class_2350.field_11036 && FancyBlockParticles.CONFIG.terrain.isSmartBreaking()) {
            this.field_3852 *= 1.5;
            this.field_3869 *= 0.1;
            this.field_3850 *= 1.5;
            double speed = Math.sqrt(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850);
            double cameraXRot = class_310.method_1551().field_1719.method_5720().field_1352;
            double cameraZRot = class_310.method_1551().field_1719.method_5720().field_1350;
            this.field_3852 = (cameraXRot < 0.0 ? cameraXRot - 0.01 : cameraXRot + 0.01) * speed;
            this.field_3850 = (cameraZRot < 0.0 ? cameraZRot - 0.01 : cameraZRot + 0.01) * speed;
        }
        float size = (double)scale > -1.0 ? scale : this.field_17867;
        this.field_17867 = FancyBlockParticles.CONFIG.terrain.getSizeMultiplier() * (FancyBlockParticles.CONFIG.terrain.isRandomSize() ? size : 1.0f) / 10.0f;
        this.field_3844 *= FancyBlockParticles.CONFIG.terrain.getGravityMultiplier();
        this.field_3847 = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.terrain.getMinLifetime(), FancyBlockParticles.CONFIG.terrain.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.terrain.getMinLifetime(), FancyBlockParticles.CONFIG.terrain.getMaxLifetime()) + 0.5f);
        this.startY = this.field_3854;
        this.scaleAlpha = this.field_17867 * 0.82f;
        this.rotation = new Vector3d();
        this.lastRotation = new Vector3d();
        this.rotationStep = new Vector3d(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0);
        this.rotation.set((Vector3dc)this.rotationStep);
        boolean bl = this.modeDebounce = !FancyBlockParticles.CONFIG.terrain.isRandomRotation();
        if (this.modeDebounce) {
            this.rotation.zero();
            this.calculateYAngle();
        }
        boolean bl2 = this.destroyed = side == null;
        if (sprite == null) {
            List quads;
            if (!this.destroyed && !(quads = class_310.method_1551().method_1541().method_3351().method_3335(state).method_4707(state, side, this.field_3840)).isEmpty()) {
                this.field_17886 = ((class_777)quads.get(0)).method_35788();
            }
            if (this.field_17886.method_45852() == class_1047.method_4539()) {
                this.field_17886 = class_310.method_1551().method_1541().method_3351().method_3339(state);
            }
        } else {
            this.field_17886 = sprite;
        }
        this.multiplier = FancyBlockParticles.CONFIG.terrain.isRandomFadingSpeed() ? class_3532.method_15363((float)FBPConstants.RANDOM.nextFloat(0.5f, 0.9f), (float)0.6f, (float)0.8f) : 0.75f;
        this.method_3087(1.0f);
    }

    public class_703 method_3087(float scale) {
        super.method_3087(scale);
        float size = this.field_17867 / 10.0f;
        if (FancyBlockParticles.CONFIG.terrain.isRestOnFloor() && this.destroyed) {
            this.field_3854 = this.startY - (double)size;
        }
        this.field_3838 = this.field_3854;
        this.method_3067(new class_238(this.field_3874 - (double)size, this.field_3854 - (double)size, this.field_3871 - (double)size, this.field_3874 + (double)size, this.field_3854 + (double)size, this.field_3871 + (double)size));
        return this;
    }

    public FBPTerrainParticle setPower(float power) {
        super.method_3075(power);
        this.field_3869 = (this.field_3869 - 0.1) * (double)(this.multiplier / 2.0f) + (double)0.1f;
        return this;
    }

    public FBPTerrainParticle setYSpeed(double yd) {
        this.field_3869 = yd;
        return this;
    }

    public void method_3070() {
        if (FancyBlockParticles.CONFIG.terrain.isBounceOffWalls()) {
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!class_310.method_1551().method_1493() && this.field_3866 > 0) {
                    if (!this.wasFrozen && (Math.abs(this.field_3852) > 1.0E-5 || Math.abs(this.field_3850) > 1.0E-5)) {
                        if (this.field_3858 == this.field_3874) {
                            this.field_3852 = -this.lastXSpeed * 0.625;
                        }
                        if (this.field_3856 == this.field_3871) {
                            this.field_3850 = -this.lastZSpeed * 0.625;
                        }
                        if (!(FancyBlockParticles.CONFIG.terrain.isRandomRotation() || this.field_3858 != this.field_3874 && this.field_3856 != this.field_3871)) {
                            this.calculateYAngle();
                        }
                    } else {
                        this.wasFrozen = false;
                    }
                }
            } else {
                this.wasFrozen = true;
            }
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.lastRotation.set((Vector3dc)this.rotation);
        this.lastSize = this.field_17867;
        this.lastAlpha = this.field_3841;
        if (!(FancyBlockParticles.CONFIG.global.isEnabled() && ((!this.destroyed || FancyBlockParticles.CONFIG.terrain.isFancyBreakingParticles() || FancyBlockParticles.CONFIG.terrain.isFancyFallingDustParticles()) && (this.destroyed || FancyBlockParticles.CONFIG.terrain.isFancyCrackingParticles()) || FancyBlockParticles.CONFIG.misc.isFancySnowballParticles() || FancyBlockParticles.CONFIG.misc.isFancySlimeParticles() || FancyBlockParticles.CONFIG.misc.isFancyBreakingSplashPotionParticles()))) {
            this.method_3085();
        }
        if (!class_310.method_1551().method_1493()) {
            if (this.killToggle) {
                this.method_3085();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                    if (!this.modeDebounce) {
                        this.modeDebounce = true;
                        this.rotation.z = 0.0;
                        this.calculateYAngle();
                    }
                    double x = Math.abs(this.rotationStep.x * this.getMultiplier());
                    if (this.field_3852 > 0.0) {
                        if (this.field_3850 > 0.0) {
                            this.rotation.x -= x;
                        } else if (this.field_3850 < 0.0) {
                            this.rotation.x += x;
                        }
                    } else if (this.field_3852 < 0.0) {
                        if (this.field_3850 < 0.0) {
                            this.rotation.x += x;
                        } else if (this.field_3850 > 0.0) {
                            this.rotation.x -= x;
                        }
                    }
                } else {
                    if (this.modeDebounce) {
                        this.modeDebounce = false;
                        this.rotation.z = FBPConstants.RANDOM.nextDouble(30.0, 400.0);
                    }
                    this.rotation.add((Vector3dc)this.rotationStep.mul(this.getMultiplier(), new Vector3d()));
                }
                if (!FancyBlockParticles.CONFIG.terrain.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.field_3866;
                }
                if (this.field_3866 >= this.field_3847) {
                    this.field_17867 *= 0.9f * this.multiplier;
                    if ((double)this.field_3841 >= 0.01 && this.field_17867 <= this.scaleAlpha) {
                        this.field_3841 *= 0.7f * this.multiplier;
                    }
                    if ((double)this.field_3841 < 0.01) {
                        this.method_3085();
                    }
                }
                this.method_3069(this.field_3852, this.field_3869, this.field_3850);
                if (this.field_3845 && FancyBlockParticles.CONFIG.terrain.isRestOnFloor()) {
                    this.rotation.x = (double)Math.round(this.rotation.x / 10.0) * 10.0;
                    this.rotation.z = (double)Math.round(this.rotation.z / 10.0) * 10.0;
                }
                if (Math.abs(this.field_3852) > 1.0E-5) {
                    this.lastXSpeed = this.field_3852;
                }
                if (Math.abs(this.field_3850) > 1.0E-5) {
                    this.lastZSpeed = this.field_3850;
                }
                this.field_3852 *= 0.98;
                this.field_3850 *= 0.98;
                this.field_3869 *= 0.98;
                if (!this.field_3851.method_18026(this.method_3064().method_1011(1.0E-7))) {
                    this.moveTowardsClosestSpace(this.field_3874, (this.method_3064().field_1322 + this.method_3064().field_1325) / 2.0, this.field_3871);
                }
                if (FancyBlockParticles.CONFIG.terrain.isEntityCollision()) {
                    List entities = this.field_3851.method_8335(null, this.method_3064());
                    for (class_1297 entity : entities) {
                        if (entity.field_5960) continue;
                        double x = this.field_3874 - entity.method_19538().field_1352;
                        double y = this.field_3854 - entity.method_19538().field_1351;
                        double z = this.field_3871 - entity.method_19538().field_1350;
                        double distance = class_3532.method_15391((double)class_3532.method_15391((double)x, (double)y), (double)z);
                        if (!(distance >= 0.01)) continue;
                        distance = Math.sqrt(distance);
                        double d = Math.min(1.0 / distance, 1.0);
                        this.field_3852 += (x /= distance) * d / 20.0;
                        this.field_3869 += (y /= distance) * d / 20.0 - 0.04 * (double)this.field_3844;
                        this.field_3850 += (z /= distance) * d / 20.0;
                        if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                            this.calculateYAngle();
                        }
                        if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) continue;
                        this.field_3845 = false;
                    }
                }
                if (FancyBlockParticles.CONFIG.terrain.isWaterPhysics() && this.isInWater(this.method_3064())) {
                    this.field_3852 *= 0.95;
                    this.field_3850 *= 0.95;
                    if (this.field_3869 > -0.005 && this.field_3869 < 0.005) {
                        this.field_3869 = 0.005;
                    }
                    this.field_3869 = this.field_3869 < 0.0 ? (this.field_3869 *= 0.79 * FBPConstants.RANDOM.nextDouble(0.8, 1.2)) : (this.field_3869 *= 1.1 * FBPConstants.RANDOM.nextDouble(0.75, 0.9));
                    if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                        this.calculateYAngle();
                    }
                    this.field_3845 = false;
                    this.wasInWater = true;
                } else {
                    if (!this.field_3845) {
                        this.field_3869 -= (this.wasInWater ? 0.02 : 0.04) * (double)this.field_3844;
                    }
                    this.wasInWater = false;
                }
                if (this.field_3845) {
                    if (FancyBlockParticles.CONFIG.terrain.isLowTraction()) {
                        this.field_3852 *= 0.932;
                        this.field_3850 *= 0.932;
                    } else {
                        this.field_3852 *= 0.665;
                        this.field_3850 *= 0.665;
                    }
                }
            }
        }
    }

    private void moveTowardsClosestSpace(double x, double y, double z) {
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        class_243 vec = new class_243(x - (double)pos.method_10263(), y - (double)pos.method_10264(), z - (double)pos.method_10260());
        class_2338.class_2339 relativePos = new class_2338.class_2339();
        double minDistance = Double.MAX_VALUE;
        class_2350 distanceDirection = class_2350.field_11036;
        for (class_2350 direction : class_2350.values()) {
            double distance;
            relativePos.method_25505((class_2382)pos, direction);
            if (this.field_3851.method_8320((class_2338)relativePos).method_26234((class_1922)this.field_3851, (class_2338)relativePos)) continue;
            double axisDistance = vec.method_18043(direction.method_10166());
            double d = distance = direction.method_10171() == class_2350.class_2352.field_11056 ? 1.0 - axisDistance : axisDistance;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            distanceDirection = direction;
        }
        int step = distanceDirection.method_10171().method_10181();
        float rand = this.field_3840.method_43057() * 0.1f + 0.1f;
        class_243 movement = new class_243(this.field_3852, this.field_3869, this.field_3850).method_1021(0.75);
        this.field_3852 = movement.field_1352;
        this.field_3869 = movement.field_1351;
        this.field_3850 = movement.field_1350;
        switch (distanceDirection.method_10166()) {
            case field_11048: {
                this.field_3852 = (float)step * rand;
                break;
            }
            case field_11052: {
                this.field_3869 = (float)step * rand;
                break;
            }
            case field_11051: {
                this.field_3850 = (float)step * rand;
            }
        }
        this.field_3845 = false;
    }

    private boolean isInWater(class_238 box) {
        if (!this.touchingUnloadedChunk()) {
            box = box.method_1011(0.001);
            int minX = class_3532.method_15357((double)box.field_1323);
            int maxX = class_3532.method_15384((double)box.field_1320);
            int minY = class_3532.method_15357((double)box.field_1322);
            int maxY = class_3532.method_15384((double)box.field_1325);
            int minZ = class_3532.method_15357((double)box.field_1321);
            int maxZ = class_3532.method_15384((double)box.field_1324);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                        class_3610 fluid = this.field_3851.method_8316(pos);
                        if (!fluid.method_15767(class_3486.field_15517) || !((double)(fluid.method_15763((class_1922)this.field_3851, pos) + (float)y) >= box.field_1322)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        class_243 center = this.method_3064().method_1014(1.0).method_1005();
        return !this.field_3851.method_8477(class_2338.method_49637((double)center.field_1352, (double)center.field_1351, (double)center.field_1350));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void method_3069(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < class_3532.method_33723((double)100.0)) {
            class_243 vec = class_1297.method_20736(null, (class_243)new class_243(x, y, z), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
            x = vec.field_1352;
            y = vec.field_1351;
            z = vec.field_1350;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.method_3067(this.method_3064().method_989(x, y, z));
            this.method_3072();
        }
        boolean bl = this.field_3845 = y != yo && yo < 0.0;
        if (!FancyBlockParticles.CONFIG.terrain.isLowTraction() && !FancyBlockParticles.CONFIG.terrain.isBounceOffWalls()) {
            if (x != xo) {
                this.field_3852 *= 0.7;
            }
            if (z != zo) {
                this.field_3850 *= 0.7;
            }
        }
    }

    protected void method_3072() {
        super.method_3072();
        class_238 box = this.method_3064();
        this.field_3854 = (box.field_1322 + box.field_1325) / 2.0;
    }

    public class_3999 method_18122() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    public int method_3068(float partialTick) {
        int i = super.method_3068(partialTick);
        int j = 0;
        class_238 box = this.method_3064();
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 + (box.field_1325 - box.field_1322) * 0.66 + 0.01 - (FancyBlockParticles.CONFIG.terrain.isRestOnFloor() ? (double)this.field_17867 / 10.0 : 0.0)), (double)this.field_3871);
        if (this.field_3851.method_8477(pos)) {
            j = this.field_3851.method_22336().method_22363(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void method_3074(class_4588 buffer, class_4184 info, float partialTick) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.field_17886.method_4580((double)(this.field_17884 / 4.0f * 16.0f));
            v0 = this.field_17886.method_4570((double)(this.field_17885 / 4.0f * 16.0f));
        }
        float u1 = this.field_17886.method_4580((double)((this.field_17884 + 1.0f) / 4.0f * 16.0f));
        float v1 = this.field_17886.method_4570((double)((this.field_17885 + 1.0f) / 4.0f * 16.0f));
        double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874) - info.method_19326().field_1352;
        double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854) - info.method_19326().field_1351;
        double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871) - info.method_19326().field_1350;
        float scale = class_3532.method_16439((float)partialTick, (float)this.lastSize, (float)this.field_17867);
        float alpha = class_3532.method_16439((float)partialTick, (float)this.lastAlpha, (float)this.field_3841);
        int light = this.method_3068(partialTick);
        if (FancyBlockParticles.CONFIG.terrain.isRestOnFloor()) {
            posY += (double)scale;
        }
        Vector3d smoothRotation = new Vector3d();
        if (FancyBlockParticles.CONFIG.terrain.getRotationMultiplier() > 0.0f) {
            smoothRotation.y = this.rotation.y;
            smoothRotation.z = this.rotation.z;
            if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                smoothRotation.x = this.rotation.x;
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                    smoothRotation.y = class_3532.method_16436((double)partialTick, (double)this.lastRotation.y, (double)this.rotation.y);
                    smoothRotation.z = class_3532.method_16436((double)partialTick, (double)this.lastRotation.z, (double)this.rotation.z);
                } else {
                    smoothRotation.x = class_3532.method_16436((double)partialTick, (double)this.lastRotation.x, (double)this.rotation.x);
                }
            }
        }
        FBPRenderHelper.renderCubeShaded(buffer, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, (float)posX, (float)posY, (float)posZ, scale, smoothRotation, light, this.field_3861, this.field_3842, this.field_3859, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    private void calculateYAngle() {
        double sin = Math.toDegrees(Math.asin(this.field_3852 / Math.sqrt(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850)));
        this.rotation.y = this.field_3850 > 0.0 ? -sin : sin;
    }

    private double getMultiplier() {
        return Math.sqrt(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850) * (FancyBlockParticles.CONFIG.terrain.isRandomRotation() ? 200.0 : 500.0) * (double)FancyBlockParticles.CONFIG.terrain.getRotationMultiplier();
    }

    public static class Provider
    implements class_707<class_2388> {
        private final class_2338 pos;
        private final float scale;
        @Nullable
        private final class_2350 side;
        @Nullable
        private final class_1058 sprite;
        private final float rCol;
        private final float gCol;
        private final float bCol;

        @Nullable
        public FBPTerrainParticle createParticle(class_2388 type, class_638 level, double x, double y, double z, double xd, double yd, double zd) {
            return new FBPTerrainParticle(level, x, y, z, xd, yd, zd, this.scale, this.rCol, this.gCol, this.bCol, this.pos, type.method_10278(), this.side, this.sprite);
        }

        @Generated
        public Provider(class_2338 pos, float scale, @Nullable class_2350 side, @Nullable class_1058 sprite, float rCol, float gCol, float bCol) {
            this.pos = pos;
            this.scale = scale;
            this.side = side;
            this.sprite = sprite;
            this.rCol = rCol;
            this.gCol = gCol;
            this.bCol = bCol;
        }
    }
}

