/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPRainParticle;
import hantonik.fbp.particle.FBPSmokeParticle;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FBPSnowParticle
extends WaterDropParticle
implements IKillableParticle {
    private final Vector3d rotation;
    private final Vector3d rotationStep;
    private final Vector3d lastRotation;
    private final float multiplier;
    private final float scaleAlpha;
    private final float targetSize;
    private final float uo;
    private final float vo;
    private float lastAlpha;
    private float lastSize;
    private double lastXSpeed;
    private double lastZSpeed;
    private boolean wasFrozen;
    private boolean wasInWater;
    private boolean killToggle;
    private boolean visible;

    public FBPSnowParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, TextureAtlasSprite sprite) {
        super(level, x, y, z);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_108321_ = sprite;
        this.f_107225_ = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.snow.getMinLifetime(), FancyBlockParticles.CONFIG.snow.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.snow.getMinLifetime(), FancyBlockParticles.CONFIG.snow.getMaxLifetime()) + 0.5f);
        this.targetSize = this.f_107663_ = Math.max(FBPConstants.RANDOM.nextFloat(FancyBlockParticles.CONFIG.snow.getSizeMultiplier() - 0.1f, FancyBlockParticles.CONFIG.snow.getSizeMultiplier() + 0.1f), 0.1f) * (FancyBlockParticles.CONFIG.snow.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.7f, 1.0f) : 1.0f);
        this.m_6569_(1.0f);
        this.f_107226_ = FancyBlockParticles.CONFIG.snow.getGravityMultiplier();
        this.f_107219_ = true;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107230_ = 0.0f;
        double rx = FBPConstants.RANDOM.nextDouble();
        double ry = FBPConstants.RANDOM.nextDouble();
        double rz = FBPConstants.RANDOM.nextDouble();
        this.rotationStep = new Vector3d(rx > 0.5 ? 1.0 : -1.0, ry > 0.5 ? 1.0 : -1.0, rz > 0.5 ? 1.0 : -1.0);
        this.lastRotation = new Vector3d();
        this.rotation = new Vector3d((Vector3dc)this.rotationStep);
        this.uo = this.f_107223_.m_188501_() * 3.0f;
        this.vo = this.f_107223_.m_188501_() * 3.0f;
        this.scaleAlpha = this.f_107663_ * 0.75f;
        this.f_107663_ = 0.0f;
        this.multiplier = FancyBlockParticles.CONFIG.snow.isRandomFadingSpeed() ? FBPConstants.RANDOM.nextFloat(0.8f, 1.0f) : 1.0f;
    }

    public Particle m_6569_(float scale) {
        super.m_6569_(scale);
        float size = this.f_107663_ / 10.0f;
        this.m_107259_(new AABB(this.f_107212_ - (double)size, this.f_107213_, this.f_107214_ - (double)size, this.f_107212_ + (double)size, this.f_107213_ + (double)(2.0f * size), this.f_107214_ + (double)size));
        return this;
    }

    public void m_5989_() {
        if (FancyBlockParticles.CONFIG.snow.isBounceOffWalls()) {
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!Minecraft.m_91087_().m_91104_() && this.f_107224_ > 0) {
                    if (!this.wasFrozen && (Math.abs(this.f_107215_) > 1.0E-5 || Math.abs(this.f_107217_) > 1.0E-5)) {
                        if (this.f_107209_ == this.f_107212_) {
                            this.f_107215_ = -this.lastXSpeed * 0.625;
                        }
                        if (this.f_107211_ == this.f_107214_) {
                            this.f_107217_ = -this.lastZSpeed * 0.625;
                        }
                    } else {
                        this.wasFrozen = false;
                    }
                }
            } else {
                this.wasFrozen = true;
            }
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.lastAlpha = this.f_107230_;
        this.lastSize = this.f_107663_;
        this.lastRotation.set((Vector3dc)this.rotation);
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.snow.isEnabled()) {
            this.m_107274_();
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            if (this.killToggle) {
                this.m_107274_();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (this.f_107213_ < Minecraft.m_91087_().f_91074_.m_20186_() - (double)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()).intValue() * 16.0) {
                    this.m_107274_();
                }
                if (!FancyBlockParticles.CONFIG.snow.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.f_107224_;
                }
                this.rotation.add((Vector3dc)this.rotationStep.mul((double)(FancyBlockParticles.CONFIG.snow.getRotationMultiplier() * 5.0f), new Vector3d()));
                BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
                Biome.Precipitation precipitation = ((Biome)this.f_107208_.m_204166_(pos).m_203334_()).m_264600_(pos);
                if (this.f_107224_ >= this.f_107225_ || precipitation != Biome.Precipitation.SNOW) {
                    this.f_107663_ *= 0.75f * this.multiplier;
                    if (this.f_107230_ >= 0.01f && this.f_107663_ <= this.scaleAlpha) {
                        this.f_107230_ *= 0.65f * this.multiplier;
                    }
                    if (this.f_107230_ < 0.01f) {
                        this.m_107274_();
                        if (precipitation == Biome.Precipitation.RAIN) {
                            Minecraft.m_91087_().f_91061_.m_107344_(new FBPRainParticle.Provider().createParticle(ParticleTypes.f_123761_.m_6012_(), this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0));
                        }
                    }
                } else if (!this.wasInWater) {
                    if (this.f_107663_ < this.targetSize) {
                        this.f_107663_ += 0.075f * this.multiplier;
                        if (this.f_107663_ > this.targetSize) {
                            this.f_107663_ = this.targetSize;
                        }
                    }
                    if (this.f_107230_ < 1.0f) {
                        this.f_107230_ += 0.045f * this.multiplier;
                        if (this.f_107230_ > 1.0f) {
                            this.f_107230_ = 1.0f;
                        }
                    }
                }
                if (!this.f_107218_) {
                    this.f_107216_ -= (this.wasInWater ? 0.02 : 0.04) * (double)this.f_107226_;
                }
                this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
                if (Math.abs(this.f_107215_) > 1.0E-5) {
                    this.lastXSpeed = this.f_107215_;
                }
                if (Math.abs(this.f_107217_) > 1.0E-5) {
                    this.lastZSpeed = this.f_107217_;
                }
                if (this.f_107218_ && FancyBlockParticles.CONFIG.snow.isRestOnFloor()) {
                    this.rotation.x = (double)Math.round(this.rotation.x / 90.0) * 90.0;
                    this.rotation.z = (double)Math.round(this.rotation.z / 90.0) * 90.0;
                }
                this.f_107215_ *= 0.98;
                if (this.f_107216_ < -0.2) {
                    this.f_107216_ *= 0.75;
                }
                this.f_107217_ *= 0.98;
                BlockState state = this.f_107208_.m_8055_(pos.m_121945_(Direction.DOWN));
                if (this.isInFluid(this.m_107277_(), (TagKey<Fluid>)FluidTags.f_13132_) || (state.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)state)) && this.f_107218_) {
                    this.m_107274_();
                    Minecraft.m_91087_().f_91061_.m_107344_(new FBPSmokeParticle.Provider(this.f_107663_ / 5.0f).createParticle(ParticleTypes.f_123762_, this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.05, 0.0));
                }
                if (this.isInFluid(this.m_107277_(), (TagKey<Fluid>)FluidTags.f_13131_)) {
                    if (FancyBlockParticles.CONFIG.snow.isWaterPhysics()) {
                        this.f_107215_ *= 0.3;
                        this.f_107216_ *= 0.05;
                        this.f_107217_ *= 0.3;
                        this.f_107663_ *= 0.98f * this.multiplier;
                        this.wasInWater = true;
                        if (this.f_107230_ >= 0.01f && this.f_107663_ <= this.scaleAlpha) {
                            this.f_107230_ *= 0.95f * this.multiplier;
                        }
                        if (this.f_107230_ < 0.01f) {
                            this.m_107274_();
                        }
                    } else {
                        this.m_107274_();
                    }
                } else {
                    this.wasInWater = false;
                }
                if (this.f_107218_) {
                    if (FancyBlockParticles.CONFIG.snow.isLowTraction()) {
                        this.f_107215_ *= 0.932;
                        this.f_107217_ *= 0.932;
                    } else {
                        this.f_107215_ *= 0.665;
                        this.f_107217_ *= 0.665;
                    }
                    this.rotationStep.mul(0.85);
                    if (!FancyBlockParticles.CONFIG.snow.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                        this.f_107224_ += 2;
                    }
                }
            }
        }
        Vec3 vec3 = new Vec3(this.f_107212_, Minecraft.m_91087_().f_91075_.m_20186_(), this.f_107214_);
        if (Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(vec3) > (double)(Math.min(FancyBlockParticles.CONFIG.snow.getSimulationDistance(), (Integer)Minecraft.m_91087_().f_91066_.m_232001_().m_231551_()) * 16)) {
            this.m_107274_();
        }
        this.visible = Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(new Vec3(this.f_107212_, Minecraft.m_91087_().f_91075_.m_20186_(), this.f_107214_)) <= (double)(Math.min(FancyBlockParticles.CONFIG.snow.getRenderDistance(), (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()) * 16);
    }

    private boolean isInFluid(AABB box, TagKey<Fluid> fluid) {
        if (!this.touchingUnloadedChunk()) {
            box = box.m_82406_(0.001);
            int minX = Mth.m_14107_((double)box.f_82288_);
            int maxX = Mth.m_14165_((double)box.f_82291_);
            int minY = Mth.m_14107_((double)box.f_82289_);
            int maxY = Mth.m_14165_((double)box.f_82292_);
            int minZ = Mth.m_14107_((double)box.f_82290_);
            int maxZ = Mth.m_14165_((double)box.f_82293_);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                        FluidState fluidState = this.f_107208_.m_6425_(pos);
                        if (!fluidState.m_205070_(fluid) || !((double)(fluidState.m_76155_((BlockGetter)this.f_107208_, pos) + (float)y) >= box.f_82289_)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        Vec3 center = this.m_107277_().m_82400_(1.0).m_82399_();
        return !this.f_107208_.m_46749_(BlockPos.m_274561_((double)center.f_82479_, (double)center.f_82480_, (double)center.f_82481_));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void m_6257_(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.m_144952_((double)100.0)) {
            Vec3 vec = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = vec.f_82479_;
            y = vec.f_82480_;
            z = vec.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = y != yo && yo < 0.0;
        if (!FancyBlockParticles.CONFIG.snow.isLowTraction() && !FancyBlockParticles.CONFIG.snow.isBounceOffWalls()) {
            if (x != xo) {
                this.f_107215_ *= 0.7;
            }
            if (z != zo) {
                this.f_107217_ *= 0.7;
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    protected int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (this.f_107208_.m_46749_(pos)) {
            j = this.f_107208_.m_5518_().m_75831_(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void m_5744_(VertexConsumer buffer, Camera info, float partialTick) {
        if (!this.visible) {
            return;
        }
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.f_108321_.m_118367_((double)(this.uo / 4.0f * 16.0f));
            v0 = this.f_108321_.m_118393_((double)(this.vo / 4.0f * 16.0f));
        }
        float u1 = this.f_108321_.m_118367_((double)((this.uo + 1.0f) / 4.0f * 16.0f));
        float v1 = this.f_108321_.m_118393_((double)((this.vo + 1.0f) / 4.0f * 16.0f));
        double posX = Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - info.m_90583_().f_82479_;
        double posY = Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - info.m_90583_().f_82480_;
        double posZ = Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - info.m_90583_().f_82481_;
        float scale = Mth.m_14179_((float)partialTick, (float)this.lastSize, (float)this.f_107663_) / 10.0f;
        float alpha = Mth.m_14179_((float)partialTick, (float)this.lastAlpha, (float)this.f_107230_);
        int light = this.m_6355_(partialTick);
        if (FancyBlockParticles.CONFIG.snow.isRestOnFloor()) {
            posY += (double)scale;
        }
        Vector3d smoothRotation = new Vector3d(0.0, 0.0, 0.0);
        if (FancyBlockParticles.CONFIG.snow.getRotationMultiplier() > 0.0f) {
            smoothRotation.y = this.rotation.y;
            smoothRotation.z = this.rotation.z;
            if (!FancyBlockParticles.CONFIG.snow.isRandomRotation()) {
                smoothRotation.x = this.rotation.x;
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                Vector3d vec = this.rotation.lerp((Vector3dc)this.lastRotation, (double)partialTick, new Vector3d());
                if (FancyBlockParticles.CONFIG.snow.isRandomRotation()) {
                    smoothRotation.y = vec.y;
                    smoothRotation.z = vec.z;
                } else {
                    smoothRotation.x = vec.x;
                }
            }
        }
        FBPRenderHelper.renderCubeShaded(buffer, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, posX, posY, posZ, scale, smoothRotation, light, this.f_107227_, this.f_107228_, this.f_107229_, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    public record Provider() implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                return null;
            }
            return new FBPSnowParticle(level, x, y, z, FBPConstants.RANDOM.nextDouble(-0.5, 0.5), -FBPConstants.RANDOM.nextDouble(0.25, 1.0), FBPConstants.RANDOM.nextDouble(-0.5, 0.5), Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(Blocks.f_50127_.m_49966_()));
        }
    }
}

