/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class FBPWhiteSmokeParticle
extends SmokeParticle
implements IKillableParticle {
    private final Vector3d[] rotatedCube;
    private final float multiplier;
    private double xdo;
    private double zdo;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean blocked;
    private boolean killToggle;

    protected FBPWhiteSmokeParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float scale) {
        super(level, x, y, z, xd, yd, zd, scale, new SpriteSet(){

            public TextureAtlasSprite m_5819_(int age, int lifetime) {
                return FBPConstants.FBP_PARTICLE_SPRITE.get();
            }

            public TextureAtlasSprite m_213979_(RandomSource random) {
                return FBPConstants.FBP_PARTICLE_SPRITE.get();
            }
        });
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_107216_ *= 0.935;
        this.f_107663_ = FancyBlockParticles.CONFIG.smoke.getSizeMultiplier() * (FancyBlockParticles.CONFIG.smoke.isRandomSize() ? scale * 10.0f : 1.0f);
        this.scaleAlpha = this.f_107663_ * 0.85f;
        this.f_107225_ = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.smoke.getMinLifetime(), FancyBlockParticles.CONFIG.smoke.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.smoke.getMinLifetime(), FancyBlockParticles.CONFIG.smoke.getMaxLifetime()) + 0.5f);
        this.f_107230_ = FBPConstants.RANDOM.nextFloat(0.6f, 0.9f);
        this.f_108321_ = FBPConstants.FBP_PARTICLE_SPRITE.get();
        this.rotatedCube = new Vector3d[FBPConstants.CUBE.length];
        float angleY = this.f_107223_.m_188501_();
        for (int i = 0; i < FBPConstants.CUBE.length; ++i) {
            this.rotatedCube[i] = FBPRenderHelper.rotate(FBPConstants.CUBE[i], 0.0f, angleY, 0.0f);
        }
        this.multiplier = FancyBlockParticles.CONFIG.smoke.isRandomFadingSpeed() ? Mth.m_14036_((float)FBPConstants.RANDOM.nextFloat(0.55f, 1.15f), (float)0.7f, (float)1.0f) : 0.75f;
        this.f_107227_ = FBPConstants.RANDOM.nextFloat(Math.max(1.0f, this.f_107227_ * 1.1f) - 0.1f, 1.0f);
        this.f_107228_ = FBPConstants.RANDOM.nextFloat(Math.max(1.0f, this.f_107228_ * 1.1f) - 0.1f, 1.0f);
        this.f_107229_ = FBPConstants.RANDOM.nextFloat(Math.max(1.0f, this.f_107229_ * 1.1f) - 0.1f, 1.0f);
        this.m_6569_(1.0f);
    }

    public Particle m_6569_(float scale) {
        super.m_6569_(scale);
        float size = this.f_107663_ / 20.0f;
        this.m_107259_(new AABB(this.f_107212_ - (double)size, this.f_107213_ - (double)size, this.f_107214_ - (double)size, this.f_107212_ + (double)size, this.f_107213_ + (double)size, this.f_107214_ + (double)size));
        return this;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.lastAlpha = this.f_107230_;
        this.lastSize = this.f_107663_;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.smoke.isEnabled()) {
            this.m_107274_();
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            if (this.killToggle) {
                this.m_107274_();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.smoke.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.f_107224_;
                }
                if (this.f_107224_ >= this.f_107225_) {
                    this.f_107663_ *= 0.9f * this.multiplier;
                    if ((double)this.f_107230_ >= 0.01 && this.f_107663_ <= this.scaleAlpha) {
                        this.f_107230_ *= 0.76f * this.multiplier;
                    }
                    if ((double)this.f_107230_ < 0.01) {
                        this.m_107274_();
                    }
                }
                this.f_107216_ += 0.004;
                this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
                if (this.f_107213_ == this.f_107210_) {
                    if (!this.blocked) {
                        this.xdo = this.f_107215_;
                        this.zdo = this.f_107217_;
                    }
                    this.blocked = true;
                    if (Math.abs(this.f_107215_) < Math.abs(this.xdo) + 0.035) {
                        this.f_107215_ *= 1.1;
                    }
                    if (Math.abs(this.f_107217_) < Math.abs(this.zdo) + 0.035) {
                        this.f_107217_ *= 1.1;
                    }
                } else if (this.blocked) {
                    this.blocked = false;
                    this.f_107215_ = Mth.m_14139_((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.f_107215_, (double)this.xdo);
                    this.f_107217_ = Mth.m_14139_((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.f_107217_, (double)this.zdo);
                }
                this.f_107215_ *= 0.95;
                this.f_107216_ *= 0.95;
                this.f_107217_ *= 0.95;
                if (this.f_107218_) {
                    this.f_107215_ *= 0.9;
                    this.f_107217_ *= 0.9;
                }
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void m_6257_(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.m_144952_((double)100.0)) {
            Vec3 vec = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = vec.f_82479_;
            y = vec.f_82480_;
            z = vec.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = y != yo && yo < 0.0;
        if (x != xo) {
            this.f_107215_ = 0.0;
        }
        if (z != zo) {
            this.f_107217_ = 0.0;
        }
    }

    protected void m_107275_() {
        super.m_107275_();
        AABB box = this.m_107277_();
        this.f_107213_ = (box.f_82289_ + box.f_82292_) / 2.0;
    }

    public ParticleRenderType m_7556_() {
        return FBPConstants.FBP_PARTICLE_RENDER;
    }

    protected int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (this.f_107208_.m_46749_(pos)) {
            j = this.f_107208_.m_5518_().m_75831_(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void m_5744_(VertexConsumer buffer, Camera info, float partialTick) {
        float u = this.f_108321_.m_118367_((double)4.4f);
        float v = this.f_108321_.m_118393_((double)4.4f);
        double posX = Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - info.m_90583_().f_82479_;
        double posY = Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - info.m_90583_().f_82480_;
        double posZ = Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - info.m_90583_().f_82481_;
        float scale = Mth.m_14179_((float)partialTick, (float)this.lastSize, (float)this.f_107663_);
        float alpha = Mth.m_14179_((float)partialTick, (float)this.lastAlpha, (float)this.f_107230_);
        int light = this.m_6355_(partialTick);
        Vector3d[] cube = new Vector3d[this.rotatedCube.length];
        for (int i = 0; i < cube.length; ++i) {
            Vector3d corner = new Vector3d();
            corner.x = this.rotatedCube[i].x;
            corner.y = this.rotatedCube[i].y;
            corner.z = this.rotatedCube[i].z;
            corner.mul((double)(scale / 20.0f));
            corner.add(posX, posY, posZ);
            cube[i] = corner;
        }
        this.putCube(buffer, cube, u, v, light, this.f_107227_, this.f_107228_, this.f_107229_, alpha);
    }

    private void putCube(VertexConsumer buffer, Vector3d[] cube, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        for (int i = 0; i < cube.length; i += 4) {
            Vector3d vec0 = cube[i];
            Vector3d vec1 = cube[i + 1];
            Vector3d vec2 = cube[i + 2];
            Vector3d vec3 = cube[i + 3];
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.875f;
            this.addVertex(buffer, vec0, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, vec1, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, vec2, u, v, light, red, green, blue, alpha);
            this.addVertex(buffer, vec3, u, v, light, red, green, blue, alpha);
        }
    }

    private void addVertex(VertexConsumer buffer, Vector3d pos, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        buffer.m_5483_(pos.x, pos.y, pos.z).m_7421_(u, v).m_85950_(rCol, gCol, bCol, alpha).m_85969_(light).m_5752_();
    }

    public record Provider(float scale) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.smoke.isSpawnWhileFrozen()) {
                return null;
            }
            FBPWhiteSmokeParticle particle = new FBPWhiteSmokeParticle(level, x, y, z, xd, yd, zd, this.scale);
            particle.m_107253_(Mth.m_14036_((float)(particle.f_107227_ + 0.1f), (float)0.1f, (float)1.0f), Mth.m_14036_((float)(particle.f_107228_ + 0.1f), (float)0.1f, (float)1.0f), Mth.m_14036_((float)(particle.f_107229_ + 0.1f), (float)0.1f, (float)1.0f));
            return particle;
        }
    }
}

