/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.animation.FBPPlacingAnimationManager;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.platform.Services;
import hantonik.fbp.util.FBPConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_10889;
import net.minecraft.class_11944;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.apache.commons.compress.utils.Lists;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPPlacingAnimationParticle
extends class_3940
implements IKillableParticle {
    private final class_2680 state;
    private final class_2338 pos;
    private final List<class_10889> model;
    private final class_243 rotation;
    private final class_241 slide;
    private final float angleY;
    private boolean killToggle;

    public FBPPlacingAnimationParticle(class_638 level, class_2680 state, class_2338 pos, class_1309 placer, class_1268 hand) {
        super(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), null);
        this.state = state;
        this.pos = pos;
        this.model = class_310.method_1551().method_1541().method_3349(state).method_68512(class_5819.method_43049((long)state.method_26190(pos)));
        this.field_3847 = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.animations.getMinLifetime(), FancyBlockParticles.CONFIG.animations.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.animations.getMinLifetime(), FancyBlockParticles.CONFIG.animations.getMaxLifetime()) + 0.5f);
        Vector3f horizontalLook = placer.method_5720().method_46409().mul(-1.0f, 0.0f, -1.0f).normalize();
        float handMultiplier = placer.method_6068() == class_1306.field_6183 ? 1.0f : -1.0f;
        Matrix3f changeOfBasis = new Matrix3f((Vector3fc)new Vector3f(horizontalLook.z, 0.0f, -horizontalLook.x).mul(hand == class_1268.field_5808 ? handMultiplier : -handMultiplier), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)horizontalLook);
        this.rotation = FBPConstants.ANIMATION_ROTATION;
        Vector3f translation = FBPConstants.ANIMATION_TRANSLATION.method_46409();
        float slidePow = translation.length();
        if (placer.method_36455() <= 0.0f) {
            translation.mul(1.0f, -1.0f, 1.0f);
        }
        Vector3f slideDir = this.adjustDirection(level, placer, translation.mul((Matrix3fc)changeOfBasis));
        class_243 animationDir = new class_243(slideDir.normalize());
        this.angleY = (float)Math.atan2(slideDir.x, slideDir.z);
        class_243 yRot = animationDir.method_1024(-this.angleY);
        this.slide = new class_241((float)yRot.field_1350, (float)yRot.field_1351).method_35582(slidePow);
        this.field_3862 = false;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (!FancyBlockParticles.CONFIG.animations.isEnabled() || !FancyBlockParticles.CONFIG.isBlockAnimationsEnabled(this.state.method_26204())) {
            this.method_3085();
        }
        if (!class_310.method_1551().method_1493()) {
            if (this.killToggle) {
                this.method_3085();
            }
            ++this.field_3866;
            if (this.field_3866 == this.field_3847 + 1) {
                FBPPlacingAnimationManager.showBlock(this.pos, false);
            }
            if (this.field_3866 >= this.field_3847 + 2) {
                this.method_3085();
            }
        }
        if (this.field_3851.method_8320(this.pos) != this.state) {
            this.method_3085();
        }
    }

    public void method_3085() {
        if (!this.field_3843) {
            FBPPlacingAnimationManager.showBlock(this.pos, true);
        }
        super.method_3085();
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    public int method_3068(float partialTick) {
        return this.field_3851.method_22340(this.pos) ? class_761.method_23793((class_761.class_10948)class_761.class_10948.field_58200, (class_1920)this.field_3851, (class_2680)this.state, (class_2338)this.pos) : 0;
    }

    public void method_3074(class_11944 renderState, class_4184 info, float partialTick) {
        double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874) - info.method_19326().field_1352 + 0.5;
        double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854) - info.method_19326().field_1351 + 0.5;
        double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871) - info.method_19326().field_1350 + 0.5;
        class_4587 stack = new class_4587();
        stack.method_22904(posX, posY, posZ);
        float progress = Math.min(1.0f, ((float)this.field_3866 + partialTick) / ((float)this.field_3847 + 1.0f));
        class_243 offset = this.state.method_26226(this.pos);
        stack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.angleY));
        this.slideIn(stack, progress);
        this.rotate(stack, progress);
        this.scale(stack, progress);
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotation(-this.angleY));
        stack.method_22904(-offset.field_1352, -offset.field_1351, -offset.field_1350);
        stack.method_46416(-0.5f, -0.5f, -0.5f);
        Services.CLIENT.renderBlock(this.field_3851, this.model, this.state, this.pos, stack, (class_4597)class_310.method_1551().method_22940().method_23000());
    }

    private void slideIn(class_4587 stack, float progress) {
        class_241 translate = this.slide.method_35582(1.0f - this.exponent(0.9f, progress));
        stack.method_46416(0.0f, translate.field_1342, translate.field_1343);
    }

    private void rotate(class_4587 stack, float progress) {
        Vector3f rotation = this.rotation.method_1021((double)(1.0f - this.exponent(-0.08f, progress))).method_46409();
        Vector3f pivot = FBPConstants.ANIMATION_PIVOT.method_46409();
        if ((double)this.slide.field_1342 < 0.0) {
            pivot.mul(1.0f, -1.0f, 1.0f);
            rotation.mul(-1.0f, 1.0f, -1.0f);
        }
        stack.method_46416(pivot.x, pivot.y, pivot.z);
        stack.method_22907((Quaternionfc)class_7833.field_40714.rotation(rotation.x));
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotation(rotation.y));
        stack.method_22907((Quaternionfc)class_7833.field_40718.rotation(rotation.z));
        stack.method_46416(-pivot.x, -pivot.y, -pivot.z);
    }

    private void scale(class_4587 stack, float progress) {
        float startScale = FancyBlockParticles.CONFIG.animations.getSizeMultiplier();
        float scale = startScale + (1.0f - startScale) * this.exponent(-0.7f, progress);
        stack.method_22905(scale, scale, scale);
    }

    private Vector3f adjustDirection(class_638 level, class_1309 placer, Vector3f slideDir) {
        ArrayList emptyDirections = Lists.newArrayList();
        for (class_2350 side : class_2350.values()) {
            class_2338 sidePos = this.pos.method_10093(side);
            class_265 sideCollision = level.method_8320(sidePos).method_26220((class_1922)level, sidePos);
            if (sideCollision.method_1110()) {
                emptyDirections.add(side);
                continue;
            }
            if (side.method_10171() == class_2350.class_2352.field_11056) {
                if (!(sideCollision.method_1091(side.method_10166()) > 0.25)) continue;
                emptyDirections.add(side);
                continue;
            }
            if (!(sideCollision.method_1091(side.method_10166()) < 0.75)) continue;
            emptyDirections.add(side);
        }
        List<class_2350> affectedDirections = FBPPlacingAnimationParticle.getAffectedDirections(slideDir.x, slideDir.y, slideDir.z);
        for (class_2350 side : affectedDirections) {
            if (emptyDirections.contains(side)) continue;
            slideDir.sub((Vector3fc)side.method_23955().absolute().mul((Vector3fc)slideDir));
        }
        if (!emptyDirections.isEmpty() && slideDir.length() == 0.0f) {
            List<class_2350> nearestDirections = List.of(class_2350.method_10159((class_1297)placer));
            emptyDirections.sort(Comparator.comparingInt(nearestDirections::indexOf));
            slideDir.set((Vector3fc)((class_2350)emptyDirections.getFirst()).method_23955());
        }
        return slideDir;
    }

    private static List<class_2350> getAffectedDirections(float x, float y, float z) {
        return (List)class_156.method_654((Object)Lists.newArrayList(), list -> {
            if (x > 0.0f) {
                list.add(class_2350.field_11034);
            }
            if (x < 0.0f) {
                list.add(class_2350.field_11039);
            }
            if (y > 0.0f) {
                list.add(class_2350.field_11036);
            }
            if (y < 0.0f) {
                list.add(class_2350.field_11033);
            }
            if (z > 0.0f) {
                list.add(class_2350.field_11035);
            }
            if (z < 0.0f) {
                list.add(class_2350.field_11043);
            }
        });
    }

    private float exponent(float curve, float time) {
        double base = curve > 0.0f ? -Math.log(curve) : Math.log(-curve) - 1.0;
        return (float)(base * Math.pow(1.0 / base + 1.0, time) - base);
    }
}

