/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.util;

import hantonik.fbp.platform.Services;
import hantonik.fbp.util.FBPConstants;
import lombok.Generated;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Vector2f;
import org.joml.Vector3d;

public final class FBPRenderHelper {
    public static void renderCubeShaded(class_4588 buffer, Vector2f[] uv, double xPos, double yPos, double zPos, double scale, Vector3d rotation, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        float radX = (float)Math.toRadians(rotation.x);
        float radY = (float)Math.toRadians(rotation.y);
        float radZ = (float)Math.toRadians(rotation.z);
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3d v1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d normal = FBPRenderHelper.rotate(FBPConstants.CUBE_NORMALS[i / 4], radX, radY, radZ);
            float shade = Services.CLIENT.getShade((float)normal.x, (float)normal.y, (float)normal.z, true);
            if (cartoon) {
                FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v2, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v3, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v4, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                continue;
            }
            FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v2, uv[1].x, uv[1].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v3, uv[2].x, uv[2].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v4, uv[3].x, uv[3].y, light, red * shade, green * shade, blue * shade, alpha, normal);
        }
    }

    public static void renderCubeShaded(class_4588 buffer, Vector2f[] uv, double xPos, double yPos, double zPos, double width, double height, Vector3d rotation, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        float radX = (float)Math.toRadians(rotation.x);
        float radY = (float)Math.toRadians(rotation.y);
        float radZ = (float)Math.toRadians(rotation.z);
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3d v1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d v2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d v3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d v4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d normal = FBPRenderHelper.rotate(FBPConstants.CUBE_NORMALS[i / 4], radX, radY, radZ);
            float shade = Services.CLIENT.getShade((float)normal.x, (float)normal.y, (float)normal.z, true);
            if (cartoon) {
                FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v2, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v3, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v4, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                continue;
            }
            FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v2, uv[1].x, uv[1].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v3, uv[2].x, uv[2].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v4, uv[3].x, uv[3].y, light, red * shade, green * shade, blue * shade, alpha, normal);
        }
    }

    public static void addVertex(class_4588 buffer, Vector3d pos, float u, float v, int light, float red, float green, float blue, float alpha, Vector3d normal) {
        buffer.method_22912((float)pos.x, (float)pos.y, (float)pos.z).method_22915(red, green, blue, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_22914((float)normal.x, (float)normal.y, (float)normal.z);
    }

    public static Vector3d rotate(Vector3d vector, float angleX, float angleY, float angleZ) {
        Vector3d sin = new Vector3d((double)class_3532.method_15374((float)angleX), (double)class_3532.method_15374((float)angleY), (double)class_3532.method_15374((float)angleZ));
        Vector3d cos = new Vector3d((double)class_3532.method_15362((float)angleX), (double)class_3532.method_15362((float)angleY), (double)class_3532.method_15362((float)angleZ));
        vector = new Vector3d(vector.x, vector.y * cos.x - vector.z * sin.x, vector.y * sin.x + vector.z * cos.x);
        vector = new Vector3d(vector.x * cos.z - vector.y * sin.z, vector.x * sin.z + vector.y * cos.z, vector.z);
        vector = new Vector3d(vector.x * cos.y + vector.z * sin.y, vector.y, vector.x * sin.y - vector.z * cos.y);
        return vector;
    }

    @Generated
    private FBPRenderHelper() {
    }
}

