/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.mixin;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPTerrainParticle;
import hantonik.fbp.util.BlacklistMode;
import hantonik.fbp.util.FBPConstants;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientLevel
extends Level {
    @Shadow
    @Final
    private Minecraft minecraft;

    protected MixinClientLevel(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeHolder, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeHolder, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(at={@At(value="HEAD")}, method={"addDestroyBlockEffect"}, cancellable=true)
    public void addDestroyBlockEffect(BlockPos pos, BlockState state, CallbackInfo callback) {
        if (FancyBlockParticles.CONFIG.getBlockParticlesMode(state.getBlock()) != BlacklistMode.VANILLA) {
            callback.cancel();
        }
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.terrain.isFancyBreakingParticles() || FancyBlockParticles.CONFIG.getBlockParticlesMode(state.getBlock()) != BlacklistMode.FANCY) {
            return;
        }
        if (!state.isAir() && state.shouldSpawnTerrainParticles()) {
            VoxelShape shape = state.getShape((BlockGetter)((ClientLevel)this), pos);
            TextureAtlasSprite sprite = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(state);
            int particlesPerAxis = FancyBlockParticles.CONFIG.terrain.getParticlesPerAxis();
            if (!(state.getBlock() instanceof LiquidBlock || FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.terrain.isSpawnWhileFrozen())) {
                shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    double dx = Math.min(1.0, maxX - minX);
                    double dy = Math.min(1.0, maxY - minY);
                    double dz = Math.min(1.0, maxZ - minZ);
                    int particlesPerX = Math.max(2, Mth.ceil((double)(dx * (double)particlesPerAxis)));
                    int particlesPerY = Math.max(2, Mth.ceil((double)(dy * (double)particlesPerAxis)));
                    int particlesPerZ = Math.max(2, Mth.ceil((double)(dz * (double)particlesPerAxis)));
                    for (int i = 0; i < particlesPerX; ++i) {
                        for (int j = 0; j < particlesPerY; ++j) {
                            for (int k = 0; k < particlesPerZ; ++k) {
                                double x = ((double)i + 0.5) / (double)particlesPerX * dx + minX;
                                double y = ((double)j + 0.5) / (double)particlesPerY * dy + minY;
                                double z = ((double)k + 0.5) / (double)particlesPerZ * dz + minZ;
                                this.minecraft.particleEngine.add((Particle)new FBPTerrainParticle((ClientLevel)this, (double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z, x - 0.5, -0.001, z - 0.5, FBPConstants.RANDOM.nextFloat(0.75f, 1.0f), 1.0f, 1.0f, 1.0f, pos, state, null, sprite));
                            }
                        }
                    }
                });
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addBreakingBlockEffect"}, cancellable=true)
    public void addBreakingBlockEffect(BlockPos pos, Direction side, CallbackInfo callback) {
        BlockState state = this.getBlockState(pos);
        if (FancyBlockParticles.CONFIG.getBlockParticlesMode(state.getBlock()) != BlacklistMode.VANILLA) {
            callback.cancel();
        }
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.terrain.isFancyCrackingParticles() || FancyBlockParticles.CONFIG.getBlockParticlesMode(state.getBlock()) != BlacklistMode.FANCY) {
            return;
        }
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            double z;
            double y;
            double x;
            int posX = pos.getX();
            int posY = pos.getY();
            int posZ = pos.getZ();
            AABB bounds = state.getShape((BlockGetter)((ClientLevel)this), pos).bounds();
            HitResult hit = Minecraft.getInstance().hitResult;
            if (hit == null) {
                hit = new BlockHitResult(new Vec3((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5), null, pos, false);
            }
            if (FancyBlockParticles.CONFIG.terrain.isSmartBreaking() && !(state.getBlock() instanceof LiquidBlock) && (!FancyBlockParticles.CONFIG.global.isFreezeEffect() || FancyBlockParticles.CONFIG.terrain.isSpawnWhileFrozen())) {
                x = hit.getLocation().x + FBPConstants.RANDOM.nextDouble(-0.21, 0.21) * Math.abs(bounds.maxX - bounds.minX);
                y = hit.getLocation().y + FBPConstants.RANDOM.nextDouble(-0.21, 0.21) * Math.abs(bounds.maxY - bounds.minY);
                z = hit.getLocation().z + FBPConstants.RANDOM.nextDouble(-0.21, 0.21) * Math.abs(bounds.maxZ - bounds.minZ);
            } else {
                x = (double)posX + this.random.nextDouble() * (bounds.maxX - bounds.minX - 0.2) + 0.1 + bounds.minX;
                y = (double)posY + this.random.nextDouble() * (bounds.maxY - bounds.minY - 0.2) + 0.1 + bounds.minY;
                z = (double)posZ + this.random.nextDouble() * (bounds.maxZ - bounds.minZ - 0.2) + 0.1 + bounds.minZ;
            }
            switch (side) {
                case NORTH: {
                    z = (double)posZ + bounds.minZ - 0.1;
                    break;
                }
                case EAST: {
                    x = (double)posX + bounds.maxX + 0.1;
                    break;
                }
                case SOUTH: {
                    z = (double)posZ + bounds.maxZ + 0.1;
                    break;
                }
                case WEST: {
                    x = (double)posX + bounds.minX - 0.1;
                    break;
                }
                case UP: {
                    y = (double)posY + bounds.maxY + 0.1;
                    break;
                }
                case DOWN: {
                    y = (double)posY + bounds.minY - 0.1;
                }
            }
            if (!(state.getBlock() instanceof LiquidBlock || FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.terrain.isSpawnWhileFrozen())) {
                Int2ObjectMap destroyingBlocks = Minecraft.getInstance().levelRenderer.destroyingBlocks;
                int damage = 0;
                if (!destroyingBlocks.isEmpty()) {
                    for (BlockDestructionProgress progress : destroyingBlocks.values()) {
                        if (progress.getPos() != pos) continue;
                        damage = progress.getProgress();
                        break;
                    }
                }
                FBPTerrainParticle particle = new FBPTerrainParticle((ClientLevel)this, x, y, z, 0.0, 0.0, 0.0, 2.0f, 1.0f, 1.0f, 1.0f, pos, state, side, null);
                if (FancyBlockParticles.CONFIG.terrain.isSmartBreaking()) {
                    particle.setPower(side == Direction.UP ? 0.7f : 0.15f);
                    particle.scale(0.325f + (float)damage / 10.0f * 0.5f);
                } else {
                    particle.setPower(0.2f);
                    particle.scale(0.6f);
                }
                this.minecraft.particleEngine.add((Particle)particle);
            }
        }
    }
}

