/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.mixin;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPCampfireSmokeParticle;
import hantonik.fbp.particle.FBPDripParticle;
import hantonik.fbp.particle.FBPFireflyParticle;
import hantonik.fbp.particle.FBPFlameParticle;
import hantonik.fbp.particle.FBPLavaParticle;
import hantonik.fbp.particle.FBPRainParticle;
import hantonik.fbp.particle.FBPSmokeParticle;
import hantonik.fbp.particle.FBPSnowParticle;
import hantonik.fbp.particle.FBPTerrainParticle;
import hantonik.fbp.particle.FBPTrailParticle;
import hantonik.fbp.particle.FBPWhiteSmokeParticle;
import hantonik.fbp.util.BlacklistMode;
import hantonik.fbp.util.FBPConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.CampfireSmokeParticle;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.FireflyParticle;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.LavaParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SnowflakeParticle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.particle.TrailParticle;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.particle.WhiteSmokeParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ParticleEngine.class})
public abstract class MixinParticleEngine {
    @Shadow
    protected ClientLevel level;
    @Shadow
    @Final
    private RandomSource random;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Inject(at={@At(value="RETURN")}, method={"makeParticle"}, cancellable=true)
    private <T extends ParticleOptions> void makeParticle(T options, double x, double y, double z, double xd, double yd, double zd, CallbackInfoReturnable<Particle> callback) {
        Object data;
        Object object;
        DripParticle original;
        SimpleParticleType type;
        block53: {
            Object object2;
            block54: {
                Object object3;
                if (!FancyBlockParticles.CONFIG.global.isEnabled()) {
                    return;
                }
                if (FancyBlockParticles.CONFIG.flame.isEnabled() && !(callback.getReturnValue() instanceof FBPFlameParticle) && options instanceof SimpleParticleType) {
                    type = (SimpleParticleType)options;
                    if (callback.getReturnValue() instanceof FlameParticle) {
                        if (options.getType() == ParticleTypes.FLAME || options.getType() == ParticleTypes.SOUL_FIRE_FLAME) {
                            callback.setReturnValue((Object)new FBPFlameParticle.Provider(options.getType() == ParticleTypes.SOUL_FIRE_FLAME).createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        }
                        if (options.getType() == ParticleTypes.SMALL_FLAME) {
                            callback.setReturnValue((Object)new FBPFlameParticle.SmallFlameProvider().createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        }
                    }
                    if (callback.getReturnValue() instanceof LavaParticle && options.getType() == ParticleTypes.LAVA) {
                        callback.setReturnValue((Object)new FBPLavaParticle.Provider().createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                    }
                }
                if (FancyBlockParticles.CONFIG.smoke.isEnabled() && !(callback.getReturnValue() instanceof FBPSmokeParticle) && options instanceof SimpleParticleType) {
                    type = (SimpleParticleType)options;
                    Object object4 = callback.getReturnValue();
                    if (object4 instanceof SmokeParticle) {
                        SmokeParticle smokeParticle = (SmokeParticle)object4;
                        if (options.getType() == ParticleTypes.SMOKE || options.getType() == ParticleTypes.LARGE_SMOKE) {
                            callback.setReturnValue((Object)new FBPSmokeParticle.Provider(smokeParticle.getQuadSize(1.0f)).createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        }
                    }
                    if ((object4 = callback.getReturnValue()) instanceof WhiteSmokeParticle) {
                        WhiteSmokeParticle whiteSmokeParticle = (WhiteSmokeParticle)object4;
                        if (options.getType() == ParticleTypes.WHITE_SMOKE) {
                            callback.setReturnValue((Object)new FBPWhiteSmokeParticle.Provider(whiteSmokeParticle.getQuadSize(1.0f)).createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        }
                    }
                }
                if (FancyBlockParticles.CONFIG.campfireSmoke.isEnabled() && !(callback.getReturnValue() instanceof FBPCampfireSmokeParticle) && options instanceof SimpleParticleType) {
                    type = (SimpleParticleType)options;
                    if (callback.getReturnValue() instanceof CampfireSmokeParticle) {
                        if (options.getType() == ParticleTypes.CAMPFIRE_COSY_SMOKE) {
                            callback.setReturnValue((Object)new FBPCampfireSmokeParticle.Provider(false).createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        }
                        if (options.getType() == ParticleTypes.CAMPFIRE_SIGNAL_SMOKE) {
                            callback.setReturnValue((Object)new FBPCampfireSmokeParticle.Provider(true).createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        }
                    }
                }
                if (FancyBlockParticles.CONFIG.trail.isEnabled() && !(callback.getReturnValue() instanceof FBPTrailParticle) && options instanceof TrailParticleOption) {
                    type = (TrailParticleOption)options;
                    if (callback.getReturnValue() instanceof TrailParticle && options.getType() == ParticleTypes.TRAIL) {
                        callback.setReturnValue((Object)new FBPTrailParticle.Provider().createParticle((TrailParticleOption)type, this.level, x, y, z, xd, yd, zd, this.random));
                    }
                }
                if (FancyBlockParticles.CONFIG.firefly.isEnabled() && !(callback.getReturnValue() instanceof FBPFireflyParticle) && options instanceof SimpleParticleType) {
                    type = (SimpleParticleType)options;
                    if (callback.getReturnValue() instanceof FireflyParticle && options.getType() == ParticleTypes.FIREFLY) {
                        callback.setReturnValue((Object)new FBPFireflyParticle.Provider().createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                    }
                }
                if ((FancyBlockParticles.CONFIG.rain.isEnabled() || FancyBlockParticles.CONFIG.snow.isEnabled()) && !(callback.getReturnValue() instanceof FBPRainParticle) && !(callback.getReturnValue() instanceof FBPSnowParticle) && options instanceof SimpleParticleType) {
                    type = (SimpleParticleType)options;
                    if (callback.getReturnValue() instanceof WaterDropParticle && options.getType() == ParticleTypes.RAIN) {
                        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
                        Biome.Precipitation precipitation = ((Biome)this.level.getBiome(blockPos).value()).getPrecipitationAt(blockPos, this.level.getSeaLevel());
                        if (precipitation == Biome.Precipitation.SNOW) {
                            callback.setReturnValue((Object)new FBPSnowParticle.Provider().createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        } else {
                            callback.setReturnValue((Object)new FBPRainParticle.Provider().createParticle(type, this.level, x, y, z, xd, yd, zd, this.random));
                        }
                    }
                }
                if (FancyBlockParticles.CONFIG.drip.isEnabled() && !(callback.getReturnValue() instanceof FBPDripParticle) && (object3 = callback.getReturnValue()) instanceof DripParticle) {
                    original = (DripParticle)object3;
                    if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.drip.isSpawnWhileFrozen()) {
                        callback.setReturnValue(null);
                    } else {
                        void var16_19;
                        BlockState blockState = original.type == Fluids.EMPTY ? Blocks.SNOW_BLOCK.defaultBlockState() : original.type.defaultFluidState().createLegacyBlock();
                        SoundEvent sound = null;
                        float f = original.rCol;
                        float gCol = original.gCol;
                        float bCol = original.bCol;
                        float alpha = 1.0f;
                        int lightLevel = -1;
                        if (options == ParticleTypes.DRIPPING_WATER || options == ParticleTypes.DRIPPING_DRIPSTONE_WATER) {
                            alpha = FancyBlockParticles.CONFIG.rain.getTransparency();
                            int color = this.level.getSkyColor(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), 0.0f);
                            f = ARGB.redFloat((int)color);
                            gCol = Mth.clamp((float)(ARGB.greenFloat((int)color) + 0.1f), (float)0.1f, (float)1.0f);
                            bCol = Mth.clamp((float)(ARGB.blueFloat((int)color) + 0.5f), (float)0.5f, (float)1.0f);
                        }
                        if (options == ParticleTypes.DRIPPING_DRIPSTONE_WATER) {
                            sound = SoundEvents.POINTED_DRIPSTONE_DRIP_WATER;
                        }
                        if (options == ParticleTypes.DRIPPING_LAVA || options == ParticleTypes.DRIPPING_DRIPSTONE_LAVA) {
                            f = 1.0f;
                            gCol = 0.75f;
                            bCol = 0.75f;
                        }
                        if (options == ParticleTypes.DRIPPING_DRIPSTONE_LAVA) {
                            sound = SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA;
                        }
                        if (options == ParticleTypes.DRIPPING_HONEY) {
                            BlockState blockState2 = Blocks.HONEY_BLOCK.defaultBlockState();
                            sound = SoundEvents.BEEHIVE_DRIP;
                        }
                        if (options == ParticleTypes.DRIPPING_OBSIDIAN_TEAR) {
                            lightLevel = 10;
                        }
                        callback.setReturnValue((Object)new FBPDripParticle.Provider((BlockState)var16_19, sound, f, gCol, bCol, alpha, lightLevel).createParticle(options, this.level, x, y, z, xd, yd, zd, this.random));
                    }
                }
                if (!FancyBlockParticles.CONFIG.terrain.isFancyBreakingParticles() || callback.getReturnValue() instanceof FBPTerrainParticle) break block53;
                if (!(options instanceof BlockParticleOption)) break block54;
                type = (BlockParticleOption)options;
                Object object5 = callback.getReturnValue();
                if (!(object5 instanceof TerrainParticle)) break block54;
                TerrainParticle terrainParticle = (TerrainParticle)object5;
                if (options.getType() == ParticleTypes.BLOCK) {
                    BlacklistMode blacklistMode = FancyBlockParticles.CONFIG.getBlockParticlesMode(type.getState().getBlock());
                    if (blacklistMode != BlacklistMode.VANILLA) {
                        callback.setReturnValue(null);
                    }
                    if (blacklistMode == BlacklistMode.FANCY && (!FancyBlockParticles.CONFIG.global.isFreezeEffect() || FancyBlockParticles.CONFIG.terrain.isSpawnWhileFrozen()) && this.level.getFluidState(terrainParticle.pos).isEmpty()) {
                        callback.setReturnValue((Object)new FBPTerrainParticle.Provider(terrainParticle.pos, terrainParticle.getQuadSize(1.0f) * 5.0f, null, terrainParticle.sprite, terrainParticle.rCol, terrainParticle.gCol, terrainParticle.bCol).createParticle((BlockParticleOption)type, this.level, x, y, z, 0.0, 0.0, 0.0, this.random));
                    }
                }
                break block53;
            }
            if ((object2 = callback.getReturnValue()) instanceof SnowflakeParticle) {
                BlacklistMode blacklistMode;
                SnowflakeParticle original2 = (SnowflakeParticle)object2;
                if (options.getType() == ParticleTypes.SNOWFLAKE && (blacklistMode = FancyBlockParticles.CONFIG.getBlockParticlesMode(Blocks.POWDER_SNOW)) != BlacklistMode.VANILLA) {
                    if (blacklistMode == BlacklistMode.BLACKLISTED || FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.terrain.isSpawnWhileFrozen()) {
                        callback.setReturnValue(null);
                    } else if (blacklistMode == BlacklistMode.FANCY) {
                        callback.setReturnValue((Object)new FBPTerrainParticle.Provider(BlockPos.containing((double)x, (double)y, (double)z), original2.getQuadSize(1.0f) * 5.0f, null, null, original2.rCol, original2.gCol, original2.bCol).createParticle(new BlockParticleOption(ParticleTypes.BLOCK, Blocks.POWDER_SNOW.defaultBlockState()), this.level, x, y, z, 0.0, 0.0, 0.0, this.random));
                    }
                }
            }
        }
        if ((object = callback.getReturnValue()) instanceof BreakingItemParticle) {
            ItemParticleOption itemParticleOption;
            ItemParticleOption itemParticleOption2;
            original = (BreakingItemParticle)object;
            if (options.getType() == ParticleTypes.ITEM_SNOWBALL || options instanceof ItemParticleOption && (itemParticleOption2 = (ItemParticleOption)options).getItem().is(Items.SNOWBALL)) {
                BlacklistMode blacklistMode = FancyBlockParticles.CONFIG.getBlockParticlesMode(Blocks.SNOW);
                if (blacklistMode != BlacklistMode.VANILLA) {
                    callback.setReturnValue(null);
                }
                if (FancyBlockParticles.CONFIG.misc.isFancySnowballParticles() && blacklistMode == BlacklistMode.FANCY) {
                    callback.setReturnValue((Object)new FBPTerrainParticle.Provider(BlockPos.containing((double)x, (double)y, (double)z), FBPConstants.RANDOM.nextFloat(0.35f, 0.6f) * FancyBlockParticles.CONFIG.misc.getSnowballParticleSizeMultiplier(), null, null, original.rCol, original.gCol, original.bCol).createParticle(new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), this.level, x, y, z, 0.0, 0.0, 0.0, this.random));
                }
            } else if (options.getType() == ParticleTypes.ITEM_SLIME || options instanceof ItemParticleOption && (data = (ItemParticleOption)options).getItem().is(Items.SLIME_BALL)) {
                BlacklistMode blacklistMode = FancyBlockParticles.CONFIG.getBlockParticlesMode(Blocks.SLIME_BLOCK);
                if (blacklistMode != BlacklistMode.VANILLA) {
                    callback.setReturnValue(null);
                }
                if (FancyBlockParticles.CONFIG.misc.isFancySlimeParticles() && blacklistMode == BlacklistMode.FANCY) {
                    callback.setReturnValue((Object)new FBPTerrainParticle.Provider(BlockPos.containing((double)x, (double)y, (double)z), FBPConstants.RANDOM.nextFloat(0.35f, 0.6f) * FancyBlockParticles.CONFIG.misc.getSlimeParticleSizeMultiplier(), null, null, original.rCol, original.gCol, original.bCol).createParticle(new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()), this.level, x, y, z, 0.0, 0.0, 0.0, this.random));
                }
            } else if (options.getType() == ParticleTypes.ITEM && options instanceof ItemParticleOption && (itemParticleOption = (ItemParticleOption)options).getItem().is(Items.SPLASH_POTION)) {
                BlacklistMode mode = FancyBlockParticles.CONFIG.getBlockParticlesMode(Blocks.GLASS);
                if (mode != BlacklistMode.VANILLA) {
                    callback.setReturnValue(null);
                }
                if (FancyBlockParticles.CONFIG.misc.isFancyBreakingSplashPotionParticles() && mode == BlacklistMode.FANCY) {
                    callback.setReturnValue((Object)new FBPTerrainParticle.Provider(BlockPos.containing((double)x, (double)y, (double)z), FBPConstants.RANDOM.nextFloat(0.5f, 0.75f) * FancyBlockParticles.CONFIG.misc.getBreakingSplashPotionParticleSizeMultiplier(), null, null, original.rCol, original.gCol, original.bCol).createParticle(new BlockParticleOption(ParticleTypes.BLOCK, Blocks.GLASS.defaultBlockState()), this.level, x, y, z, xd, yd, zd, this.random));
                }
            }
        }
        if (!FancyBlockParticles.CONFIG.terrain.isFancyFallingDustParticles()) return;
        if (callback.getReturnValue() instanceof FBPTerrainParticle) return;
        if (!(options instanceof BlockParticleOption)) return;
        type = (BlockParticleOption)options;
        data = callback.getReturnValue();
        if (!(data instanceof FallingDustParticle)) return;
        FallingDustParticle fallingDustParticle = (FallingDustParticle)data;
        if (options.getType() != ParticleTypes.FALLING_DUST) return;
        BlacklistMode mode = FancyBlockParticles.CONFIG.getBlockParticlesMode(type.getState().getBlock());
        if (mode == BlacklistMode.VANILLA) return;
        if (mode == BlacklistMode.BLACKLISTED || FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.terrain.isSpawnWhileFrozen()) {
            callback.setReturnValue(null);
            return;
        }
        if (mode != BlacklistMode.FANCY) return;
        callback.setReturnValue((Object)new FBPTerrainParticle.Provider(BlockPos.containing((double)x, (double)y, (double)z), fallingDustParticle.getQuadSize(1.0f) * 6.0f, null, null, 1.0f, 1.0f, 1.0f).createParticle((BlockParticleOption)type, this.level, x, y, z, 0.0, 0.0, 0.0, this.random).setPower(0.2f).setYSpeed(0.0));
    }
}

