/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FireflyParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPFireflyParticle
extends FireflyParticle
implements IKillableParticle {
    private float angleY;
    private float lastAngleY;
    private float lastAlpha;
    private float lastSize;
    private boolean moved;
    private boolean dimming;
    private int cooldown;
    private final float multiplier;
    private boolean killToggle;

    public FBPFireflyParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd, FBPConstants.FBP_PARTICLE_SPRITE.get());
        this.yd = 8.5E-4;
        this.gravity = 0.001f;
        this.friction = 0.985f;
        this.rCol = 1.0f;
        this.gCol = Mth.lerp((float)this.random.nextFloat(), (float)0.8f, (float)0.95f);
        this.bCol = Mth.lerp((float)this.random.nextFloat(), (float)0.45f, (float)0.76f) * this.gCol;
        this.alpha = 0.01f;
        this.quadSize = FancyBlockParticles.CONFIG.firefly.getSizeMultiplier() * (FancyBlockParticles.CONFIG.firefly.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.7f, 1.0f) : 1.0f);
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.firefly.getMinLifetime(), FancyBlockParticles.CONFIG.firefly.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.firefly.getMinLifetime(), FancyBlockParticles.CONFIG.firefly.getMaxLifetime()) + 0.5f);
        this.rotateRandom(180.0);
        this.cooldown = (int)Mth.lerp((float)this.random.nextFloat(), (float)20.0f, (float)50.0f);
        this.multiplier = FancyBlockParticles.CONFIG.firefly.isRandomDimmingSpeed() ? FBPConstants.RANDOM.nextFloat(0.87f, 1.0f) : 1.0f;
        this.scale(1.0f);
    }

    public FBPFireflyParticle scale(float scale) {
        super.scale(scale);
        float size = this.quadSize / 40.0f;
        this.setBoundingBox(new AABB(this.x - (double)size, this.y - (double)size, this.z - (double)size, this.x + (double)size, this.y + (double)size, this.z + (double)size));
        return this;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastAngleY = this.angleY;
        this.lastAlpha = this.alpha;
        this.lastSize = this.quadSize;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.firefly.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.firefly.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.age;
                }
                if (this.dimming) {
                    this.alpha *= this.multiplier * 0.95f;
                    if (this.age >= this.lifetime || this.onGround) {
                        if (this.alpha < 0.001f) {
                            this.remove();
                        }
                    } else if (this.alpha < 0.01f) {
                        this.dimming = false;
                        this.cooldown = (int)Mth.lerp((float)this.random.nextFloat(), (float)20.0f, (float)50.0f);
                    }
                } else if (this.alpha < 1.0f) {
                    this.alpha /= this.multiplier * 0.95f;
                    if (this.alpha > 1.0f) {
                        this.alpha = 1.0f;
                    }
                }
                if (this.cooldown <= 0) {
                    if (this.random.nextFloat() > 0.98f || this.age - 100 >= this.lifetime) {
                        this.dimming = true;
                    }
                } else {
                    --this.cooldown;
                }
                if (this.onGround) {
                    this.dimming = true;
                    this.xd *= 0.9;
                    this.zd *= 0.9;
                } else if (this.random.nextFloat() > 0.99f || !this.moved) {
                    this.moved = true;
                    if (this.random.nextFloat() > 0.96f) {
                        this.rotateRandom(125.0);
                        this.xd = FBPConstants.RANDOM.nextDouble(-0.05, 0.05) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.yd = FBPConstants.RANDOM.nextDouble(-0.05, 0.05) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.zd = FBPConstants.RANDOM.nextDouble(-0.05, 0.05) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                    } else {
                        this.rotateRandom(35.0);
                        this.xd = FBPConstants.RANDOM.nextDouble(-0.03, 0.03) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.yd = FBPConstants.RANDOM.nextDouble(-0.03, 0.03) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.zd = FBPConstants.RANDOM.nextDouble(-0.03, 0.03) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                    }
                    Vector3f speed = FBPRenderHelper.rotate(new Vector3f((float)this.xd, (float)this.yd, (float)this.zd), 0.0f, this.angleY, 0.0f);
                    this.xd = speed.x;
                    this.yd = speed.y;
                    this.zd = speed.z;
                }
                this.yd -= 0.015 * (double)this.gravity;
                this.move(this.xd, this.yd, this.zd);
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (x != xo) {
            this.xd = 0.0;
        }
        if (z != zo) {
            this.zd = 0.0;
        }
    }

    private void rotateRandom(double maxDeg) {
        this.angleY = (float)Math.toRadians(FBPConstants.RANDOM.nextDouble(-1.0, 1.0) * maxDeg);
    }

    protected void setLocationFromBoundingbox() {
        super.setLocationFromBoundingbox();
        AABB box = this.getBoundingBox();
        this.y = (box.minY + box.maxY) / 2.0;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TERRAIN;
    }

    public int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return (int)Mth.lerp((float)this.calculateAlpha(partialTick), (float)(i == 0 ? (float)j : (float)i), (float)255.0f);
    }

    public void extract(QuadParticleRenderState renderState, Camera info, float partialTick) {
        float u = this.sprite.getU(0.275f);
        float v = this.sprite.getV(0.275f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize);
        float alpha = this.calculateAlpha(partialTick);
        int light = this.getLightColor(partialTick);
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale / 40.0f, Mth.lerp((float)this.easeInOutCubic(partialTick), (float)this.lastAngleY, (float)this.angleY), u, v, light, this.rCol, this.gCol, this.bCol, alpha);
    }

    private float easeInOutCubic(float value) {
        return value < 0.5f ? 4.0f * (float)Math.pow(value, 3.0) : 1.0f - (float)Math.pow(-2.0 * (double)value + 2.0, 3.0) / 2.0f;
    }

    private float calculateAlpha(float partialTick) {
        return FancyBlockParticles.CONFIG.firefly.getTransparency() * Mth.sqrt((float)(1.0f - Mth.square((float)(Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha) - 1.0f))));
    }

    private void putCube(QuadParticleRenderState renderState, float x, float y, float z, float scale, float angleY, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            Vector3f normal = FBPConstants.CUBE_NORMALS[i].rotateY(angleY, new Vector3f());
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                new Quaternionf().rotateY(angleY).mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.97f;
            renderState.add(this.getLayer(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u, u, v, v, ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    public record Provider() implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd, RandomSource random) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.firefly.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPFireflyParticle(level, x, y, z, xd, yd, zd);
        }
    }
}

