/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPSmokeParticle
extends SmokeParticle
implements IKillableParticle {
    private final Vector3f[] rotatedNormal;
    private final Quaternionf rotation;
    private final float multiplier;
    private double xdo;
    private double zdo;
    private float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean blocked;
    private boolean killToggle;

    public FBPSmokeParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float scale) {
        super(level, x, y, z, xd, yd, zd, scale, new SpriteSet(){

            public TextureAtlasSprite get(int age, int lifetime) {
                return FBPConstants.FBP_PARTICLE_SPRITE.get();
            }

            public TextureAtlasSprite get(RandomSource random) {
                return FBPConstants.FBP_PARTICLE_SPRITE.get();
            }

            public TextureAtlasSprite first() {
                return this.get(0, 0);
            }
        });
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize = scale * 10.0f;
        this.scaleAlpha = this.quadSize * 0.85f;
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.smoke.getMinLifetime(), FancyBlockParticles.CONFIG.smoke.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.smoke.getMinLifetime(), FancyBlockParticles.CONFIG.smoke.getMaxLifetime()) + 0.5f);
        BlockState state = level.getBlockState(BlockPos.containing((double)x, (double)y, (double)z));
        if (state.is(Blocks.FIRE) || state.is(Blocks.SOUL_FIRE)) {
            this.xd = FBPConstants.RANDOM.nextDouble(-0.05, 0.05);
            this.yd = FBPConstants.RANDOM.nextDouble() * 0.175;
            this.zd = FBPConstants.RANDOM.nextDouble(-0.05, 0.05);
            this.quadSize *= 0.65f;
            this.scaleAlpha = this.quadSize * 0.5f;
            this.gravity *= 0.25f;
        } else if (state.getBlock() instanceof TorchBlock || state.getBlock() instanceof CandleBlock) {
            this.xd = FBPConstants.RANDOM.nextDouble(-0.05, 0.05);
            this.zd = FBPConstants.RANDOM.nextDouble(-0.05, 0.05);
            this.xd *= 0.925;
            this.yd = 0.005;
            this.zd *= 0.925;
            this.rCol = 0.275f;
            this.gCol = 0.275f;
            this.bCol = 0.275f;
            this.quadSize *= 0.45f;
            this.scaleAlpha = this.quadSize * 0.75f;
            this.lifetime = (int)(FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.smoke.getMinLifetime(), FancyBlockParticles.CONFIG.smoke.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.smoke.getMinLifetime(), FancyBlockParticles.CONFIG.smoke.getMaxLifetime()) + 0.5f) * 0.75f);
        } else {
            this.yd *= 0.935;
        }
        this.quadSize = FancyBlockParticles.CONFIG.smoke.getSizeMultiplier() * (FancyBlockParticles.CONFIG.smoke.isRandomSize() ? this.quadSize : 1.0f);
        this.alpha = 1.0f;
        this.sprite = FBPConstants.FBP_PARTICLE_SPRITE.get();
        this.rotatedNormal = new Vector3f[FBPConstants.CUBE_NORMALS.length];
        this.rotation = new Quaternionf().rotateY(this.random.nextFloat());
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            this.rotatedNormal[i] = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)this.rotation, new Vector3f());
        }
        this.multiplier = FancyBlockParticles.CONFIG.smoke.isRandomFadingSpeed() ? Mth.clamp((float)FBPConstants.RANDOM.nextFloat(0.55f, 1.15f), (float)0.7f, (float)1.0f) : 0.75f;
        this.scale(1.0f);
    }

    public Particle scale(float scale) {
        super.scale(scale);
        float size = this.quadSize / 20.0f;
        this.setBoundingBox(new AABB(this.x - (double)size, this.y - (double)size, this.z - (double)size, this.x + (double)size, this.y + (double)size, this.z + (double)size));
        return this;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastAlpha = this.alpha;
        this.lastSize = this.quadSize;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.smoke.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.smoke.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.age;
                }
                if (this.age >= this.lifetime) {
                    this.quadSize *= 0.9f * this.multiplier;
                    if ((double)this.alpha >= 0.01 && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= 0.76f * this.multiplier;
                    }
                    if ((double)this.alpha < 0.01) {
                        this.remove();
                    }
                }
                this.yd += 0.004;
                this.move(this.xd, this.yd, this.zd);
                if (this.y == this.yo) {
                    if (!this.blocked) {
                        this.xdo = this.xd;
                        this.zdo = this.zd;
                    }
                    this.blocked = true;
                    if (Math.abs(this.xd) < Math.abs(this.xdo) + 0.035) {
                        this.xd *= 1.1;
                    }
                    if (Math.abs(this.zd) < Math.abs(this.zdo) + 0.035) {
                        this.zd *= 1.1;
                    }
                } else if (this.blocked) {
                    this.blocked = false;
                    this.xd = Mth.lerp((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.xd, (double)this.xdo);
                    this.zd = Mth.lerp((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.zd, (double)this.zdo);
                }
                this.xd *= 0.95;
                this.yd *= 0.95;
                this.zd *= 0.95;
                if (this.onGround) {
                    this.xd *= 0.9;
                    this.zd *= 0.9;
                }
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (x != xo) {
            this.xd = 0.0;
        }
        if (z != zo) {
            this.zd = 0.0;
        }
    }

    protected void setLocationFromBoundingbox() {
        super.setLocationFromBoundingbox();
        AABB box = this.getBoundingBox();
        this.y = (box.minY + box.maxY) / 2.0;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TERRAIN;
    }

    protected int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void extract(QuadParticleRenderState renderState, Camera info, float partialTick) {
        float u = this.sprite.getU(0.275f);
        float v = this.sprite.getV(0.275f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize);
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale / 20.0f, this.rotatedNormal, this.rotation, u, v, light, this.rCol, this.gCol, this.bCol, alpha);
    }

    private void putCube(QuadParticleRenderState renderState, float x, float y, float z, float scale, Vector3f[] rotatedNormal, Quaternionf rotation, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        for (int i = 0; i < rotatedNormal.length; ++i) {
            Vector3f normal = rotatedNormal[i];
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotation.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.875f;
            renderState.add(this.getLayer(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u, u, v, v, ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    public record Provider(float scale) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd, RandomSource random) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.smoke.isSpawnWhileFrozen()) {
                return null;
            }
            FBPSmokeParticle particle = new FBPSmokeParticle(level, x, y, z, xd, yd, zd, this.scale);
            particle.setColor(Mth.clamp((float)(particle.rCol + 0.1f), (float)0.1f, (float)1.0f), Mth.clamp((float)(particle.gCol + 0.1f), (float)0.1f, (float)1.0f), Mth.clamp((float)(particle.bCol + 0.1f), (float)0.1f, (float)1.0f));
            return particle;
        }
    }
}

