/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import lombok.Generated;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.TrailParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPTrailParticle
extends TrailParticle
implements IKillableParticle {
    private final Vector3f rotation;
    private final float multiplier;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean killToggle;

    protected FBPTrailParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, Vec3 target, int color) {
        super(level, x, y, z, xd, yd, zd, target, color, FBPConstants.FBP_PARTICLE_SPRITE.get());
        this.quadSize = FancyBlockParticles.CONFIG.trail.getSizeMultiplier() * (FancyBlockParticles.CONFIG.trail.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.6f, 1.0f) : 1.0f) * 3.0f;
        this.scaleAlpha = this.quadSize * 0.82f;
        this.rotation = new Vector3f((float)Math.toRadians(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0), (float)Math.toRadians(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0), (float)Math.toRadians(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0));
        this.lifetime = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()) + 0.5f);
        this.multiplier = FancyBlockParticles.CONFIG.trail.isRandomFadingSpeed() ? Mth.clamp((float)FBPConstants.RANDOM.nextFloat(0.5f, 0.9f), (float)0.6f, (float)0.8f) : 0.75f;
        this.scale(1.0f);
    }

    public Particle scale(float scale) {
        super.scale(scale);
        float size = this.quadSize / 10.0f;
        this.setBoundingBox(new AABB(this.x - (double)size, this.y - (double)size, this.z - (double)size, this.x + (double)size, this.y + (double)size, this.z + (double)size));
        return this;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastSize = this.quadSize;
        this.lastAlpha = this.alpha;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.trail.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.trail.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.age;
                }
                if (this.age < this.lifetime) {
                    double progress = (double)this.age / (double)this.lifetime;
                    this.x = Mth.lerp((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.x, (double)this.target.x);
                    this.y = Mth.lerp((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.y, (double)this.target.y);
                    this.z = Mth.lerp((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.z, (double)this.target.z);
                }
                if (this.age + 10 >= this.lifetime) {
                    this.quadSize *= 0.9f * this.multiplier;
                    if ((double)this.alpha >= 0.01 && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= 0.7f * this.multiplier;
                    }
                    if ((double)this.alpha < 0.01) {
                        this.remove();
                    }
                }
            }
        }
    }

    private static double easeInOutCubic(double input) {
        return input < 0.5 ? 4.0 * input * input * input : 1.0 - Math.pow(-2.0 * input + 2.0, 3.0) / 2.0;
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TERRAIN;
    }

    public int getLightColor(float partialTick) {
        float factor = Mth.clamp((float)(((float)this.age + partialTick) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        j = Math.min((int)(factor * 15.0f * 16.0f) + j, 240);
        i = j | k << 16;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void extract(QuadParticleRenderState renderState, Camera info, float partialTick) {
        float u = this.sprite.getU(0.275f);
        float v = this.sprite.getV(0.275f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize) / 70.0f;
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale, this.rotation, u, v, light, this.rCol, this.gCol, this.bCol, alpha);
    }

    private void putCube(QuadParticleRenderState renderState, float x, float y, float z, float scale, Vector3f rotationRad, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        Quaternionf rotation = new Quaternionf().rotateXYZ(rotationRad.x, rotationRad.y, rotationRad.z);
        Quaternionf rotationX = new Quaternionf().rotateX(rotationRad.x);
        Quaternionf rotationY = new Quaternionf().rotateY(rotationRad.y);
        Quaternionf rotationZ = new Quaternionf().rotateZ(rotationRad.z);
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            Vector3f normal = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)rotation, new Vector3f());
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotationY.mul((Quaternionfc)faceRotation, faceRotation);
            } else if (i < 4) {
                rotationZ.mul((Quaternionfc)faceRotation, faceRotation);
            } else {
                rotationX.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.95f;
            renderState.add(this.getLayer(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u, u, v, v, ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    public static class Provider
    implements ParticleProvider<TrailParticleOption> {
        @Nullable
        public Particle createParticle(TrailParticleOption type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd, RandomSource random) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.trail.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPTrailParticle(level, x, y, z, xd, yd, zd, type.target(), type.color());
        }

        @Generated
        public Provider() {
        }
    }
}

