/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen.component.widget;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class CenteredStringWidget
extends StringWidget {
    public CenteredStringWidget(int width, int height, Component message, Font font) {
        this(0, 0, width, height, message, font);
    }

    public CenteredStringWidget(int x, int y, int width, int height, Component message, Font font) {
        super(x, y, width, height, message, font);
        this.active = false;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Font font = this.getFont();
        Component message = this.getMessage();
        int maxWidth = this.maxWidth > 0 ? this.maxWidth : this.getWidth();
        int textWidth = font.width((FormattedText)message);
        int x = this.getX() + (maxWidth - textWidth) / 2;
        int y = this.getY() + (this.getHeight() - 9) / 2;
        if (textWidth > maxWidth) {
            switch (this.textOverflow) {
                case CLAMPED: {
                    graphics.drawString(font, this.clipText(message, maxWidth), x, y, this.getColor());
                    break;
                }
                case SCROLLING: {
                    this.renderScrollingString(graphics, font, 2, this.getColor());
                }
            }
        } else {
            graphics.drawString(font, message.getVisualOrderText(), x, y, this.getColor());
        }
    }
}

