/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.screen.FBPOptionsScreen;
import java.net.URI;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class FBPOculusWarningScreen
extends Screen {
    private static final Component OCULUS_COMPONENT = Component.literal((String)"Oculus").withStyle(ChatFormatting.AQUA);
    private final Screen lastScreen;
    private int exitCountdown = 100;
    private Button continueButton;
    private Button dontShowAgainButton;

    public FBPOculusWarningScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"screen.fbp.shaders_warning", (Object[])new Object[]{OCULUS_COMPONENT}));
        this.lastScreen = lastScreen;
    }

    protected void init() {
        HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 52, 84);
        ((ImageButton)layout.addToHeader((LayoutElement)new ImageButton(25, 25, FBPOptionsScreen.LOGO_SPRITES, button -> this.handleComponentClicked(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://www.curseforge.com/minecraft/mc-mods/fbp-renewed")))), CommonComponents.EMPTY), settings -> settings.alignHorizontallyLeft().alignVerticallyTop().padding(10))).setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.fbp.common.homepage")));
        ((ImageButton)layout.addToHeader((LayoutElement)new ImageButton(25, 25, FBPOptionsScreen.REPORT_SPRITES, button -> this.handleComponentClicked(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://github.com/Hantonik/FancyBlockParticles/issues")))), CommonComponents.EMPTY), settings -> settings.alignHorizontallyRight().alignVerticallyTop().padding(10))).setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.fbp.common.report")));
        layout.addToHeader((LayoutElement)new StringWidget(this.title, this.font), settings -> settings.alignHorizontallyCenter().alignVerticallyBottom());
        GridLayout contents = new GridLayout();
        contents.defaultCellSetting().alignHorizontallyCenter().paddingTop(5);
        GridLayout.RowHelper contentsHelper = contents.createRowHelper(1);
        contentsHelper.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.translatable((String)"gui.fbp.shaders_warning.message", (Object[])new Object[]{OCULUS_COMPONENT}), this.font).setMaxWidth(this.width - 45).setCentered(true), LayoutSettings.defaults().paddingTop(7));
        contentsHelper.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.translatable((String)"gui.fbp.shaders_warning.report", (Object[])new Object[]{OCULUS_COMPONENT}), this.font).setMaxWidth(this.width - 45).setCentered(true));
        layout.addToContents((LayoutElement)contents);
        this.continueButton = Button.builder((Component)CommonComponents.GUI_CONTINUE, button -> this.onClose()).build();
        this.continueButton.active = false;
        this.dontShowAgainButton = Button.builder((Component)Component.translatable((String)"button.fbp.shaders_warning.dont_show_again"), button -> {
            FancyBlockParticles.CONFIG.global.setDisableOculusWarning(true);
            FancyBlockParticles.CONFIG.save();
            this.onClose();
        }).build();
        this.dontShowAgainButton.active = false;
        GridLayout footer = new GridLayout();
        footer.defaultCellSetting().paddingHorizontal(5);
        GridLayout.RowHelper footerHelper = footer.createRowHelper(2);
        footerHelper.addChild((LayoutElement)this.continueButton);
        footerHelper.addChild((LayoutElement)this.dontShowAgainButton);
        layout.addToFooter((LayoutElement)footer);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        layout.arrangeElements();
    }

    public void tick() {
        if (this.exitCountdown <= 0) {
            this.continueButton.active = true;
            this.dontShowAgainButton.active = true;
        } else {
            --this.exitCountdown;
        }
    }

    public boolean shouldCloseOnEsc() {
        return this.exitCountdown <= 0;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 257 || keyCode == 32) && modifiers == 0 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (!this.continueButton.active && mouseX > this.continueButton.getX() && mouseX < this.continueButton.getX() + this.continueButton.getWidth() && mouseY > this.continueButton.getY() && mouseY < this.continueButton.getY() + this.continueButton.getHeight()) {
            graphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"tooltip.fbp.shaders_warning.wait", (Object[])new Object[]{String.valueOf(this.exitCountdown / 20 + 1)}), mouseX, mouseY);
        }
        if (!this.dontShowAgainButton.active && mouseX > this.dontShowAgainButton.getX() && mouseX < this.dontShowAgainButton.getX() + this.dontShowAgainButton.getWidth() && mouseY > this.dontShowAgainButton.getY() && mouseY < this.dontShowAgainButton.getY() + this.dontShowAgainButton.getHeight()) {
            graphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"tooltip.fbp.shaders_warning.wait", (Object[])new Object[]{String.valueOf(this.exitCountdown / 20 + 1)}), mouseX, mouseY);
        }
    }
}

