/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import lombok.Generated;
import net.minecraft.class_10335;
import net.minecraft.class_10339;
import net.minecraft.class_11944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPTrailParticle
extends class_10335
implements IKillableParticle {
    private final Vector3f rotation;
    private final float multiplier;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private boolean killToggle;

    protected FBPTrailParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd, class_243 target, int color) {
        super(level, x, y, z, xd, yd, zd, target, color, FBPConstants.FBP_PARTICLE_SPRITE.get());
        this.field_17867 = FancyBlockParticles.CONFIG.trail.getSizeMultiplier() * (FancyBlockParticles.CONFIG.trail.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.6f, 1.0f) : 1.0f) * 3.0f;
        this.scaleAlpha = this.field_17867 * 0.82f;
        this.rotation = new Vector3f((float)Math.toRadians(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0), (float)Math.toRadians(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0), (float)Math.toRadians(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0));
        this.field_3847 = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.trail.getMinLifetime(), FancyBlockParticles.CONFIG.trail.getMaxLifetime()) + 0.5f);
        this.multiplier = FancyBlockParticles.CONFIG.trail.isRandomFadingSpeed() ? class_3532.method_15363((float)FBPConstants.RANDOM.nextFloat(0.5f, 0.9f), (float)0.6f, (float)0.8f) : 0.75f;
        this.method_3087(1.0f);
    }

    public class_703 method_3087(float scale) {
        super.method_3087(scale);
        float size = this.field_17867 / 10.0f;
        this.method_3067(new class_238(this.field_3874 - (double)size, this.field_3854 - (double)size, this.field_3871 - (double)size, this.field_3874 + (double)size, this.field_3854 + (double)size, this.field_3871 + (double)size));
        return this;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.lastSize = this.field_17867;
        this.lastAlpha = this.field_62636;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.trail.isEnabled()) {
            this.method_3085();
        }
        if (!class_310.method_1551().method_1493()) {
            if (this.killToggle) {
                this.method_3085();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.trail.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.field_3866;
                }
                if (this.field_3866 < this.field_3847) {
                    double progress = (double)this.field_3866 / (double)this.field_3847;
                    this.field_3874 = class_3532.method_16436((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.field_3874, (double)this.field_54855.field_1352);
                    this.field_3854 = class_3532.method_16436((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.field_3854, (double)this.field_54855.field_1351);
                    this.field_3871 = class_3532.method_16436((double)FBPTrailParticle.easeInOutCubic(progress), (double)this.field_3871, (double)this.field_54855.field_1350);
                }
                if (this.field_3866 + 10 >= this.field_3847) {
                    this.field_17867 *= 0.9f * this.multiplier;
                    if ((double)this.field_62636 >= 0.01 && this.field_17867 <= this.scaleAlpha) {
                        this.field_62636 *= 0.7f * this.multiplier;
                    }
                    if ((double)this.field_62636 < 0.01) {
                        this.method_3085();
                    }
                }
            }
        }
    }

    private static double easeInOutCubic(double input) {
        return input < 0.5 ? 4.0 * input * input * input : 1.0 - Math.pow(-2.0 * input + 2.0, 3.0) / 2.0;
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62639;
    }

    public int method_3068(float partialTick) {
        float factor = class_3532.method_15363((float)(((float)this.field_3866 + partialTick) / (float)this.field_3847), (float)0.0f, (float)1.0f);
        int i = super.method_3068(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        j = Math.min((int)(factor * 15.0f * 16.0f) + j, 240);
        i = j | k << 16;
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (this.field_3851.method_8477(pos)) {
            j = this.field_3851.method_22336().method_22363(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void method_3074(class_11944 renderState, class_4184 info, float partialTick) {
        float u = this.field_62632.method_4580(0.275f);
        float v = this.field_62632.method_4570(0.275f);
        double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874) - info.method_19326().field_1352;
        double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854) - info.method_19326().field_1351;
        double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871) - info.method_19326().field_1350;
        float scale = class_3532.method_16439((float)partialTick, (float)this.lastSize, (float)this.field_17867) / 70.0f;
        float alpha = class_3532.method_16439((float)partialTick, (float)this.lastAlpha, (float)this.field_62636);
        int light = this.method_3068(partialTick);
        class_310.method_1551().field_1773.method_22974().method_3316();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale, this.rotation, u, v, light, this.field_62633, this.field_62634, this.field_62635, alpha);
    }

    private void putCube(class_11944 renderState, float x, float y, float z, float scale, Vector3f rotationRad, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        Quaternionf rotation = new Quaternionf().rotateXYZ(rotationRad.x, rotationRad.y, rotationRad.z);
        Quaternionf rotationX = new Quaternionf().rotateX(rotationRad.x);
        Quaternionf rotationY = new Quaternionf().rotateY(rotationRad.y);
        Quaternionf rotationZ = new Quaternionf().rotateZ(rotationRad.z);
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            Vector3f normal = FBPConstants.CUBE_NORMALS[i].rotate((Quaternionfc)rotation, new Vector3f());
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                rotationY.mul((Quaternionfc)faceRotation, faceRotation);
            } else if (i < 4) {
                rotationZ.mul((Quaternionfc)faceRotation, faceRotation);
            } else {
                rotationX.mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.95f;
            renderState.method_74323(this.method_74255(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u, u, v, v, class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    public static class Provider
    implements class_707<class_10339> {
        @Nullable
        public class_703 createParticle(class_10339 type, class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.trail.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPTrailParticle(level, x, y, z, xd, yd, zd, type.comp_3292(), type.comp_3293());
        }

        @Generated
        public Provider() {
        }
    }
}

