/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.class_10748;
import net.minecraft.class_11944;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPFireflyParticle
extends class_10748
implements IKillableParticle {
    private float angleY;
    private float lastAngleY;
    private float lastAlpha;
    private float lastSize;
    private boolean moved;
    private boolean dimming;
    private int cooldown;
    private final float multiplier;
    private boolean killToggle;

    public FBPFireflyParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd, FBPConstants.FBP_PARTICLE_SPRITE.get());
        this.field_3869 = 8.5E-4;
        this.field_3844 = 0.001f;
        this.field_28786 = 0.985f;
        this.field_62633 = 1.0f;
        this.field_62634 = class_3532.method_16439((float)this.field_3840.method_43057(), (float)0.8f, (float)0.95f);
        this.field_62635 = class_3532.method_16439((float)this.field_3840.method_43057(), (float)0.45f, (float)0.76f) * this.field_62634;
        this.field_62636 = 0.01f;
        this.field_17867 = FancyBlockParticles.CONFIG.firefly.getSizeMultiplier() * (FancyBlockParticles.CONFIG.firefly.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.7f, 1.0f) : 1.0f);
        this.field_3847 = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.firefly.getMinLifetime(), FancyBlockParticles.CONFIG.firefly.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.firefly.getMinLifetime(), FancyBlockParticles.CONFIG.firefly.getMaxLifetime()) + 0.5f);
        this.rotateRandom(180.0);
        this.cooldown = (int)class_3532.method_16439((float)this.field_3840.method_43057(), (float)20.0f, (float)50.0f);
        this.multiplier = FancyBlockParticles.CONFIG.firefly.isRandomDimmingSpeed() ? FBPConstants.RANDOM.nextFloat(0.87f, 1.0f) : 1.0f;
        this.scale(1.0f);
    }

    public FBPFireflyParticle scale(float scale) {
        super.method_3087(scale);
        float size = this.field_17867 / 40.0f;
        this.method_3067(new class_238(this.field_3874 - (double)size, this.field_3854 - (double)size, this.field_3871 - (double)size, this.field_3874 + (double)size, this.field_3854 + (double)size, this.field_3871 + (double)size));
        return this;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.lastAngleY = this.angleY;
        this.lastAlpha = this.field_62636;
        this.lastSize = this.field_17867;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.firefly.isEnabled()) {
            this.method_3085();
        }
        if (!class_310.method_1551().method_1493()) {
            if (this.killToggle) {
                this.method_3085();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.firefly.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.field_3866;
                }
                if (this.dimming) {
                    this.field_62636 *= this.multiplier * 0.95f;
                    if (this.field_3866 >= this.field_3847 || this.field_3845) {
                        if (this.field_62636 < 0.001f) {
                            this.method_3085();
                        }
                    } else if (this.field_62636 < 0.01f) {
                        this.dimming = false;
                        this.cooldown = (int)class_3532.method_16439((float)this.field_3840.method_43057(), (float)20.0f, (float)50.0f);
                    }
                } else if (this.field_62636 < 1.0f) {
                    this.field_62636 /= this.multiplier * 0.95f;
                    if (this.field_62636 > 1.0f) {
                        this.field_62636 = 1.0f;
                    }
                }
                if (this.cooldown <= 0) {
                    if (this.field_3840.method_43057() > 0.98f || this.field_3866 - 100 >= this.field_3847) {
                        this.dimming = true;
                    }
                } else {
                    --this.cooldown;
                }
                if (this.field_3845) {
                    this.dimming = true;
                    this.field_3852 *= 0.9;
                    this.field_3850 *= 0.9;
                } else if (this.field_3840.method_43057() > 0.99f || !this.moved) {
                    this.moved = true;
                    if (this.field_3840.method_43057() > 0.96f) {
                        this.rotateRandom(125.0);
                        this.field_3852 = FBPConstants.RANDOM.nextDouble(-0.05, 0.05) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.field_3869 = FBPConstants.RANDOM.nextDouble(-0.05, 0.05) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.field_3850 = FBPConstants.RANDOM.nextDouble(-0.05, 0.05) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                    } else {
                        this.rotateRandom(35.0);
                        this.field_3852 = FBPConstants.RANDOM.nextDouble(-0.03, 0.03) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.field_3869 = FBPConstants.RANDOM.nextDouble(-0.03, 0.03) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                        this.field_3850 = FBPConstants.RANDOM.nextDouble(-0.03, 0.03) * (double)FancyBlockParticles.CONFIG.firefly.getSpeedMultiplier();
                    }
                    Vector3f speed = FBPRenderHelper.rotate(new Vector3f((float)this.field_3852, (float)this.field_3869, (float)this.field_3850), 0.0f, this.angleY, 0.0f);
                    this.field_3852 = speed.x;
                    this.field_3869 = speed.y;
                    this.field_3850 = speed.z;
                }
                this.field_3869 -= 0.015 * (double)this.field_3844;
                this.method_3069(this.field_3852, this.field_3869, this.field_3850);
                this.field_3852 *= (double)this.field_28786;
                this.field_3869 *= (double)this.field_28786;
                this.field_3850 *= (double)this.field_28786;
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void method_3069(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < class_3532.method_33723((double)100.0)) {
            class_243 vec = class_1297.method_20736(null, (class_243)new class_243(x, y, z), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
            x = vec.field_1352;
            y = vec.field_1351;
            z = vec.field_1350;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.method_3067(this.method_3064().method_989(x, y, z));
            this.method_3072();
        }
        boolean bl = this.field_3845 = y != yo && yo < 0.0;
        if (x != xo) {
            this.field_3852 = 0.0;
        }
        if (z != zo) {
            this.field_3850 = 0.0;
        }
    }

    private void rotateRandom(double maxDeg) {
        this.angleY = (float)Math.toRadians(FBPConstants.RANDOM.nextDouble(-1.0, 1.0) * maxDeg);
    }

    protected void method_3072() {
        super.method_3072();
        class_238 box = this.method_3064();
        this.field_3854 = (box.field_1322 + box.field_1325) / 2.0;
    }

    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62639;
    }

    public int method_3068(float partialTick) {
        int i = super.method_3068(partialTick);
        int j = 0;
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (this.field_3851.method_8477(pos)) {
            j = this.field_3851.method_22336().method_22363(pos, 0);
        }
        return (int)class_3532.method_16439((float)this.calculateAlpha(partialTick), (float)(i == 0 ? (float)j : (float)i), (float)255.0f);
    }

    public void method_3074(class_11944 renderState, class_4184 info, float partialTick) {
        float u = this.field_62632.method_4580(0.275f);
        float v = this.field_62632.method_4570(0.275f);
        double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874) - info.method_19326().field_1352;
        double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854) - info.method_19326().field_1351;
        double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871) - info.method_19326().field_1350;
        float scale = class_3532.method_16439((float)partialTick, (float)this.lastSize, (float)this.field_17867);
        float alpha = this.calculateAlpha(partialTick);
        int light = this.method_3068(partialTick);
        class_310.method_1551().field_1773.method_22974().method_3316();
        this.putCube(renderState, (float)posX, (float)posY, (float)posZ, scale / 40.0f, class_3532.method_16439((float)this.easeInOutCubic(partialTick), (float)this.lastAngleY, (float)this.angleY), u, v, light, this.field_62633, this.field_62634, this.field_62635, alpha);
    }

    private float easeInOutCubic(float value) {
        return value < 0.5f ? 4.0f * (float)Math.pow(value, 3.0) : 1.0f - (float)Math.pow(-2.0 * (double)value + 2.0, 3.0) / 2.0f;
    }

    private float calculateAlpha(float partialTick) {
        return FancyBlockParticles.CONFIG.firefly.getTransparency() * class_3532.method_15355((float)(1.0f - class_3532.method_27285((float)(class_3532.method_16439((float)partialTick, (float)this.lastAlpha, (float)this.field_62636) - 1.0f))));
    }

    private void putCube(class_11944 renderState, float x, float y, float z, float scale, float angleY, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        float brightness = 1.0f;
        for (int i = 0; i < FBPConstants.CUBE_NORMALS.length; ++i) {
            Vector3f normal = FBPConstants.CUBE_NORMALS[i].rotateY(angleY, new Vector3f());
            Vector3f face = new Vector3f((Vector3fc)normal).mul(scale).add(x, y, z);
            Quaternionf faceRotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)normal);
            if (i < 2) {
                new Quaternionf().rotateY(angleY).mul((Quaternionfc)faceRotation, faceRotation);
            }
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.97f;
            renderState.method_74323(this.method_74255(), face.x, face.y, face.z, faceRotation.x, faceRotation.y, faceRotation.z, faceRotation.w, scale, u, u, v, v, class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue), light);
        }
    }

    public record Provider() implements class_707<class_2400>
    {
        @Nullable
        public class_703 createParticle(class_2400 type, class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.firefly.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPFireflyParticle(level, x, y, z, xd, yd, zd);
        }
    }
}

