/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.animation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPPlacingAnimationParticle;
import hantonik.fbp.platform.Services;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public final class FBPPlacingAnimationManager {
    private static final Map<BlockPos, FBPPlacingAnimationParticle> ACTIVE_ANIMATIONS = Maps.newHashMap();
    private static final Set<BlockPos> HIDDEN_BLOCKS = Sets.newCopyOnWriteArraySet();

    public static void addAnimation(ClientLevel level, BlockState state, BlockPos pos, LivingEntity placer, InteractionHand hand) {
        if (Services.PLATFORM.isModLoaded("a_good_place")) {
            return;
        }
        if (!(!FancyBlockParticles.CONFIG.animations.isEnabled() || !FancyBlockParticles.CONFIG.isBlockAnimationsEnabled(state.getBlock()) || state.is(BlockTags.BEDS) || state.getBlock() instanceof DoublePlantBlock || state.getBlock() instanceof DoorBlock || state.hasProperty((Property)ChestBlock.TYPE) && state.getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE || !(Minecraft.getInstance().cameraEntity.position().distanceTo(pos.getCenter()) <= (double)((Integer)Minecraft.getInstance().options.renderDistance().get() * 16)))) {
            FBPPlacingAnimationParticle animation = new FBPPlacingAnimationParticle(level, state, pos, placer, hand);
            FBPPlacingAnimationParticle oldAnimation = ACTIVE_ANIMATIONS.get(pos);
            if (oldAnimation != null) {
                if (oldAnimation.canUpdate(animation)) {
                    animation.setAge(oldAnimation.getAge()).setLifetime(oldAnimation.getLifetime());
                }
                oldAnimation.remove();
            }
            ACTIVE_ANIMATIONS.put(pos, animation);
            FBPPlacingAnimationManager.hideBlock(pos);
            Minecraft.getInstance().particleEngine.add((Particle)animation);
        }
    }

    public static void hideBlock(BlockPos pos) {
        HIDDEN_BLOCKS.add(pos);
    }

    public static void showBlock(BlockPos pos, boolean removeAnimation) {
        FBPPlacingAnimationParticle animation;
        if (HIDDEN_BLOCKS.remove(pos)) {
            FBPPlacingAnimationManager.markBlockForRender(pos);
        }
        if (removeAnimation && (animation = ACTIVE_ANIMATIONS.remove(pos)) != null) {
            animation.remove();
        }
    }

    public static boolean isHidden(BlockPos pos) {
        return pos != null && HIDDEN_BLOCKS.contains(pos);
    }

    private static void markBlockForRender(BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockState state = level.getBlockState(pos);
        level.sendBlockUpdated(pos, state, state, 2);
    }

    public static void clear() {
        for (BlockPos pos : HIDDEN_BLOCKS) {
            FBPPlacingAnimationManager.showBlock(pos, true);
        }
        HIDDEN_BLOCKS.clear();
        ACTIVE_ANIMATIONS.clear();
    }

    @Generated
    private FBPPlacingAnimationManager() {
    }
}

