/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPRainParticle;
import hantonik.fbp.particle.FBPSnowParticle;
import hantonik.fbp.util.FBPConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.WeatherEffectRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WeatherEffectRenderer.class})
public abstract class MixinWeatherEffectRenderer {
    @Inject(at={@At(value="HEAD")}, method={"tickRainParticles"})
    private void tickRain(ClientLevel level, Camera camera, int ticks, ParticleStatus status, CallbackInfo callback) {
        if (FancyBlockParticles.CONFIG.global.isEnabled() && !FancyBlockParticles.CONFIG.global.isFreezeEffect() && (FancyBlockParticles.CONFIG.rain.isEnabled() || FancyBlockParticles.CONFIG.snow.isEnabled())) {
            float f = level.getRainLevel(1.0f);
            float f2 = Minecraft.useFancyGraphics() ? 1.0f : 2.0f;
            if (f / f2 <= 0.0f) {
                return;
            }
            float rainDensity = FancyBlockParticles.CONFIG.rain.getParticleDensity() * 4.0f * (float)FancyBlockParticles.CONFIG.rain.getSimulationDistance() / 2.0f;
            float snowDensity = FancyBlockParticles.CONFIG.snow.getParticleDensity() * 4.0f * (float)FancyBlockParticles.CONFIG.snow.getSimulationDistance() / 2.0f;
            float density = Math.max(rainDensity, snowDensity);
            int i = 0;
            while ((float)i < density) {
                double angle = FBPConstants.RANDOM.nextDouble() * Math.PI * 2.0;
                float radius = Mth.sqrt((float)FBPConstants.RANDOM.nextFloat()) * (float)Math.max(FancyBlockParticles.CONFIG.rain.getSimulationDistance(), FancyBlockParticles.CONFIG.snow.getSimulationDistance()) / 2.0f * 16.0f;
                double x = (double)camera.getBlockPosition().getX() + (double)radius * Math.cos(angle);
                int y = camera.getBlockPosition().getY();
                double z = (double)camera.getBlockPosition().getZ() + (double)radius * Math.sin(angle);
                BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                int surfaceHeight = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY();
                Biome.Precipitation precipitation = ((Biome)level.getBiome(pos).value()).getPrecipitationAt(pos, level.getSeaLevel());
                if (!(camera.getPosition().distanceTo(new Vec3(x, (double)y, z)) > (double)((float)(precipitation == Biome.Precipitation.RAIN ? FancyBlockParticles.CONFIG.rain.getSimulationDistance() : FancyBlockParticles.CONFIG.snow.getSimulationDistance()) * 16.0f))) {
                    if ((y = (int)((double)y + 25.0 + FBPConstants.RANDOM.nextDouble() * 10.0)) <= surfaceHeight + 2) {
                        y = surfaceHeight + 10;
                    }
                    if (precipitation == Biome.Precipitation.RAIN) {
                        if (FancyBlockParticles.CONFIG.rain.isEnabled() && (float)i < rainDensity) {
                            Minecraft.getInstance().particleEngine.add(new FBPRainParticle.Provider().createParticle(ParticleTypes.RAIN.getType(), level, x, (double)y, z, 0.0, 0.0, 0.0));
                        }
                    } else if (precipitation == Biome.Precipitation.SNOW && FancyBlockParticles.CONFIG.snow.isEnabled() && (float)i < snowDensity) {
                        Minecraft.getInstance().particleEngine.add(new FBPSnowParticle.Provider().createParticle(ParticleTypes.RAIN.getType(), level, x, (double)y, z, 0.0, 0.0, 0.0));
                    }
                }
                ++i;
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), method={"tickRainParticles"})
    private void addParticle(ClientLevel instance, ParticleOptions particleOptions, double x, double y, double z, double xd, double yd, double zd) {
        if (FancyBlockParticles.CONFIG.global.isEnabled()) {
            if (particleOptions.getType() == ParticleTypes.SMOKE && FancyBlockParticles.CONFIG.smoke.isEnabled()) {
                return;
            }
            if (particleOptions.getType() == ParticleTypes.RAIN && FancyBlockParticles.CONFIG.rain.isEnabled()) {
                return;
            }
        }
        instance.addParticle(particleOptions, x, y, z, xd, yd, zd);
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WeatherEffectRenderer;getPrecipitationAt(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;")}, method={"collectColumnInstances"})
    private Biome.Precipitation getPrecipitationAt(WeatherEffectRenderer instance, Level level, BlockPos pos, Operation<Biome.Precipitation> original) {
        if (FancyBlockParticles.CONFIG.global.isEnabled()) {
            if (original.call(new Object[]{instance, level, pos}) == Biome.Precipitation.RAIN && FancyBlockParticles.CONFIG.rain.isEnabled()) {
                return Biome.Precipitation.NONE;
            }
            if (original.call(new Object[]{instance, level, pos}) == Biome.Precipitation.SNOW && FancyBlockParticles.CONFIG.snow.isEnabled()) {
                return Biome.Precipitation.NONE;
            }
        }
        return (Biome.Precipitation)original.call(new Object[]{instance, level, pos});
    }
}

