/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen.component.widget.button;

import hantonik.fbp.util.BlacklistMode;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FBPBlacklistButton
extends Button {
    private static final WidgetSprites OPTION_SPRITE = new WidgetSprites(ResourceLocation.tryBuild((String)"fbp", (String)"blacklist/placing_animation_button"), ResourceLocation.tryBuild((String)"fbp", (String)"blacklist/breaking_particles_button"));
    private final boolean particle;
    private final BlacklistMode blacklistMode;

    public FBPBlacklistButton(int x, int y, boolean particle, BlacklistMode blacklistMode, Button.OnPress onPress) {
        super(x, y, 60, 60, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.particle = particle;
        this.blacklistMode = blacklistMode;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.blitSprite(RenderType::guiTextured, ResourceLocation.tryBuild((String)"fbp", (String)("blacklist/button_background_" + this.blacklistMode.name().toLowerCase(Locale.ENGLISH))), this.getX(), this.getY(), 60, 60);
        graphics.blitSprite(RenderType::guiTextured, OPTION_SPRITE.get(true, this.particle), (int)((float)this.getX() + (float)this.width / 2.0f - 22.5f + (this.particle ? 0.0f : 2.0f)), (int)((float)this.getY() + (float)this.height / 2.0f - 22.5f), 45, 45);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int radius;
        int centerY;
        int centerX = this.getX() + this.height / 2;
        double distance = Math.sqrt((mouseX - (double)centerX) * (mouseX - (double)centerX) + (mouseY - (double)(centerY = this.getY() + this.height / 2 - 1)) * (mouseY - (double)centerY));
        return distance <= (double)(radius = (this.height - 1) / 2);
    }

    @Generated
    public BlacklistMode getBlacklistMode() {
        return this.blacklistMode;
    }
}

