/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.platform.Services;
import hantonik.fbp.util.FBPConstants;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2f;
import org.joml.Vector3d;

public final class FBPRenderHelper {
    public static void renderCubeShaded(VertexConsumer buffer, Vector2f[] uv, double xPos, double yPos, double zPos, double scale, Vector3d rotation, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.setShader((CompiledShaderProgram)Services.CLIENT.getBlockTranslucentShader());
        if (FancyBlockParticles.CONFIG.global.isCullParticles()) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        float radX = (float)Math.toRadians(rotation.x);
        float radY = (float)Math.toRadians(rotation.y);
        float radZ = (float)Math.toRadians(rotation.z);
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3d v1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d v4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], radX, radY, radZ).mul(scale).add(xPos, yPos, zPos);
            Vector3d normal = FBPRenderHelper.rotate(FBPConstants.CUBE_NORMALS[i / 4], radX, radY, radZ);
            float shade = Services.CLIENT.getShade((float)normal.x, (float)normal.y, (float)normal.z, true);
            if (cartoon) {
                FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v2, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v3, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v4, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                continue;
            }
            FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v2, uv[1].x, uv[1].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v3, uv[2].x, uv[2].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v4, uv[3].x, uv[3].y, light, red * shade, green * shade, blue * shade, alpha, normal);
        }
    }

    public static void renderCubeShaded(VertexConsumer buffer, Vector2f[] uv, double xPos, double yPos, double zPos, double width, double height, Vector3d rotation, int light, float red, float green, float blue, float alpha, boolean cartoon) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.setShader((CompiledShaderProgram)Services.CLIENT.getBlockTranslucentShader());
        if (FancyBlockParticles.CONFIG.global.isCullParticles()) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        float radX = (float)Math.toRadians(rotation.x);
        float radY = (float)Math.toRadians(rotation.y);
        float radZ = (float)Math.toRadians(rotation.z);
        for (int i = 0; i < FBPConstants.CUBE.length; i += 4) {
            Vector3d v1 = FBPRenderHelper.rotate(FBPConstants.CUBE[i], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d v2 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 1], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d v3 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 2], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d v4 = FBPRenderHelper.rotate(FBPConstants.CUBE[i + 3], radX, radY, radZ).mul(width, height, width).add(xPos, yPos, zPos);
            Vector3d normal = FBPRenderHelper.rotate(FBPConstants.CUBE_NORMALS[i / 4], radX, radY, radZ);
            float shade = Services.CLIENT.getShade((float)normal.x, (float)normal.y, (float)normal.z, true);
            if (cartoon) {
                FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v2, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v3, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                FBPRenderHelper.addVertex(buffer, v4, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
                continue;
            }
            FBPRenderHelper.addVertex(buffer, v1, uv[0].x, uv[0].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v2, uv[1].x, uv[1].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v3, uv[2].x, uv[2].y, light, red * shade, green * shade, blue * shade, alpha, normal);
            FBPRenderHelper.addVertex(buffer, v4, uv[3].x, uv[3].y, light, red * shade, green * shade, blue * shade, alpha, normal);
        }
    }

    public static void addVertex(VertexConsumer buffer, Vector3d pos, float u, float v, int light, float red, float green, float blue, float alpha, Vector3d normal) {
        buffer.addVertex((float)pos.x, (float)pos.y, (float)pos.z).setColor(red, green, blue, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal((float)normal.x, (float)normal.y, (float)normal.z);
    }

    public static Vector3d rotate(Vector3d vector, float angleX, float angleY, float angleZ) {
        Vector3d sin = new Vector3d((double)Mth.sin((float)angleX), (double)Mth.sin((float)angleY), (double)Mth.sin((float)angleZ));
        Vector3d cos = new Vector3d((double)Mth.cos((float)angleX), (double)Mth.cos((float)angleY), (double)Mth.cos((float)angleZ));
        vector = new Vector3d(vector.x, vector.y * cos.x - vector.z * sin.x, vector.y * sin.x + vector.z * cos.x);
        vector = new Vector3d(vector.x * cos.z - vector.y * sin.z, vector.x * sin.z + vector.y * cos.z, vector.z);
        vector = new Vector3d(vector.x * cos.y + vector.z * sin.y, vector.y, vector.x * sin.y - vector.z * cos.y);
        return vector;
    }

    @Generated
    private FBPRenderHelper() {
    }
}

