/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp;

import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.init.FBPKeyMappings;
import hantonik.fbp.screen.FBPOptionsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.ConfigScreenHandler;
import net.neoforged.neoforge.client.event.ClientPauseUpdatedEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

@Mod(value="fbp")
public final class FBPNeoForge {
    public FBPNeoForge(IEventBus bus) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            FancyBlockParticles.LOGGER.info(FancyBlockParticles.SETUP_MARKER, "Initializing...");
            bus.register((Object)this);
            bus.addListener(this::onRegisterKeyMappings);
            bus.addListener(this::onRegisterClientReloadListeners);
            ModList.get().getModContainerById("fbp").ifPresent(mc -> mc.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, modsScreen) -> new FBPOptionsScreen((Screen)modsScreen))));
        }
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        FancyBlockParticles.LOGGER.info(FancyBlockParticles.SETUP_MARKER, "Starting client setup...");
        NeoForge.EVENT_BUS.addListener(this::onClientTick);
        NeoForge.EVENT_BUS.addListener(this::postRenderGuiOverlay);
        NeoForge.EVENT_BUS.addListener(this::onClientPauseUpdated);
        NeoForge.EVENT_BUS.addListener(this::postScreenInit);
        NeoForge.EVENT_BUS.addListener(this::onClientLoggingIn);
        FancyBlockParticles.LOGGER.info(FancyBlockParticles.SETUP_MARKER, "Finished client setup!");
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        FBPKeyMappings.MAPPINGS.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> FancyBlockParticles.CONFIG.load()));
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FancyBlockParticles.postClientTick(Minecraft.getInstance());
        }
    }

    private void postRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        FancyBlockParticles.onRenderHud(event.getGuiGraphics());
    }

    private void onClientPauseUpdated(ClientPauseUpdatedEvent event) {
        if (event.isPaused()) {
            FancyBlockParticles.onClientPause(Minecraft.getInstance().screen);
        }
    }

    private void postScreenInit(ScreenEvent.Init.Post event) {
        FancyBlockParticles.postScreenInit(event.getScreen());
    }

    private void onClientLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        FancyBlockParticles.onLevelLoad();
    }
}

