/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CampfireSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class FBPCampfireSmokeParticle
extends CampfireSmokeParticle
implements IKillableParticle {
    private final Vector3d[] rotatedCube;
    private final float uo;
    private final float vo;
    private final float multiplier;
    private double xdo;
    private double zdo;
    private final float targetAlpha;
    private final float scaleAlpha;
    private float lastAlpha;
    private final float targetSize;
    private float lastSize;
    private boolean blocked;
    private boolean killToggle;

    protected FBPCampfireSmokeParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, boolean isSignal, TextureAtlasSprite sprite) {
        super(level, x, y, z, xd, yd, zd, isSignal);
        this.sprite = sprite;
        this.rCol = 0.62f;
        this.gCol = 0.59f;
        this.bCol = 0.56f;
        this.targetAlpha = FancyBlockParticles.CONFIG.campfireSmoke.getTransparency();
        this.alpha = 0.0f;
        this.targetSize = FancyBlockParticles.CONFIG.campfireSmoke.getSizeMultiplier() * 6.0f * (FancyBlockParticles.CONFIG.campfireSmoke.isRandomSize() ? this.quadSize : 1.0f);
        this.scaleAlpha = this.targetSize * 0.85f;
        this.quadSize = 0.0f;
        this.hasPhysics = true;
        this.rotatedCube = new Vector3d[FBPConstants.CUBE.length];
        float angleY = this.random.nextFloat();
        for (int i = 0; i < FBPConstants.CUBE.length; ++i) {
            this.rotatedCube[i] = FBPRenderHelper.rotate(FBPConstants.CUBE[i], 0.0f, angleY, 0.0f);
        }
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.multiplier = FancyBlockParticles.CONFIG.campfireSmoke.isRandomFadingSpeed() ? Mth.clamp((float)FBPConstants.RANDOM.nextFloat(0.85f, 1.1f), (float)0.95f, (float)1.0f) : 0.95f;
        this.scale(1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.lastAlpha = this.alpha;
        this.lastSize = this.quadSize;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.campfireSmoke.isEnabled()) {
            this.remove();
        }
        if (!Minecraft.getInstance().isPaused()) {
            if (this.killToggle) {
                this.remove();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                ++this.age;
                if (this.age >= this.lifetime) {
                    this.quadSize *= 0.98f * this.multiplier;
                    if ((double)this.alpha >= 0.001 && this.quadSize <= this.scaleAlpha) {
                        this.alpha *= 0.96f * this.multiplier;
                    }
                    if ((double)this.alpha < 0.001) {
                        this.remove();
                    }
                } else {
                    if (this.quadSize < this.targetSize) {
                        this.quadSize += 0.17f * this.multiplier;
                        if (this.quadSize > this.targetSize) {
                            this.quadSize = this.targetSize;
                        }
                    }
                    if (this.alpha < this.targetAlpha) {
                        this.alpha += 0.1f * this.multiplier;
                        if (this.alpha > this.targetAlpha) {
                            this.alpha = this.targetAlpha;
                        }
                    }
                }
                this.xd += this.random.nextDouble() * (this.random.nextBoolean() ? 1.0 : -1.0) / 5000.0;
                this.yd -= (double)this.gravity;
                this.zd += this.random.nextDouble() * (this.random.nextBoolean() ? 1.0 : -1.0) / 5000.0;
                this.move(this.xd, this.yd, this.zd);
                if (this.y == this.yo) {
                    if (!this.blocked) {
                        this.xdo = this.xd;
                        this.zdo = this.zd;
                    }
                    this.blocked = true;
                    if (Math.abs(this.xd) < Math.abs(this.xdo) + 0.035) {
                        this.xd *= 1.1;
                    }
                    if (Math.abs(this.zd) < Math.abs(this.zdo) + 0.035) {
                        this.zd *= 1.1;
                    }
                } else if (this.blocked) {
                    this.blocked = false;
                    this.xd = Mth.lerp((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.xd, (double)this.xdo);
                    this.zd = Mth.lerp((double)FBPConstants.RANDOM.nextDouble(0.5, 0.9), (double)this.zd, (double)this.zdo);
                }
                if (this.onGround) {
                    this.xd *= 0.9;
                    this.zd *= 0.9;
                }
            }
        }
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void move(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.square((double)100.0)) {
            Vec3 vec = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = y != yo && yo < 0.0;
        if (x != xo) {
            this.xd = 0.0;
        }
        if (z != zo) {
            this.zd = 0.0;
        }
    }

    public ParticleRenderType getRenderType() {
        return FBPConstants.FBP_PARTICLE_RENDER;
    }

    protected int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.isLoaded(pos)) {
            j = this.level.getLightEngine().getRawBrightness(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void render(VertexConsumer buffer, Camera info, float partialTick) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.sprite.getU(this.uo / 4.0f);
            v0 = this.sprite.getV(this.vo / 4.0f);
        }
        float u1 = this.sprite.getU((this.uo + 1.0f) / 4.0f);
        float v1 = this.sprite.getV((this.vo + 1.0f) / 4.0f);
        double posX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - info.getPosition().x;
        double posY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - info.getPosition().y;
        double posZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - info.getPosition().z;
        float scale = Mth.lerp((float)partialTick, (float)this.lastSize, (float)this.quadSize);
        float alpha = Mth.lerp((float)partialTick, (float)this.lastAlpha, (float)this.alpha);
        int light = this.getLightColor(partialTick);
        Vector3d[] cube = new Vector3d[this.rotatedCube.length];
        for (int i = 0; i < cube.length; ++i) {
            Vector3d corner = new Vector3d();
            corner.x = this.rotatedCube[i].x;
            corner.y = this.rotatedCube[i].y;
            corner.z = this.rotatedCube[i].z;
            corner.mul((double)(scale / 20.0f));
            corner.add(posX, posY, posZ);
            cube[i] = corner;
        }
        this.putCube(buffer, cube, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, light, this.rCol, this.gCol, this.bCol, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    private void putCube(VertexConsumer buffer, Vector3d[] cube, Vector2f[] uv, int light, float rCol, float gCol, float bCol, float alpha, boolean cartoon) {
        float brightness = 1.0f;
        for (int i = 0; i < cube.length; i += 4) {
            Vector3d vec0 = cube[i];
            Vector3d vec1 = cube[i + 1];
            Vector3d vec2 = cube[i + 2];
            Vector3d vec3 = cube[i + 3];
            float red = rCol * brightness;
            float green = gCol * brightness;
            float blue = bCol * brightness;
            brightness *= 0.875f;
            if (cartoon) {
                this.addVertex(buffer, vec0, uv[0].x, uv[0].y, light, red, green, blue, alpha);
                this.addVertex(buffer, vec1, uv[0].x, uv[0].y, light, red, green, blue, alpha);
                this.addVertex(buffer, vec2, uv[0].x, uv[0].y, light, red, green, blue, alpha);
                this.addVertex(buffer, vec3, uv[0].x, uv[0].y, light, red, green, blue, alpha);
                continue;
            }
            this.addVertex(buffer, vec0, uv[0].x, uv[0].y, light, red, green, blue, alpha);
            this.addVertex(buffer, vec1, uv[1].x, uv[1].y, light, red, green, blue, alpha);
            this.addVertex(buffer, vec2, uv[2].x, uv[2].y, light, red, green, blue, alpha);
            this.addVertex(buffer, vec3, uv[3].x, uv[3].y, light, red, green, blue, alpha);
        }
    }

    private void addVertex(VertexConsumer buffer, Vector3d pos, float u, float v, int light, float rCol, float gCol, float bCol, float alpha) {
        buffer.vertex(pos.x, pos.y, pos.z).uv(u, v).color(rCol, gCol, bCol, alpha).uv2(light).endVertex();
    }

    public record Provider(boolean isSignal) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect() && !FancyBlockParticles.CONFIG.campfireSmoke.isSpawnWhileFrozen()) {
                return null;
            }
            return new FBPCampfireSmokeParticle(level, x, y, z, xd, yd, zd, this.isSignal, Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.QUARTZ_BLOCK.defaultBlockState()));
        }
    }
}

