/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.platform;

import hantonik.fbp.platform.services.IClientHelper;
import hantonik.fbp.platform.services.IPlatformHelper;
import hantonik.fbp.platform.services.IRegistryHelper;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;

public final class Services {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final IClientHelper CLIENT = Services.load(IClientHelper.class);
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IRegistryHelper REGISTRY = Services.load(IRegistryHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.debug(MarkerManager.getMarker((String)"SERVICES"), "Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    @Generated
    private Services() {
    }
}

