/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.animation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPPlacingAnimationParticle;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_2281;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_638;
import net.minecraft.class_703;

public final class FBPPlacingAnimationManager {
    private static final Map<class_2338, FBPPlacingAnimationParticle> ACTIVE_ANIMATIONS = Maps.newHashMap();
    private static final Set<class_2338> HIDDEN_BLOCKS = Sets.newCopyOnWriteArraySet();

    public static void addAnimation(class_638 level, class_2680 state, class_2338 pos, class_1309 placer, class_1268 hand) {
        if (!(!FancyBlockParticles.CONFIG.animations.isEnabled() || !FancyBlockParticles.CONFIG.isBlockAnimationsEnabled(state.method_26204()) || state.method_26164(class_3481.field_16443) || state.method_26204() instanceof class_2320 || state.method_26204() instanceof class_2323 || state.method_28498((class_2769)class_2281.field_10770) && state.method_11654((class_2769)class_2281.field_10770) == class_2745.field_12569 || !(class_310.method_1551().field_1719.method_19538().method_1022(pos.method_46558()) <= (double)((Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 16)))) {
            FBPPlacingAnimationParticle animation = new FBPPlacingAnimationParticle(level, state, pos, placer, hand);
            FBPPlacingAnimationParticle oldAnimation = ACTIVE_ANIMATIONS.put(pos, animation);
            if (oldAnimation != null) {
                oldAnimation.method_3085();
                ACTIVE_ANIMATIONS.remove(pos);
            }
            FBPPlacingAnimationManager.hideBlock(pos);
            class_310.method_1551().field_1713.method_3058((class_703)animation);
        }
    }

    public static void hideBlock(class_2338 pos) {
        HIDDEN_BLOCKS.add(pos);
    }

    public static void showBlock(class_2338 pos, boolean removeAnimation) {
        FBPPlacingAnimationParticle animation;
        if (HIDDEN_BLOCKS.remove(pos)) {
            FBPPlacingAnimationManager.markBlockForRender(pos);
        }
        if (removeAnimation && (animation = ACTIVE_ANIMATIONS.remove(pos)) != null) {
            animation.method_3085();
        }
    }

    public static boolean isHidden(class_2338 pos) {
        return pos != null && HIDDEN_BLOCKS.contains(pos);
    }

    private static void markBlockForRender(class_2338 pos) {
        class_638 level = class_310.method_1551().field_1687;
        class_2680 state = level.method_8320(pos);
        level.method_8413(pos, state, state, 2);
    }

    public static void clear() {
        for (class_2338 pos : HIDDEN_BLOCKS) {
            FBPPlacingAnimationManager.showBlock(pos, true);
        }
        HIDDEN_BLOCKS.clear();
        ACTIVE_ANIMATIONS.clear();
    }

    @Generated
    private FBPPlacingAnimationManager() {
    }
}

