/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen.component.widget.button;

import java.text.DecimalFormat;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_7919;

public class FBPSliderButton
extends class_357 {
    private final class_2561 prefix;
    private final class_2561 suffix;
    private final double minValue;
    private final double maxValue;
    private final double defaultValue;
    private final double stepSize;
    private final Consumer<FBPSliderButton> action;
    private final BooleanSupplier active;
    private final DecimalFormat format;

    public FBPSliderButton(int width, int height, class_2561 prefix, class_2561 suffix, double value, double defaultValue, double minValue, double maxValue, double step, Consumer<FBPSliderButton> action, BooleanSupplier active, class_7919 tooltip) {
        this(0, 0, width, height, prefix, suffix, value, defaultValue, minValue, maxValue, step, action, active, tooltip);
    }

    public FBPSliderButton(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double value, double defaultValue, double minValue, double maxValue, double step, Consumer<FBPSliderButton> action, BooleanSupplier active, class_7919 tooltip) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.action = action;
        this.active = active;
        this.stepSize = Math.abs(step);
        this.field_22753 = this.snapToNearest((value - minValue) / (maxValue - minValue));
        this.defaultValue = defaultValue;
        this.format = step == 0.0 || this.stepSize == Math.floor(this.stepSize) ? new DecimalFormat("0") : new DecimalFormat(String.valueOf(this.stepSize).replaceAll("\\d", "0"));
        this.method_25346();
        this.method_47400(tooltip);
    }

    public double getValue() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    public float getValueFloat() {
        return (float)this.getValue();
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void setValue(double value) {
        this.field_22753 = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.method_25346();
        this.method_25344();
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.field_22753 + (double)(f / (float)(this.field_22758 - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    public void setSliderValue(double value) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(value);
        if (oldValue != this.field_22753) {
            this.method_25344();
        }
        this.method_25346();
    }

    public double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    public void method_25346() {
        this.method_25355((class_2561)this.prefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)this.getValueString()).method_10852(this.suffix).method_27692(Math.abs(this.getValue() - this.defaultValue) < this.stepSize ? class_124.field_1062 : class_124.field_1075)));
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.field_22763 = this.active.getAsBoolean();
        this.method_25344();
        graphics.method_52706(class_1921::method_62277, this.method_52716(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        graphics.method_52706(class_1921::method_62277, this.method_52717(), this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364());
        this.method_49604(graphics, class_310.method_1551().field_1772, 2, (this.active.getAsBoolean() ? 0xFFFFFF : 0xA0A0A0) | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    public void method_25344() {
        this.action.accept(this);
    }
}

