/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.platform.services;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.platform.services.IClientHelper;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.ShaderRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderAccess;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fml.ModList;

public final class ForgeClientHelper
implements IClientHelper {
    @Override
    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return Minecraft.getInstance().level.getShade(normalX, normalY, normalZ, shade);
    }

    @Override
    public void renderBlock(ClientLevel level, BakedModel model, BlockState state, BlockPos pos, PoseStack stack, MultiBufferSource.BufferSource bufferSource) {
        for (RenderType type : model.getRenderTypes(state, RandomSource.create((long)state.getSeed(pos)), ModelData.EMPTY)) {
            VertexConsumer buffer = bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)type));
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, state, pos, stack, buffer, false, RandomSource.create(), state.getSeed(pos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, type);
        }
    }

    @Override
    public ShaderInstance getParticleTranslucentShader() {
        return ModList.get().isLoaded("oculus") ? ShaderAccess.getParticleTranslucentShader() : IClientHelper.super.getParticleTranslucentShader();
    }

    @Override
    public ShaderInstance getBlockTranslucentShader() {
        ShaderRenderingPipeline shaderPipeline;
        ShaderInstance shader;
        WorldRenderingPipeline pipeline;
        if (ModList.get().isLoaded("oculus") && (pipeline = Iris.getPipelineManager().getPipelineNullable()) instanceof ShaderRenderingPipeline && (shader = (shaderPipeline = (ShaderRenderingPipeline)pipeline).getShaderMap().getShader(ShaderKey.MOVING_BLOCK)) != null) {
            return shader;
        }
        return IClientHelper.super.getBlockTranslucentShader();
    }
}

