/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.animation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPPlacingAnimationParticle;
import hantonik.fbp.platform.Services;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public final class FBPPlacingAnimationManager {
    private static final Map<BlockPos, FBPPlacingAnimationParticle> ACTIVE_ANIMATIONS = Maps.newHashMap();
    private static final Set<BlockPos> HIDDEN_BLOCKS = Sets.newConcurrentHashSet();

    public static void addAnimation(ClientLevel level, BlockState state, BlockPos pos, LivingEntity placer, InteractionHand hand) {
        if (Services.PLATFORM.isModLoaded("a_good_place")) {
            return;
        }
        if (!(!FancyBlockParticles.CONFIG.animations.isEnabled() || !FancyBlockParticles.CONFIG.isBlockAnimationsEnabled(state.m_60734_()) || state.m_204336_(BlockTags.f_13038_) || state.m_60734_() instanceof DoublePlantBlock || state.m_60734_() instanceof DoorBlock || state.m_61138_((Property)ChestBlock.f_51479_) && state.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE || !(Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(pos.m_252807_()) <= (double)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() * 16)))) {
            FBPPlacingAnimationParticle animation = new FBPPlacingAnimationParticle(level, state, pos, placer, hand);
            FBPPlacingAnimationParticle oldAnimation = ACTIVE_ANIMATIONS.put(pos, animation);
            if (oldAnimation != null) {
                oldAnimation.m_107274_();
                ACTIVE_ANIMATIONS.remove(pos);
            }
            FBPPlacingAnimationManager.hideBlock(pos);
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)animation);
        }
    }

    public static void hideBlock(BlockPos pos) {
        HIDDEN_BLOCKS.add(pos);
    }

    public static void showBlock(BlockPos pos, boolean removeAnimation) {
        FBPPlacingAnimationParticle animation;
        if (HIDDEN_BLOCKS.remove(pos)) {
            FBPPlacingAnimationManager.markBlockForRender(pos);
        }
        if (removeAnimation && (animation = ACTIVE_ANIMATIONS.remove(pos)) != null) {
            animation.m_107274_();
        }
    }

    public static boolean isHidden(BlockPos pos) {
        return pos != null && HIDDEN_BLOCKS.contains(pos);
    }

    private static void markBlockForRender(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockState state = level.m_8055_(pos);
        level.m_7260_(pos, state, state, 2);
    }

    public static void clear() {
        for (BlockPos pos : HIDDEN_BLOCKS) {
            FBPPlacingAnimationManager.showBlock(pos, true);
        }
        HIDDEN_BLOCKS.clear();
        ACTIVE_ANIMATIONS.clear();
    }

    @Generated
    private FBPPlacingAnimationManager() {
    }
}

