/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.animation.FBPPlacingAnimationManager;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.platform.Services;
import hantonik.fbp.util.FBPConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.compress.utils.Lists;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FBPPlacingAnimationParticle
extends Particle
implements IKillableParticle {
    private final BlockState state;
    private final BlockPos pos;
    private final BakedModel model;
    private final Vec3 rotation;
    private final Vec2 slide;
    private final float angleY;
    private boolean killToggle;

    public FBPPlacingAnimationParticle(ClientLevel level, BlockState state, BlockPos pos, LivingEntity placer, InteractionHand hand) {
        super(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        this.state = state;
        this.pos = pos;
        this.model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        this.f_107225_ = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.animations.getMinLifetime(), FancyBlockParticles.CONFIG.animations.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.animations.getMinLifetime(), FancyBlockParticles.CONFIG.animations.getMaxLifetime()) + 0.5f);
        Vector3f horizontalLook = placer.m_20154_().m_252839_().mul(-1.0f, 0.0f, -1.0f).normalize();
        float handMultiplier = placer.m_5737_() == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        Matrix3f changeOfBasis = new Matrix3f((Vector3fc)new Vector3f(horizontalLook.z, 0.0f, -horizontalLook.x).mul(hand == InteractionHand.MAIN_HAND ? handMultiplier : -handMultiplier), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)horizontalLook);
        this.rotation = FBPConstants.ANIMATION_ROTATION;
        Vector3f translation = FBPConstants.ANIMATION_TRANSLATION.m_252839_();
        float slidePow = translation.length();
        if (placer.m_146909_() <= 0.0f) {
            translation.mul(1.0f, -1.0f, 1.0f);
        }
        Vector3f slideDir = this.adjustDirection(level, placer, translation.mul((Matrix3fc)changeOfBasis));
        Vec3 animationDir = new Vec3(slideDir.normalize());
        this.angleY = (float)Math.atan2(slideDir.x, slideDir.z);
        Vec3 yRot = animationDir.m_82524_(-this.angleY);
        this.slide = new Vec2((float)yRot.f_82481_, (float)yRot.f_82480_).m_165903_(slidePow);
        this.f_107219_ = false;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (!FancyBlockParticles.CONFIG.animations.isEnabled() || !FancyBlockParticles.CONFIG.isBlockAnimationsEnabled(this.state.m_60734_())) {
            this.m_107274_();
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            if (this.killToggle) {
                this.m_107274_();
            }
            ++this.f_107224_;
            if (this.f_107224_ == this.f_107225_ + 1) {
                FBPPlacingAnimationManager.showBlock(this.pos, false);
            }
            if (this.f_107224_ >= this.f_107225_ + 2) {
                this.m_107274_();
            }
        }
        if (this.f_107208_.m_8055_(this.pos) != this.state) {
            this.m_107274_();
        }
    }

    public void m_107274_() {
        FBPPlacingAnimationManager.showBlock(this.pos, true);
        super.m_107274_();
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public int m_6355_(float partialTick) {
        return this.f_107208_.m_46805_(this.pos) ? LevelRenderer.m_109537_((BlockAndTintGetter)this.f_107208_, (BlockState)this.state, (BlockPos)this.pos) : 0;
    }

    public void m_5744_(VertexConsumer buffer, Camera info, float partialTick) {
        PoseStack stack = new PoseStack();
        double posX = Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - info.m_90583_().f_82479_ + 0.5;
        double posY = Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - info.m_90583_().f_82480_ + 0.5;
        double posZ = Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - info.m_90583_().f_82481_ + 0.5;
        stack.m_85837_(posX, posY, posZ);
        float progress = Math.min(1.0f, ((float)this.f_107224_ + partialTick) / ((float)this.f_107225_ + 1.0f));
        Vec3 offset = this.state.m_60824_((BlockGetter)this.f_107208_, this.pos);
        stack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        stack.m_252781_(Axis.f_252436_.m_252961_(this.angleY));
        this.slideIn(stack, progress);
        this.rotate(stack, progress);
        this.scale(stack, progress);
        stack.m_252781_(Axis.f_252436_.m_252961_(-this.angleY));
        stack.m_85837_(-offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
        stack.m_252880_(-0.5f, -0.5f, -0.5f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Services.CLIENT.renderBlock(this.f_107208_, this.model, this.state, this.pos, stack, bufferSource);
        bufferSource.m_109911_();
    }

    private void slideIn(PoseStack stack, float progress) {
        Vec2 translate = this.slide.m_165903_(1.0f - this.exponent(0.9f, progress));
        stack.m_252880_(0.0f, translate.f_82471_, translate.f_82470_);
    }

    private void rotate(PoseStack stack, float progress) {
        Vector3f rotation = this.rotation.m_82490_((double)(1.0f - this.exponent(-0.08f, progress))).m_252839_();
        Vector3f pivot = FBPConstants.ANIMATION_PIVOT.m_252839_();
        if ((double)this.slide.f_82471_ < 0.0) {
            pivot.mul(1.0f, -1.0f, 1.0f);
            rotation.mul(-1.0f, 1.0f, -1.0f);
        }
        stack.m_252880_(pivot.x, pivot.y, pivot.z);
        stack.m_252781_(Axis.f_252529_.m_252961_(rotation.x));
        stack.m_252781_(Axis.f_252436_.m_252961_(rotation.y));
        stack.m_252781_(Axis.f_252403_.m_252961_(rotation.z));
        stack.m_252880_(-pivot.x, -pivot.y, -pivot.z);
    }

    private void scale(PoseStack stack, float progress) {
        float startScale = FancyBlockParticles.CONFIG.animations.getSizeMultiplier();
        float scale = startScale + (1.0f - startScale) * this.exponent(-0.7f, progress);
        stack.m_85841_(scale, scale, scale);
    }

    private Vector3f adjustDirection(ClientLevel level, LivingEntity placer, Vector3f slideDir) {
        ArrayList emptyDirections = Lists.newArrayList();
        for (Direction side : Direction.values()) {
            BlockPos sidePos = this.pos.m_121945_(side);
            VoxelShape sideCollision = level.m_8055_(sidePos).m_60812_((BlockGetter)level, sidePos);
            if (sideCollision.m_83281_()) {
                emptyDirections.add(side);
                continue;
            }
            if (side.m_122421_() == Direction.AxisDirection.POSITIVE) {
                if (!(sideCollision.m_83288_(side.m_122434_()) > 0.25)) continue;
                emptyDirections.add(side);
                continue;
            }
            if (!(sideCollision.m_83288_(side.m_122434_()) < 0.75)) continue;
            emptyDirections.add(side);
        }
        List<Direction> affectedDirections = FBPPlacingAnimationParticle.getAffectedDirections(slideDir.x, slideDir.y, slideDir.z);
        for (Direction side : affectedDirections) {
            if (emptyDirections.contains(side)) continue;
            slideDir.sub((Vector3fc)side.m_253071_().absolute().mul((Vector3fc)slideDir));
        }
        if (!emptyDirections.isEmpty() && slideDir.length() == 0.0f) {
            List<Direction> nearestDirections = List.of(Direction.m_122382_((Entity)placer));
            emptyDirections.sort(Comparator.comparingInt(nearestDirections::indexOf));
            slideDir.set((Vector3fc)((Direction)emptyDirections.get(0)).m_253071_());
        }
        return slideDir;
    }

    private static List<Direction> getAffectedDirections(float x, float y, float z) {
        return (List)Util.m_137469_((Object)Lists.newArrayList(), list -> {
            if (x > 0.0f) {
                list.add(Direction.EAST);
            }
            if (x < 0.0f) {
                list.add(Direction.WEST);
            }
            if (y > 0.0f) {
                list.add(Direction.UP);
            }
            if (y < 0.0f) {
                list.add(Direction.DOWN);
            }
            if (z > 0.0f) {
                list.add(Direction.SOUTH);
            }
            if (z < 0.0f) {
                list.add(Direction.NORTH);
            }
        });
    }

    private float exponent(float curve, float time) {
        double base = curve > 0.0f ? -Math.log(curve) : Math.log(-curve) - 1.0;
        return (float)(base * Math.pow(1.0 / base + 1.0, time) - base);
    }
}

