/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.FBPSmokeParticle;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class FBPRainParticle
extends WaterDropParticle
implements IKillableParticle {
    private final double angleY;
    private final float uo;
    private final float vo;
    private final float multiplier;
    private final float targetSize;
    private float height;
    private float lastAlpha;
    private float lastSize;
    private float lastHeight;
    private boolean killToggle;
    private boolean visible;

    public FBPRainParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, TextureAtlasSprite sprite) {
        super(level, x, y, z);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_108321_ = sprite;
        this.f_107225_ = FBPConstants.RANDOM.nextInt(50, 70);
        this.targetSize = Math.max(FBPConstants.RANDOM.nextFloat(FancyBlockParticles.CONFIG.rain.getSizeMultiplier() - 0.1f, FancyBlockParticles.CONFIG.rain.getSizeMultiplier() + 0.1f) * 4.0f, 0.1f) * (FancyBlockParticles.CONFIG.rain.isRandomSize() ? FBPConstants.RANDOM.nextFloat(0.7f, 1.0f) : 1.0f);
        this.f_107663_ = 0.0f;
        this.f_107226_ = 0.025f * FancyBlockParticles.CONFIG.rain.getGravityMultiplier();
        Vec3 color = this.f_107208_.m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), 0.0f);
        this.f_107227_ = (float)color.f_82479_;
        this.f_107228_ = (float)Mth.m_14008_((double)(color.f_82480_ + 0.1), (double)0.1, (double)1.0);
        this.f_107229_ = (float)Mth.m_14008_((double)(color.f_82480_ + 0.5), (double)0.5, (double)1.0);
        this.f_107230_ = FancyBlockParticles.CONFIG.rain.getTransparency();
        this.f_107219_ = true;
        this.angleY = FBPConstants.RANDOM.nextDouble() * 45.0;
        this.uo = this.f_107223_.m_188501_() * 3.0f;
        this.vo = this.f_107223_.m_188501_() * 3.0f;
        this.multiplier = FancyBlockParticles.CONFIG.rain.isRandomFadingSpeed() ? FBPConstants.RANDOM.nextFloat(0.85f, 1.0f) : 1.0f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.lastAlpha = this.f_107230_;
        this.lastSize = this.f_107663_;
        this.lastHeight = this.height;
        if (!FancyBlockParticles.CONFIG.global.isEnabled() || !FancyBlockParticles.CONFIG.rain.isEnabled()) {
            this.m_107274_();
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            if (this.killToggle) {
                this.m_107274_();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                ++this.f_107224_;
                if (this.f_107213_ < Minecraft.m_91087_().f_91074_.m_20186_() - (double)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()).intValue() * 9.0) {
                    this.m_107274_();
                }
                if (!this.f_107218_) {
                    if (this.f_107224_ < this.f_107225_) {
                        float max = FancyBlockParticles.CONFIG.rain.getSizeMultiplier() * 0.5f;
                        if (this.f_107663_ < max) {
                            this.f_107663_ += 0.05f * this.multiplier;
                            if (this.f_107663_ > max) {
                                this.f_107663_ = max;
                            }
                            this.height = this.f_107663_;
                        }
                    } else {
                        this.m_107274_();
                    }
                }
                this.f_107216_ -= 0.04 * (double)this.f_107226_;
                this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
                this.f_107216_ *= 1.00025;
                if (this.f_107218_) {
                    this.f_107215_ = 0.0;
                    this.f_107217_ = 0.0;
                    if (FancyBlockParticles.CONFIG.rain.isPuddle()) {
                        this.f_107216_ = -0.25;
                        if (this.height > 0.075f) {
                            this.height *= 0.725f;
                        }
                        if (this.f_107663_ < this.targetSize) {
                            this.f_107663_ += this.targetSize / 10.0f;
                            if (this.f_107663_ > this.targetSize) {
                                this.f_107663_ = this.targetSize;
                            }
                        }
                        if (this.f_107663_ >= this.targetSize / 2.0f) {
                            this.f_107230_ *= 0.75f * this.multiplier;
                            if (this.f_107230_ < 0.01f) {
                                this.m_107274_();
                            }
                        } else {
                            this.f_107230_ = FancyBlockParticles.CONFIG.rain.getTransparency();
                        }
                    } else {
                        this.f_107663_ *= 0.85f * this.multiplier;
                        this.height = this.f_107663_;
                        if (this.f_107230_ >= 0.01f) {
                            this.f_107230_ *= 0.75f * this.multiplier;
                        }
                        if (this.f_107230_ < 0.01f) {
                            this.m_107274_();
                        }
                    }
                } else {
                    this.f_107230_ = FancyBlockParticles.CONFIG.rain.getTransparency();
                }
                BlockState state = this.f_107208_.m_8055_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_).m_121945_(Direction.DOWN));
                if (this.isInLava(this.m_107277_()) || (state.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)state)) && this.f_107218_) {
                    this.m_107274_();
                    Minecraft.m_91087_().f_91061_.m_107344_(new FBPSmokeParticle.Provider(this.f_107663_ / 5.0f).createParticle(ParticleTypes.f_123762_, this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.05, 0.0));
                }
            }
        }
        Vec3 vec3 = new Vec3(this.f_107212_, Minecraft.m_91087_().f_91075_.m_20186_(), this.f_107214_);
        if (Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(vec3) > (double)(Math.min(FancyBlockParticles.CONFIG.rain.getSimulationDistance(), (Integer)Minecraft.m_91087_().f_91066_.m_232001_().m_231551_()) * 16)) {
            this.m_107274_();
        }
        this.visible = Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(new Vec3(this.f_107212_, Minecraft.m_91087_().f_91075_.m_20186_(), this.f_107214_)) <= (double)(Math.min(FancyBlockParticles.CONFIG.rain.getRenderDistance(), (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()) * 16);
    }

    private boolean isInLava(AABB box) {
        if (!this.touchingUnloadedChunk()) {
            box = box.m_82406_(0.001);
            int minX = Mth.m_14107_((double)box.f_82288_);
            int maxX = Mth.m_14165_((double)box.f_82291_);
            int minY = Mth.m_14107_((double)box.f_82289_);
            int maxY = Mth.m_14165_((double)box.f_82292_);
            int minZ = Mth.m_14107_((double)box.f_82290_);
            int maxZ = Mth.m_14165_((double)box.f_82293_);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                        FluidState fluidState = this.f_107208_.m_6425_(pos);
                        if (!fluidState.m_205070_(FluidTags.f_13132_) || !((double)(fluidState.m_76155_((BlockGetter)this.f_107208_, pos) + (float)y) >= box.f_82289_)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        Vec3 center = this.m_107277_().m_82400_(1.0).m_82399_();
        return !this.f_107208_.m_46749_(BlockPos.m_274561_((double)center.f_82479_, (double)center.f_82480_, (double)center.f_82481_));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void m_6257_(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.m_144952_((double)100.0)) {
            Vec3 vec = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = vec.f_82479_;
            y = vec.f_82480_;
            z = vec.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = y != yo && yo < 0.0;
        if (x != xo) {
            this.f_107215_ = 0.0;
        }
        if (z != zo) {
            this.f_107217_ = 0.0;
        }
    }

    public ParticleRenderType m_7556_() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    protected int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        int j = 0;
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (this.f_107208_.m_46749_(pos)) {
            j = this.f_107208_.m_5518_().m_75831_(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void m_5744_(VertexConsumer buffer, Camera info, float partialTick) {
        if (!this.visible) {
            return;
        }
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.f_108321_.m_118367_(this.uo / 4.0f);
            v0 = this.f_108321_.m_118393_(this.vo / 4.0f);
        }
        float u1 = this.f_108321_.m_118367_((this.uo + 1.0f) / 4.0f);
        float v1 = this.f_108321_.m_118393_((this.vo + 1.0f) / 4.0f);
        double posX = Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - info.m_90583_().f_82479_;
        double posY = Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - info.m_90583_().f_82480_;
        double posZ = Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - info.m_90583_().f_82481_;
        float width = Mth.m_14179_((float)partialTick, (float)this.lastSize, (float)this.f_107663_) / 10.0f;
        float height = Mth.m_14179_((float)partialTick, (float)this.lastHeight, (float)this.height) / 10.0f;
        float alpha = Mth.m_14179_((float)partialTick, (float)this.lastAlpha, (float)this.f_107230_);
        int light = this.m_6355_(partialTick);
        Vector3d smoothRotation = new Vector3d(0.0, this.angleY, 0.0);
        FBPRenderHelper.renderCubeShaded(buffer, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, posX, posY + (double)height, posZ, width, height, smoothRotation, light, this.f_107227_, this.f_107228_, this.f_107229_, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    public record Provider() implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                return null;
            }
            return new FBPRainParticle(level, x, y, z, 0.1, -FBPConstants.RANDOM.nextDouble(0.65, 0.85), 0.1, Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(Blocks.f_49990_.m_49966_()));
        }
    }
}

