/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.particle.IKillableParticle;
import hantonik.fbp.util.FBPConstants;
import hantonik.fbp.util.FBPRenderHelper;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FBPTerrainParticle
extends TerrainParticle
implements IKillableParticle {
    private final Vector3d rotation;
    private final Vector3d rotationStep;
    private final Vector3d lastRotation;
    private final float multiplier;
    private final boolean destroyed;
    private final double startY;
    private final float scaleAlpha;
    private float lastAlpha;
    private float lastSize;
    private double lastXSpeed;
    private double lastZSpeed;
    private boolean wasFrozen;
    private boolean wasInWater;
    private boolean killToggle;
    private boolean modeDebounce;

    public FBPTerrainParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float scale, float rCol, float gCol, float bCol, BlockPos pos, BlockState state, @Nullable Direction side, @Nullable TextureAtlasSprite sprite) {
        super(level, x, y, z, xd, yd, zd, state, pos);
        this.f_108280_ = pos;
        if (!state.m_60713_(Blocks.f_50440_) || side == Direction.UP) {
            int i = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)this.f_107208_, pos, 0);
            this.f_107227_ = (float)(i >> 16 & 0xFF) / 255.0f;
            this.f_107228_ = (float)(i >> 8 & 0xFF) / 255.0f;
            this.f_107229_ = (float)(i & 0xFF) / 255.0f;
        } else {
            this.f_107227_ = rCol;
            this.f_107228_ = gCol;
            this.f_107229_ = bCol;
        }
        if ((double)scale < -1.0 && side == Direction.UP && FancyBlockParticles.CONFIG.terrain.isSmartBreaking()) {
            this.f_107215_ *= 1.5;
            this.f_107216_ *= 0.1;
            this.f_107217_ *= 1.5;
            double speed = Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_);
            double cameraXRot = Minecraft.m_91087_().f_91075_.m_20154_().f_82479_;
            double cameraZRot = Minecraft.m_91087_().f_91075_.m_20154_().f_82481_;
            this.f_107215_ = (cameraXRot < 0.0 ? cameraXRot - 0.01 : cameraXRot + 0.01) * speed;
            this.f_107217_ = (cameraZRot < 0.0 ? cameraZRot - 0.01 : cameraZRot + 0.01) * speed;
        }
        float size = (double)scale > -1.0 ? scale : this.f_107663_;
        this.f_107663_ = FancyBlockParticles.CONFIG.terrain.getSizeMultiplier() * (FancyBlockParticles.CONFIG.terrain.isRandomSize() ? size : 1.0f) / 10.0f;
        this.f_107226_ *= FancyBlockParticles.CONFIG.terrain.getGravityMultiplier();
        this.f_107225_ = (int)FBPConstants.RANDOM.nextFloat(Math.min(FancyBlockParticles.CONFIG.terrain.getMinLifetime(), FancyBlockParticles.CONFIG.terrain.getMaxLifetime()), (float)Math.max(FancyBlockParticles.CONFIG.terrain.getMinLifetime(), FancyBlockParticles.CONFIG.terrain.getMaxLifetime()) + 0.5f);
        this.startY = this.f_107213_;
        this.scaleAlpha = this.f_107663_ * 0.82f;
        this.rotation = new Vector3d();
        this.lastRotation = new Vector3d();
        this.rotationStep = new Vector3d(FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0, FBPConstants.RANDOM.nextDouble() > 0.5 ? 1.0 : -1.0);
        this.rotation.set((Vector3dc)this.rotationStep);
        boolean bl = this.modeDebounce = !FancyBlockParticles.CONFIG.terrain.isRandomRotation();
        if (this.modeDebounce) {
            this.rotation.zero();
            this.calculateYAngle();
        }
        boolean bl2 = this.destroyed = side == null;
        if (sprite == null) {
            List quads;
            if (!this.destroyed && !(quads = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state).m_213637_(state, side, this.f_107223_)).isEmpty()) {
                this.f_108321_ = ((BakedQuad)quads.get(0)).m_173410_();
            }
            if (this.f_108321_.m_247685_() == MissingTextureAtlasSprite.m_118071_()) {
                this.f_108321_ = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state);
            }
        } else {
            this.f_108321_ = sprite;
        }
        this.multiplier = FancyBlockParticles.CONFIG.terrain.isRandomFadingSpeed() ? Mth.m_14036_((float)FBPConstants.RANDOM.nextFloat(0.5f, 0.9f), (float)0.6f, (float)0.8f) : 0.75f;
        this.m_6569_(1.0f);
    }

    public Particle m_6569_(float scale) {
        super.m_6569_(scale);
        float size = this.f_107663_ / 10.0f;
        if (FancyBlockParticles.CONFIG.terrain.isRestOnFloor() && this.destroyed) {
            this.f_107213_ = this.startY - (double)size;
        }
        this.f_107210_ = this.f_107213_;
        this.m_107259_(new AABB(this.f_107212_ - (double)size, this.f_107213_ - (double)size, this.f_107214_ - (double)size, this.f_107212_ + (double)size, this.f_107213_ + (double)size, this.f_107214_ + (double)size));
        return this;
    }

    public FBPTerrainParticle setPower(float power) {
        super.m_107268_(power);
        this.f_107216_ = (this.f_107216_ - 0.1) * (double)(this.multiplier / 2.0f) + (double)0.1f;
        return this;
    }

    public FBPTerrainParticle setYSpeed(double yd) {
        this.f_107216_ = yd;
        return this;
    }

    public void m_5989_() {
        if (FancyBlockParticles.CONFIG.terrain.isBounceOffWalls()) {
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!Minecraft.m_91087_().m_91104_() && this.f_107224_ > 0) {
                    if (!this.wasFrozen && (Math.abs(this.f_107215_) > 1.0E-5 || Math.abs(this.f_107217_) > 1.0E-5)) {
                        if (this.f_107209_ == this.f_107212_) {
                            this.f_107215_ = -this.lastXSpeed * 0.625;
                        }
                        if (this.f_107211_ == this.f_107214_) {
                            this.f_107217_ = -this.lastZSpeed * 0.625;
                        }
                        if (!(FancyBlockParticles.CONFIG.terrain.isRandomRotation() || this.f_107209_ != this.f_107212_ && this.f_107211_ != this.f_107214_)) {
                            this.calculateYAngle();
                        }
                    } else {
                        this.wasFrozen = false;
                    }
                }
            } else {
                this.wasFrozen = true;
            }
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.lastRotation.set((Vector3dc)this.rotation);
        this.lastSize = this.f_107663_;
        this.lastAlpha = this.f_107230_;
        if (!(FancyBlockParticles.CONFIG.global.isEnabled() && ((!this.destroyed || FancyBlockParticles.CONFIG.terrain.isFancyBreakingParticles() || FancyBlockParticles.CONFIG.terrain.isFancyFallingDustParticles()) && (this.destroyed || FancyBlockParticles.CONFIG.terrain.isFancyCrackingParticles()) || FancyBlockParticles.CONFIG.misc.isFancySnowballParticles() || FancyBlockParticles.CONFIG.misc.isFancySlimeParticles() || FancyBlockParticles.CONFIG.misc.isFancyBreakingSplashPotionParticles()))) {
            this.m_107274_();
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            if (this.killToggle) {
                this.m_107274_();
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                    if (!this.modeDebounce) {
                        this.modeDebounce = true;
                        this.rotation.z = 0.0;
                        this.calculateYAngle();
                    }
                    double x = Math.abs(this.rotationStep.x * this.getMultiplier());
                    if (this.f_107215_ > 0.0) {
                        if (this.f_107217_ > 0.0) {
                            this.rotation.x -= x;
                        } else if (this.f_107217_ < 0.0) {
                            this.rotation.x += x;
                        }
                    } else if (this.f_107215_ < 0.0) {
                        if (this.f_107217_ < 0.0) {
                            this.rotation.x += x;
                        } else if (this.f_107217_ > 0.0) {
                            this.rotation.x -= x;
                        }
                    }
                } else {
                    if (this.modeDebounce) {
                        this.modeDebounce = false;
                        this.rotation.z = FBPConstants.RANDOM.nextDouble(30.0, 400.0);
                    }
                    this.rotation.add((Vector3dc)this.rotationStep.mul(this.getMultiplier(), new Vector3d()));
                }
                if (!FancyBlockParticles.CONFIG.terrain.isInfiniteDuration() && !FancyBlockParticles.CONFIG.global.isInfiniteDuration()) {
                    ++this.f_107224_;
                }
                if (this.f_107224_ >= this.f_107225_) {
                    this.f_107663_ *= 0.9f * this.multiplier;
                    if ((double)this.f_107230_ >= 0.01 && this.f_107663_ <= this.scaleAlpha) {
                        this.f_107230_ *= 0.7f * this.multiplier;
                    }
                    if ((double)this.f_107230_ < 0.01) {
                        this.m_107274_();
                    }
                }
                this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
                if (this.f_107218_ && FancyBlockParticles.CONFIG.terrain.isRestOnFloor()) {
                    this.rotation.x = (double)Math.round(this.rotation.x / 10.0) * 10.0;
                    this.rotation.z = (double)Math.round(this.rotation.z / 10.0) * 10.0;
                }
                if (Math.abs(this.f_107215_) > 1.0E-5) {
                    this.lastXSpeed = this.f_107215_;
                }
                if (Math.abs(this.f_107217_) > 1.0E-5) {
                    this.lastZSpeed = this.f_107217_;
                }
                this.f_107215_ *= 0.98;
                this.f_107217_ *= 0.98;
                this.f_107216_ *= 0.98;
                if (!this.f_107208_.m_45772_(this.m_107277_().m_82406_(1.0E-7))) {
                    this.moveTowardsClosestSpace(this.f_107212_, (this.m_107277_().f_82289_ + this.m_107277_().f_82292_) / 2.0, this.f_107214_);
                }
                if (FancyBlockParticles.CONFIG.terrain.isEntityCollision()) {
                    List entities = this.f_107208_.m_45933_(null, this.m_107277_());
                    for (Entity entity : entities) {
                        if (entity.f_19794_) continue;
                        double x = this.f_107212_ - entity.m_20182_().f_82479_;
                        double y = this.f_107213_ - entity.m_20182_().f_82480_;
                        double z = this.f_107214_ - entity.m_20182_().f_82481_;
                        double distance = Mth.m_14005_((double)Mth.m_14005_((double)x, (double)y), (double)z);
                        if (!(distance >= 0.01)) continue;
                        distance = Math.sqrt(distance);
                        double d = Math.min(1.0 / distance, 1.0);
                        this.f_107215_ += (x /= distance) * d / 20.0;
                        this.f_107216_ += (y /= distance) * d / 20.0 - 0.04 * (double)this.f_107226_;
                        this.f_107217_ += (z /= distance) * d / 20.0;
                        if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                            this.calculateYAngle();
                        }
                        if (FancyBlockParticles.CONFIG.global.isFreezeEffect()) continue;
                        this.f_107218_ = false;
                    }
                }
                if (FancyBlockParticles.CONFIG.terrain.isWaterPhysics() && this.isInWater(this.m_107277_())) {
                    this.f_107215_ *= 0.95;
                    this.f_107217_ *= 0.95;
                    if (this.f_107216_ > -0.005 && this.f_107216_ < 0.005) {
                        this.f_107216_ = 0.005;
                    }
                    this.f_107216_ = this.f_107216_ < 0.0 ? (this.f_107216_ *= 0.79 * FBPConstants.RANDOM.nextDouble(0.8, 1.2)) : (this.f_107216_ *= 1.1 * FBPConstants.RANDOM.nextDouble(0.75, 0.9));
                    if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                        this.calculateYAngle();
                    }
                    this.f_107218_ = false;
                    this.wasInWater = true;
                } else {
                    if (!this.f_107218_) {
                        this.f_107216_ -= (this.wasInWater ? 0.02 : 0.04) * (double)this.f_107226_;
                    }
                    this.wasInWater = false;
                }
                if (this.f_107218_) {
                    if (FancyBlockParticles.CONFIG.terrain.isLowTraction()) {
                        this.f_107215_ *= 0.932;
                        this.f_107217_ *= 0.932;
                    } else {
                        this.f_107215_ *= 0.665;
                        this.f_107217_ *= 0.665;
                    }
                }
            }
        }
    }

    private void moveTowardsClosestSpace(double x, double y, double z) {
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Vec3 vec = new Vec3(x - (double)pos.m_123341_(), y - (double)pos.m_123342_(), z - (double)pos.m_123343_());
        BlockPos.MutableBlockPos relativePos = new BlockPos.MutableBlockPos();
        double minDistance = Double.MAX_VALUE;
        Direction distanceDirection = Direction.UP;
        for (Direction direction : Direction.values()) {
            double distance;
            relativePos.m_122159_((Vec3i)pos, direction);
            if (this.f_107208_.m_8055_((BlockPos)relativePos).m_60838_((BlockGetter)this.f_107208_, (BlockPos)relativePos)) continue;
            double axisDistance = vec.m_82507_(direction.m_122434_());
            double d = distance = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - axisDistance : axisDistance;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            distanceDirection = direction;
        }
        int step = distanceDirection.m_122421_().m_122540_();
        float rand = this.f_107223_.m_188501_() * 0.1f + 0.1f;
        Vec3 movement = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82490_(0.75);
        this.f_107215_ = movement.f_82479_;
        this.f_107216_ = movement.f_82480_;
        this.f_107217_ = movement.f_82481_;
        switch (distanceDirection.m_122434_()) {
            case X: {
                this.f_107215_ = (float)step * rand;
                break;
            }
            case Y: {
                this.f_107216_ = (float)step * rand;
                break;
            }
            case Z: {
                this.f_107217_ = (float)step * rand;
            }
        }
        this.f_107218_ = false;
    }

    private boolean isInWater(AABB box) {
        if (!this.touchingUnloadedChunk()) {
            box = box.m_82406_(0.001);
            int minX = Mth.m_14107_((double)box.f_82288_);
            int maxX = Mth.m_14165_((double)box.f_82291_);
            int minY = Mth.m_14107_((double)box.f_82289_);
            int maxY = Mth.m_14165_((double)box.f_82292_);
            int minZ = Mth.m_14107_((double)box.f_82290_);
            int maxZ = Mth.m_14165_((double)box.f_82293_);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                        FluidState fluid = this.f_107208_.m_6425_(pos);
                        if (!fluid.m_205070_(FluidTags.f_13131_) || !((double)(fluid.m_76155_((BlockGetter)this.f_107208_, pos) + (float)y) >= box.f_82289_)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean touchingUnloadedChunk() {
        Vec3 center = this.m_107277_().m_82400_(1.0).m_82399_();
        return !this.f_107208_.m_46749_(BlockPos.m_274561_((double)center.f_82479_, (double)center.f_82480_, (double)center.f_82481_));
    }

    @Override
    public void killParticle() {
        this.killToggle = true;
    }

    public void m_6257_(double x, double y, double z) {
        double xo = x;
        double yo = y;
        double zo = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < Mth.m_144952_((double)100.0)) {
            Vec3 vec = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = vec.f_82479_;
            y = vec.f_82480_;
            z = vec.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = y != yo && yo < 0.0;
        if (!FancyBlockParticles.CONFIG.terrain.isLowTraction() && !FancyBlockParticles.CONFIG.terrain.isBounceOffWalls()) {
            if (x != xo) {
                this.f_107215_ *= 0.7;
            }
            if (z != zo) {
                this.f_107217_ *= 0.7;
            }
        }
    }

    protected void m_107275_() {
        super.m_107275_();
        AABB box = this.m_107277_();
        this.f_107213_ = (box.f_82289_ + box.f_82292_) / 2.0;
    }

    public ParticleRenderType m_7556_() {
        return FBPConstants.FBP_TERRAIN_RENDER;
    }

    public int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        int j = 0;
        AABB box = this.m_107277_();
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ + (box.f_82292_ - box.f_82289_) * 0.66 + 0.01 - (FancyBlockParticles.CONFIG.terrain.isRestOnFloor() ? (double)this.f_107663_ / 10.0 : 0.0)), (double)this.f_107214_);
        if (this.f_107208_.m_46749_(pos)) {
            j = this.f_107208_.m_5518_().m_75831_(pos, 0);
        }
        return i == 0 ? j : i;
    }

    public void m_5744_(VertexConsumer buffer, Camera info, float partialTick) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        if (!FancyBlockParticles.CONFIG.global.isCartoonMode()) {
            u0 = this.f_108321_.m_118367_(this.f_108277_ / 4.0f);
            v0 = this.f_108321_.m_118393_(this.f_108278_ / 4.0f);
        }
        float u1 = this.f_108321_.m_118367_((this.f_108277_ + 1.0f) / 4.0f);
        float v1 = this.f_108321_.m_118393_((this.f_108278_ + 1.0f) / 4.0f);
        double posX = Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - info.m_90583_().f_82479_;
        double posY = Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - info.m_90583_().f_82480_;
        double posZ = Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - info.m_90583_().f_82481_;
        float scale = Mth.m_14179_((float)partialTick, (float)this.lastSize, (float)this.f_107663_);
        float alpha = Mth.m_14179_((float)partialTick, (float)this.lastAlpha, (float)this.f_107230_);
        int light = this.m_6355_(partialTick);
        if (FancyBlockParticles.CONFIG.terrain.isRestOnFloor()) {
            posY += (double)scale;
        }
        Vector3d smoothRotation = new Vector3d();
        if (FancyBlockParticles.CONFIG.terrain.getRotationMultiplier() > 0.0f) {
            smoothRotation.y = this.rotation.y;
            smoothRotation.z = this.rotation.z;
            if (!FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                smoothRotation.x = this.rotation.x;
            }
            if (!FancyBlockParticles.CONFIG.global.isFreezeEffect()) {
                if (FancyBlockParticles.CONFIG.terrain.isRandomRotation()) {
                    smoothRotation.y = Mth.m_14139_((double)partialTick, (double)this.lastRotation.y, (double)this.rotation.y);
                    smoothRotation.z = Mth.m_14139_((double)partialTick, (double)this.lastRotation.z, (double)this.rotation.z);
                } else {
                    smoothRotation.x = Mth.m_14139_((double)partialTick, (double)this.lastRotation.x, (double)this.rotation.x);
                }
            }
        }
        FBPRenderHelper.renderCubeShaded(buffer, new Vector2f[]{new Vector2f(u1, v1), new Vector2f(u1, v0), new Vector2f(u0, v0), new Vector2f(u0, v1)}, (float)posX, (float)posY, (float)posZ, scale, smoothRotation, light, this.f_107227_, this.f_107228_, this.f_107229_, alpha, FancyBlockParticles.CONFIG.global.isCartoonMode());
    }

    private void calculateYAngle() {
        double sin = Math.toDegrees(Math.asin(this.f_107215_ / Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_)));
        this.rotation.y = this.f_107217_ > 0.0 ? -sin : sin;
    }

    private double getMultiplier() {
        return Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_) * (FancyBlockParticles.CONFIG.terrain.isRandomRotation() ? 200.0 : 500.0) * (double)FancyBlockParticles.CONFIG.terrain.getRotationMultiplier();
    }

    public record Provider(BlockPos pos, float scale, @Nullable Direction side, @Nullable TextureAtlasSprite sprite, float rCol, float gCol, float bCol) implements ParticleProvider<BlockParticleOption>
    {
        @Nullable
        public FBPTerrainParticle createParticle(BlockParticleOption type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new FBPTerrainParticle(level, x, y, z, xd, yd, zd, this.scale, this.rCol, this.gCol, this.bCol, this.pos, type.m_123642_(), this.side, this.sprite);
        }
    }
}

