/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.screen.component.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import hantonik.fbp.util.BlacklistMode;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FBPBlacklistButton
extends Button {
    private static final ResourceLocation WIDGETS = new ResourceLocation("fbp", "textures/gui/widgets.png");
    private final boolean particle;
    private final BlacklistMode blacklistMode;

    public FBPBlacklistButton(int x, int y, boolean particle, BlacklistMode blacklistMode, Button.OnPress onPress) {
        super(x, y, 60, 60, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.particle = particle;
        this.blacklistMode = blacklistMode;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.blit(WIDGETS, this.getX(), this.getY(), this.getOffset(), 196, 60, 60);
        graphics.blit(WIDGETS, (int)((float)this.getX() + (float)this.width / 2.0f - 22.5f + (this.particle ? 0.0f : 2.0f)), (int)((float)this.getY() + (float)this.height / 2.0f - 22.5f), 211, this.particle ? 45 : 0, 45, 45);
    }

    private int getOffset() {
        return switch (this.blacklistMode) {
            default -> throw new MatchException(null, null);
            case BlacklistMode.FANCY -> 0;
            case BlacklistMode.VANILLA -> 60;
            case BlacklistMode.BLACKLISTED -> 120;
        };
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int radius;
        int centerY;
        int centerX = this.getX() + this.height / 2;
        double distance = Math.sqrt((mouseX - (double)centerX) * (mouseX - (double)centerX) + (mouseY - (double)(centerY = this.getY() + this.height / 2 - 1)) * (mouseY - (double)centerY));
        return distance <= (double)(radius = (this.height - 1) / 2);
    }

    @Generated
    public BlacklistMode getBlacklistMode() {
        return this.blacklistMode;
    }
}

